/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.history;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.transaction.IUndoRedoProvider;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.List;

public final class HistoryStateFilePersistence {
    private final TFile m_historyDirectory;

    public HistoryStateFilePersistence(TFile historyDirectory) {
        assert (historyDirectory != null) : "Parameter 'historyDirectory' of method 'HistoryProcessor' must not be null";
        this.m_historyDirectory = historyDirectory;
    }

    public OperationResultWithOutcome<TFile> saveState(IModifiableFile modifiableFile, String identifier, IUndoRedoProvider undoRedoProvider) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'saveState' must not be null";
        assert (identifier != null && identifier.length() > 0) : "Parameter 'identifier' of method 'saveState' must not be empty";
        assert (undoRedoProvider != null) : "Parameter 'undoRedoProvider' of method 'saveState' must not be null";
        TFile file = new TFile((File)this.m_historyDirectory, String.valueOf(identifier) + FileUtility.getExtension((TFile)modifiableFile.getFile()));
        OperationResultWithOutcome result = new OperationResultWithOutcome(String.format("Save state for identifier '%s'.", identifier));
        result.setOutcome((Object)file);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TFileOutputStream outStream = new TFileOutputStream((File)file);){
                undoRedoProvider.writeModifiableFileToStream(modifiableFile, (OutputStream)outStream, (OperationResult)result);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
        return result;
    }

    public OperationResultWithOutcome<? extends IModifiableFile> restoreState(IUndoRedoProvider undoRedoProvider, RestoreStateDto dto, EnumSet<Modification> determinedModifications, List<String> otherEntriesOfTx) {
        assert (undoRedoProvider != null) : "Parameter 'undoRedoProvider' of method 'restoreState' must not be null";
        assert (dto != null) : "Parameter 'dto' of method 'restoreState' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreState' must not be null";
        assert (otherEntriesOfTx != null) : "Parameter 'otherEntriesOfTx' of method 'restoreState' must not be null";
        String message = String.format("Restore state from file '%s' for element '%s'", dto.getCurrentStateFileEntry().getPath(), dto.getCurrentStateFileEntry().getIdentifyingPath());
        OperationResultWithOutcome result = new OperationResultWithOutcome(message);
        TFile historyFile = new TFile(dto.getCurrentStateFileEntry().getPath());
        if (!historyFile.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "File to be restored does not exist.", new Object[0]);
            return result;
        }
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (TFileInputStream inputStream = new TFileInputStream((File)historyFile);){
                OperationResultWithOutcome<? extends IModifiableFile> restoreResult = undoRedoProvider.restoreModifiableFileFromStream((InputStream)inputStream, dto, determinedModifications, otherEntriesOfTx);
                if (restoreResult.isFailure()) {
                    restoreResult.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, message, new Object[0]);
                }
                return restoreResult;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, (Throwable)ex);
            return result;
        }
    }
}

