/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.diff;

import com.hello2morrow.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.BasicSystemInfoDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.FeaturesDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SimplePropertyDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.StructureContainerDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.AnalyzersConfigurationDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.AnalyzersDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.MetricLevelThresholdConfigurationDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.MetricThresholdConfigurationDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginConfigurationsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.analyzer.PluginsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateBaselineConditionsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateCurrentConditionsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGateElementDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.qualitygate.QualityGatesDiff;
import com.hello2morrow.sonargraph.core.persistence.diff.AbstractHtmlInfo;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public final class SystemInfo
extends AbstractHtmlInfo {
    private static final String SEPARATOR = " | ";
    private TFile m_targetFile;
    private final SoftwareSystem m_softwareSystem;

    public SystemInfo(SoftwareSystem softwareSystem, SoftwareSystemDiff softwareSystemDiff) {
        super(softwareSystemDiff);
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'BasicInfo' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    public String getTitle() {
        return this.m_softwareSystem.getName();
    }

    public boolean hasChanges() {
        BasicSystemInfoDiff systemInfoDiff = this.getSoftwareSystemDiff().getUniqueExistingChild(BasicSystemInfoDiff.class);
        return systemInfoDiff.getChange() != IDiffElement.Change.UNMODIFIED;
    }

    public void setTargetFile(TFile targetFile) {
        assert (targetFile != null) : "Parameter 'targetFile' of method 'setTargetFile' must not be null";
        this.m_targetFile = targetFile;
    }

    public TFile getTargetFile() {
        return this.m_targetFile;
    }

    public String getSystemDirectoryPath() {
        return this.m_softwareSystem.getSystemDirectoryFile().getNormalizedAbsolutePath();
    }

    public SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    public String getDiffCreationTimeStamp() {
        return Iso8601DateFormat.formatDateAndTimeForUniversalTimezone((Date)new Date(this.getSoftwareSystemDiff().getTimeStampOfDeltaCreation()));
    }

    public String getBaselineReportPath() {
        return this.getSoftwareSystemDiff().getBaselineReport().getNormalizedAbsolutePath();
    }

    public String getBaselineReportTimestamp() {
        return Iso8601DateFormat.formatDateAndTime((Date)new Date(this.getSoftwareSystemDiff().getBaselineTimestamp()));
    }

    public String getBaselineContextInfo() {
        return this.getSoftwareSystemDiff().getBaselineContextInfo();
    }

    public List<SimpleDiff> getSimplePropertyDiffs() {
        return this.removeUnmodifiedChildrenFromList(this.getSoftwareSystemDiff().getUniqueExistingChild(BasicSystemInfoDiff.class).getChildren(SimpleDiff.class));
    }

    public boolean isSystemInfoChanged() {
        return this.getSoftwareSystemDiff().getUniqueExistingChild(BasicSystemInfoDiff.class).getChildren(IDiffElement.class).stream().anyMatch(diff -> diff.getChange() != IDiffElement.Change.UNMODIFIED);
    }

    public List<SimpleDiff> getFeatureDiffs() {
        FeaturesDiff featuresDiff = this.getSoftwareSystemDiff().getUniqueExistingChild(BasicSystemInfoDiff.class).getUniqueChild(FeaturesDiff.class);
        return featuresDiff != null ? this.removeUnmodifiedChildrenFromList(featuresDiff.getChildren(SimpleDiff.class)) : Collections.emptyList();
    }

    public List<SimpleDiff> getAnalyzerDiffs() {
        AnalyzersDiff analyzersDiff = this.getSoftwareSystemDiff().getUniqueExistingChild(BasicSystemInfoDiff.class).getUniqueChild(AnalyzersDiff.class);
        if (analyzersDiff == null) {
            return Collections.emptyList();
        }
        List<SimpleDiff> analyzerDiffs = this.removeUnmodifiedChildrenFromList(analyzersDiff.getChildren(SimpleDiff.class));
        Collections.sort(analyzerDiffs, new Comparator<SimpleDiff>(){

            @Override
            public int compare(SimpleDiff a1, SimpleDiff a2) {
                return a1.getPresentationName(true).compareTo(a2.getPresentationName(true));
            }
        });
        return analyzerDiffs;
    }

    public List<StructureContainerDiff> getAnalyzerConfigurationDiffs() {
        AnalyzersConfigurationDiff analyzersConfigurationDiff = this.getSoftwareSystemDiff().getUniqueExistingChild(BasicSystemInfoDiff.class).getUniqueChild(AnalyzersConfigurationDiff.class);
        if (analyzersConfigurationDiff == null) {
            return Collections.emptyList();
        }
        List<StructureContainerDiff> analyzerConfigurationDiffs = this.removeUnmodifiedChildrenFromList(analyzersConfigurationDiff.getChildren(StructureContainerDiff.class));
        Collections.sort(analyzerConfigurationDiffs, new Comparator<StructureContainerDiff>(){

            @Override
            public int compare(StructureContainerDiff o1, StructureContainerDiff o2) {
                return o1.getPresentationName(true).compareTo(o2.getPresentationName(true));
            }
        });
        return analyzerConfigurationDiffs;
    }

    public List<SimpleDiff> getAnalyzerConfigurationElementDiffs(StructureContainerDiff analyzerConfigurationDiff) {
        assert (analyzerConfigurationDiff != null) : "Parameter 'analyzerConfigurationDiff' of method 'getAnalyzerConfigurationElementDiffs' must not be null";
        return this.removeUnmodifiedChildrenFromList(analyzerConfigurationDiff.getChildren(SimpleDiff.class));
    }

    public List<StrictPair<String, SimpleDiff>> getMetricThresholdDiffs(StructureContainerDiff thresholdAnalyzerDiff) {
        assert (thresholdAnalyzerDiff != null) : "Parameter 'thresholdAnalyzerDiff' of method 'getMetricThresholdDiffs' must not be null";
        ArrayList<StrictPair<String, SimpleDiff>> result = new ArrayList<StrictPair<String, SimpleDiff>>();
        for (MetricLevelThresholdConfigurationDiff nextMetricLevelDiff : this.removeUnmodifiedChildrenFromList(thresholdAnalyzerDiff.getChildren(MetricLevelThresholdConfigurationDiff.class))) {
            String metricLevelName = nextMetricLevelDiff.getPresentationName(true);
            for (MetricThresholdConfigurationDiff nextThresholdConfigDiff : this.removeUnmodifiedChildrenFromList(nextMetricLevelDiff.getChildren(MetricThresholdConfigurationDiff.class))) {
                String thresholdConfigName = metricLevelName + SEPARATOR + nextThresholdConfigDiff.getPresentationName(true);
                for (SimpleDiff valueDiff : this.removeUnmodifiedChildrenFromList(nextThresholdConfigDiff.getChildren(SimpleDiff.class))) {
                    String valueName = thresholdConfigName + SEPARATOR + valueDiff.getPresentationName(true);
                    result.add((StrictPair<String, SimpleDiff>)new StrictPair((Object)valueName, (Object)valueDiff));
                }
            }
        }
        return result;
    }

    public List<SimpleDiff> getPluginDiffs() {
        PluginsDiff pluginsDiff = this.getSoftwareSystemDiff().getUniqueExistingChild(BasicSystemInfoDiff.class).getUniqueChild(PluginsDiff.class);
        return pluginsDiff != null ? this.removeUnmodifiedChildrenFromList(pluginsDiff.getChildren(SimpleDiff.class)) : Collections.emptyList();
    }

    public List<StructureContainerDiff> getPluginConfigurationDiffs() {
        PluginConfigurationsDiff configurationsDiff = this.getSoftwareSystemDiff().getUniqueExistingChild(BasicSystemInfoDiff.class).getUniqueChild(PluginConfigurationsDiff.class);
        if (configurationsDiff == null) {
            return Collections.emptyList();
        }
        return this.removeUnmodifiedChildrenFromList(configurationsDiff.getChildren(StructureContainerDiff.class));
    }

    public List<SimpleDiff> getPluginConfigurationElementDiffs(StructureContainerDiff pluginConfigurationDiff) {
        assert (pluginConfigurationDiff != null) : "Parameter 'pluginConfigurationDiff' of method 'getPluginConfigurationElementDiffs' must not be null";
        ArrayList<SimpleDiff> result = new ArrayList<SimpleDiff>();
        for (SimpleDiff nextConfigEntryDiff : this.removeUnmodifiedChildrenFromList(pluginConfigurationDiff.getChildren(SimpleDiff.class))) {
            result.add(nextConfigEntryDiff);
        }
        return result;
    }

    public List<QualityGateDiff> getQualityGateDiffs() {
        QualityGatesDiff qualityGatesDiff = this.getSoftwareSystemDiff().getUniqueExistingChild(BasicSystemInfoDiff.class).getUniqueChild(QualityGatesDiff.class);
        return qualityGatesDiff != null ? this.removeUnmodifiedChildrenFromList(qualityGatesDiff.getChildren(QualityGateDiff.class)) : Collections.emptyList();
    }

    public List<QualityGateElementDiff> getCurrentSystemConditionDiffs(QualityGateDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getCurrentSystemConditionDiffs' must not be null";
        QualityGateCurrentConditionsDiff currentConditionsDiff = diff.getUniqueChild(QualityGateCurrentConditionsDiff.class);
        return currentConditionsDiff != null ? this.removeUnmodifiedChildrenFromList(currentConditionsDiff.getChildren(QualityGateElementDiff.class)) : Collections.emptyList();
    }

    public List<QualityGateElementDiff> getBaselineConditionDiffs(QualityGateDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getBaselineConditionDiffs' must not be null";
        QualityGateBaselineConditionsDiff baselineConditionsDiff = diff.getUniqueChild(QualityGateBaselineConditionsDiff.class);
        return baselineConditionsDiff != null ? this.removeUnmodifiedChildrenFromList(baselineConditionsDiff.getChildren(QualityGateElementDiff.class)) : Collections.emptyList();
    }

    public List<SimplePropertyDiff> getQualityGateElementPropertyDiffs(QualityGateElementDiff diff) {
        assert (diff != null) : "Parameter 'diff' of method 'getQualityGateElementPropertyDiffs' must not be null";
        return this.removeUnmodifiedChildrenFromList(diff.getChildren(SimplePropertyDiff.class));
    }
}

