/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.diff;

import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.FixDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.IgnoreDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.RefactoringDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ResolutionsDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.TaskDefinitionDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.resolution.ToDoDefinitionDiff;
import com.hello2morrow.sonargraph.core.persistence.diff.AbstractHtmlInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ResolutionInfo
extends AbstractHtmlInfo {
    private final ResolutionsDiff m_resolutionsDiff;
    private final List<ResolutionDefinitionDiff> m_ignoreDiffs;
    private final List<TaskDefinitionDiff> m_taskDiffs;
    private final List<RefactoringDefinitionDiff> m_refactoringDiffs;

    public ResolutionInfo(SoftwareSystemDiff softwareSystemDiff) {
        super(softwareSystemDiff);
        this.m_resolutionsDiff = softwareSystemDiff.getUniqueExistingChild(ResolutionsDiff.class);
        this.m_ignoreDiffs = new ArrayList<IgnoreDefinitionDiff>(this.removeUnmodifiedChildrenFromList(this.m_resolutionsDiff.getChildren(IgnoreDefinitionDiff.class)));
        this.sort(this.m_ignoreDiffs);
        this.m_taskDiffs = new ArrayList<FixDefinitionDiff>(this.removeUnmodifiedChildrenFromList(this.m_resolutionsDiff.getChildren(FixDefinitionDiff.class)));
        this.m_taskDiffs.addAll(this.removeUnmodifiedChildrenFromList(this.m_resolutionsDiff.getChildren(ToDoDefinitionDiff.class)));
        this.sort(this.m_taskDiffs);
        this.m_refactoringDiffs = this.removeUnmodifiedChildrenFromList(this.m_resolutionsDiff.getChildren(RefactoringDefinitionDiff.class));
        this.sort(this.m_refactoringDiffs);
    }

    public List<ResolutionDefinitionDiff> getIgnoreChanges() {
        return this.m_ignoreDiffs;
    }

    public boolean hasIgnoreChanges() {
        return this.m_ignoreDiffs.stream().anyMatch(i2 -> i2.getChange() != IDiffElement.Change.UNMODIFIED);
    }

    public List<TaskDefinitionDiff> getTaskChanges() {
        return this.m_taskDiffs;
    }

    public boolean hasTaskChanges() {
        return this.m_taskDiffs.stream().anyMatch(t2 -> t2.getChange() != IDiffElement.Change.UNMODIFIED);
    }

    public List<RefactoringDefinitionDiff> getRefactoringChanges() {
        return this.m_refactoringDiffs;
    }

    public boolean hasRefactoringChanges() {
        return this.m_refactoringDiffs.stream().anyMatch(r2 -> r2.getChange() != IDiffElement.Change.UNMODIFIED);
    }

    public String getChangeDescription(TaskDefinitionDiff taskDiff) {
        assert (taskDiff != null) : "Parameter 'taskDiff' of method 'getChangeDescription' must not be null";
        return taskDiff.getChange() == IDiffElement.Change.MODIFIED ? taskDiff.getChangeDescription() : "";
    }

    private void sort(List<? extends ResolutionDefinitionDiff> result) {
        Collections.sort(result, new Comparator<ResolutionDefinitionDiff>(){

            @Override
            public int compare(ResolutionDefinitionDiff o1, ResolutionDefinitionDiff o2) {
                return Integer.compare(o1.getChange().ordinal(), o2.getChange().ordinal());
            }
        });
    }
}

