/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.dashboard;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.dashboard.AdditionalDetailsSeparator;
import com.hello2morrow.sonargraph.core.model.dashboard.Box;
import com.hello2morrow.sonargraph.core.model.dashboard.Dashboard;
import com.hello2morrow.sonargraph.core.model.dashboard.IssueCounter;
import com.hello2morrow.sonargraph.core.model.dashboard.Metric;
import com.hello2morrow.sonargraph.core.model.dashboard.QualityGateStatusElement;
import com.hello2morrow.sonargraph.core.model.dashboard.RedYellowGreenElement;
import com.hello2morrow.sonargraph.core.model.dashboard.ResolutionCounter;
import com.hello2morrow.sonargraph.core.model.dashboard.Row;
import com.hello2morrow.sonargraph.core.model.dashboard.Separator;
import com.hello2morrow.sonargraph.core.model.dashboard.SimpleMetricChartType;
import com.hello2morrow.sonargraph.core.model.dashboard.SourceFileDiscriminationElement;
import com.hello2morrow.sonargraph.core.model.dashboard.SystemInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionApplicability;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionMode;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.dashboard.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdAdditionalDetails;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdBox;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdChart;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdDashboard;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdIssueCategory;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdIssueCounter;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdIssueResolutionKind;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdIssueSeverity;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdMetric;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdRedYellowGreenChart;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdResolutionApplicability;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdResolutionCounter;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdResolutionKind;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdRow;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdSeparator;
import com.hello2morrow.sonargraph.core.persistence.dashboard.XsdSystemInfo;
import com.hello2morrow.sonargraph.integration.access.foundation.a;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;

public final class DashboardPersistence {
    private static final String XSD_PACKAGE_NAME = "com.hello2morrow.sonargraph.core.persistence.dashboard";
    private static final String SCHEMA_URL = "com/hello2morrow/sonargraph/core/persistence/dashboard/dashboard";
    private static final String PROVIDER_CORE = "Core";
    private static final String PROVIDER_SCRIPT = "Script";
    private final XmlPersistenceContext m_persistenceContext;
    private final a m_classLoader;
    private final IMetricsProvider m_metricsProvider;
    private final Set<Language> m_availableLanguages;

    public DashboardPersistence(Version version, a classLoader, IMetricsProvider metricsProvider, Set<Language> availableLanguages) {
        assert (version != null) : "Parameter 'version' of method 'DashboardPersistence' must not be null";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'DashboardPersistence' must not be null";
        assert (metricsProvider != null) : "Parameter 'metricsProvider' of method 'DashboardPersistence' must not be null";
        assert (availableLanguages != null) : "Parameter 'availableLanguages' of method 'DashboardPersistence' must not be null";
        this.m_persistenceContext = new XmlPersistenceContext(XSD_PACKAGE_NAME, CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
        this.m_classLoader = classLoader;
        this.m_metricsProvider = metricsProvider;
        this.m_availableLanguages = new HashSet<Language>(availableLanguages);
    }

    public OperationResult load(TFile dashboardFile, Dashboard dashboard) {
        assert (dashboardFile != null) : "Parameter 'dashboardFile' of method 'load' must not be null";
        assert (dashboard != null) : "Parameter 'dashboard' of method 'load' must not be null";
        OperationResult result = new OperationResult("Load dashboard from '" + dashboardFile.getName() + "'");
        if (!dashboardFile.exists() || !dashboardFile.canRead()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, String.format("Cannot read dashboard file '%s'", dashboardFile.getNormalizedAbsolutePath()), new Object[0]);
            return result;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream in = new FileInputStream((File)dashboardFile);){
                OperationResult loadResult = this.load(in, dashboard);
                result.addMessagesFrom(loadResult);
                if (result.isFailure()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, String.format("Failed to process dashboard file '%s'", dashboardFile.getNormalizedAbsolutePath()), new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, String.format("Cannot read dashboard file '%s'", dashboardFile.getNormalizedAbsolutePath()), new Object[]{e2});
        }
        return result;
    }

    private String getMetricIdPrefix(String provider) {
        assert (provider != null && provider.length() > 0) : "Parameter 'provider' of method 'getMetricIdPrefix' must not be empty";
        if (provider.equals("CPlusPlus")) {
            return "Cpp";
        }
        if (provider.equals("CSharp")) {
            return "Cs";
        }
        if (provider.equals(PROVIDER_SCRIPT)) {
            return "";
        }
        return provider;
    }

    private Language getLanguage(String provider) {
        for (Language nextLanguage : this.m_availableLanguages) {
            if (!nextLanguage.getStandardName().equals(provider)) continue;
            return nextLanguage;
        }
        return null;
    }

    public OperationResult load(InputStream in, Dashboard dashboard) {
        assert (in != null) : "Parameter 'in' of method 'load' must not be null";
        OperationResultWithOutcome<XsdDashboard> result = this.loadFromStream(in);
        if (result.isSuccess()) {
            XsdDashboard xsdDashboard = (XsdDashboard)result.getOutcome();
            int rowCounter = 1;
            int numberOfSeparators = 0;
            THashSet systemInfoKinds = new THashSet();
            THashSet metrics = new THashSet();
            for (XsdRow xsdRow : xsdDashboard.getRow()) {
                Row row = new Row(dashboard, Integer.toString(rowCounter++));
                dashboard.addChild(row);
                for (XsdBox xsdBox : xsdRow.getBox()) {
                    Box box = new Box(row, xsdBox.getName(), xsdBox.getImageName());
                    boolean detailsSeparatorCreated = false;
                    for (Object next : xsdBox.getSystemInfoOrMetricOrChart()) {
                        if (next instanceof XsdSystemInfo) {
                            this.handleSystemInfo(box, (XsdSystemInfo)next, (Set<SystemInfo.Kind>)systemInfoKinds, (OperationResult)result);
                            continue;
                        }
                        if (next instanceof XsdChart) {
                            this.handleChart(box, (XsdChart)next, result);
                            continue;
                        }
                        if (next instanceof XsdRedYellowGreenChart) {
                            XsdRedYellowGreenChart xsdRygChart = (XsdRedYellowGreenChart)next;
                            box.addChild(this.createRedYellowGreenChart(xsdRygChart, box, (OperationResult)result));
                            continue;
                        }
                        if (next instanceof XsdMetric) {
                            this.handleMetricInfo(box, (XsdMetric)next, (Set<String>)metrics, (OperationResult)result);
                            continue;
                        }
                        if (next instanceof XsdIssueCounter) {
                            this.handleIssueCounter(box, (XsdIssueCounter)next, (OperationResult)result);
                            continue;
                        }
                        if (next instanceof XsdResolutionCounter) {
                            this.handleResolutionCounter(box, (XsdResolutionCounter)next, (OperationResult)result);
                            continue;
                        }
                        if (next instanceof XsdSeparator) {
                            XsdSeparator xsdSeparator = (XsdSeparator)next;
                            Language language = this.getLanguage(xsdSeparator.getProvider());
                            if (xsdSeparator.getProvider() != null && language == null) continue;
                            box.addChild(new Separator(box, "S" + Integer.toString(numberOfSeparators), xsdSeparator.getName(), xsdSeparator.getImageName(), language));
                            ++numberOfSeparators;
                            continue;
                        }
                        if (next instanceof XsdAdditionalDetails) {
                            if (!detailsSeparatorCreated) {
                                box.addChild(new AdditionalDetailsSeparator(box));
                                detailsSeparatorCreated = true;
                                continue;
                            }
                            assert (false) : "only one AdditionalDetailsSeparator allowed per box!";
                            continue;
                        }
                        assert (false) : "Unhandled box element: " + next.getClass().getName();
                    }
                    row.addChild(box);
                }
            }
        }
        return result;
    }

    private void handleChart(Box box, XsdChart xsdChart, OperationResultWithOutcome<XsdDashboard> result) {
        assert (box != null) : "Parameter 'box' of method 'handleChart' must not be null";
        assert (xsdChart != null) : "Parameter 'xsdChart' of method 'handleChart' must not be null";
        assert (result != null) : "Parameter 'result' of method 'handleChart' must not be null";
        switch (xsdChart.getType()) {
            case QUALITY_GATES_STATUS: {
                box.addChild(new QualityGateStatusElement(box, xsdChart.getName()));
                break;
            }
            case SOURCE_FILE_DISCRIMINATION: {
                box.addChild(new SourceFileDiscriminationElement(box, xsdChart.getName()));
                break;
            }
            default: {
                assert (false) : "Unsupported chart type: " + (Object)((Object)xsdChart.getType());
                break;
            }
        }
    }

    private NamedElement createRedYellowGreenChart(XsdRedYellowGreenChart xsdRygChart, Box box, OperationResult result) {
        assert (xsdRygChart != null) : "Parameter 'xsdRygChart' of method 'createRedYellowGreenChart' must not be null";
        assert (box != null) : "Parameter 'box' of method 'createRedYellowGreenChart' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createRedYellowGreenChart' must not be null";
        String provider = xsdRygChart.getProvider();
        String level = CoreMetricLevel.SYSTEM.getStandardName();
        IMetricDescriptor metric = xsdRygChart.getMetricId() != null ? this.getMetricDescriptor(xsdRygChart.getMetricId(), provider, level, result) : null;
        IMetricDescriptor redMetric = this.getMetricDescriptor(xsdRygChart.getRedMetricId(), provider, level, result);
        IMetricDescriptor redAndYelloMetric = this.getMetricDescriptor(xsdRygChart.redAndYellowMetricId, provider, level, result);
        IMetricDescriptor allMetric = this.getMetricDescriptor(xsdRygChart.getAllMetricId(), provider, level, result);
        String description = xsdRygChart.getDescription();
        if (description == null && metric != null) {
            description = metric.getDescription();
        }
        RedYellowGreenElement ryg = new RedYellowGreenElement(box, xsdRygChart.getLabel(), description, metric, redMetric, redAndYelloMetric, allMetric, xsdRygChart.getRedDescription(), xsdRygChart.getYellowDescription(), xsdRygChart.getGreenDescription());
        return ryg;
    }

    private IMetricDescriptor getMetricDescriptor(String metricId, String provider, String level, OperationResult result) {
        String idPrefix = this.getMetricIdPrefix(provider);
        IMetricDescriptor metric = this.m_metricsProvider.findMetricByIdAndLevel(String.valueOf(idPrefix) + metricId, level);
        if (metric == null) {
            result.addWarning((OperationResult.IMessageCause)DashboardMessageCause.UNKNOWN_CORE_METRIC, "Provider/Id/Level: " + provider + "/" + metricId + "/" + level, new Object[0]);
            return null;
        }
        return metric;
    }

    private boolean handleIssueCounter(Box box, XsdIssueCounter xsdIssueCounter, OperationResult result) {
        assert (box != null) : "Parameter 'box' of method 'handleIssueCounter' must not be null";
        assert (xsdIssueCounter != null) : "Parameter 'xsdIssueCounter' of method 'handleIssueCounter' must not be null";
        assert (result != null) : "Parameter 'result' of method 'handleIssueCounter' must not be null";
        HashSet<Severity> severities = new HashSet<Severity>();
        HashSet<IssueCategory> categories = new HashSet<IssueCategory>();
        HashSet<ResolutionMode> resolutionModes = new HashSet<ResolutionMode>();
        for (Object nextSeverityOrCategoryOrResolution : xsdIssueCounter.getSeverityOrCategoryOrResolutionKind()) {
            if (nextSeverityOrCategoryOrResolution instanceof XsdIssueSeverity) {
                XsdIssueSeverity nextXsdSeverity = (XsdIssueSeverity)((Object)nextSeverityOrCategoryOrResolution);
                try {
                    severities.add(Severity.fromStandardName(nextXsdSeverity.value()));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    result.addError((OperationResult.IMessageCause)DashboardMessageCause.UNKNOWN_ISSUE_SEVERITY, "Failed to convert value: " + nextXsdSeverity.value(), new Object[0]);
                    return false;
                }
            }
            if (nextSeverityOrCategoryOrResolution instanceof XsdIssueCategory) {
                XsdIssueCategory nextXsdCategory = (XsdIssueCategory)((Object)nextSeverityOrCategoryOrResolution);
                try {
                    categories.add(IssueCategory.fromStandardName(nextXsdCategory.value()));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    result.addError((OperationResult.IMessageCause)DashboardMessageCause.UNKNOWN_ISSUE_CATEGORY, "Failed to convert value: " + nextXsdCategory.value(), new Object[0]);
                    return false;
                }
            }
            assert (nextSeverityOrCategoryOrResolution != null && nextSeverityOrCategoryOrResolution instanceof XsdIssueResolutionKind) : "Unexpected class in method 'load': " + nextSeverityOrCategoryOrResolution;
            XsdIssueResolutionKind nextXsdResolution = (XsdIssueResolutionKind)((Object)nextSeverityOrCategoryOrResolution);
            try {
                resolutionModes.add(ResolutionMode.fromStandardName(nextXsdResolution.value()));
            }
            catch (IllegalArgumentException ex) {
                result.addError((OperationResult.IMessageCause)DashboardMessageCause.UNKNOWN_ISSUE_RESOLUTION_KIND, "Failed to convert value: " + nextXsdResolution.value(), new Object[0]);
                return false;
            }
        }
        IssueCounter nextIssueCounter = new IssueCounter(box, xsdIssueCounter.getName(), severities, categories, resolutionModes);
        box.addChild(nextIssueCounter);
        return true;
    }

    private boolean handleSystemInfo(Box box, XsdSystemInfo xsdSystemInfo, Set<SystemInfo.Kind> systemInfoKinds, OperationResult result) {
        block7: {
            assert (box != null) : "Parameter 'box' of method 'handleSystemInfo' must not be null";
            assert (xsdSystemInfo != null) : "Parameter 'xsdSystemInfo' of method 'handleSystemInfo' must not be null";
            assert (systemInfoKinds != null) : "Parameter 'systemInfoKinds' of method 'handleSystemInfo' must not be null";
            assert (result != null) : "Parameter 'result' of method 'handleSystemInfo' must not be null";
            SystemInfo.Kind kind = SystemInfo.Kind.fromStandardName(xsdSystemInfo.getKind().value());
            if (!systemInfoKinds.add(kind)) break block7;
            box.addChild(new SystemInfo(box, xsdSystemInfo.getName(), kind));
            return true;
        }
        try {
            result.addError((OperationResult.IMessageCause)DashboardMessageCause.DUPLICATE_SYSTEM_INFO_KIND, "Duplicate: " + xsdSystemInfo.getKind().value(), new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            result.addError((OperationResult.IMessageCause)DashboardMessageCause.UNKNOWN_SYSTEM_INFO_KIND, "Failed to convert value: " + xsdSystemInfo.getKind().value(), new Object[0]);
        }
        return false;
    }

    private void handleMetricInfo(Box box, XsdMetric xsdMetric, Set<String> metrics, OperationResult result) {
        SimpleMetricChartType chartType;
        assert (box != null) : "Parameter 'box' of method 'handleMetricInfo' must not be null";
        assert (xsdMetric != null) : "Parameter 'xsdMetric' of method 'handleMetricInfo' must not be null";
        assert (metrics != null) : "Parameter 'metrics' of method 'handleMetricInfo' must not be null";
        assert (result != null) : "Parameter 'result' of method 'handleMetricInfo' must not be null";
        String provider = xsdMetric.getProvider();
        String id = xsdMetric.getId();
        String level = CoreMetricLevel.SYSTEM.getStandardName();
        String idPrefix = this.getMetricIdPrefix(provider);
        boolean isScriptBased = provider.equals(PROVIDER_SCRIPT);
        IMetricDescriptor metricDescriptor = this.getMetricDescriptor(provider, id, idPrefix, level, isScriptBased, result);
        String metricId = String.valueOf(idPrefix) + id + ":" + level;
        if (!metrics.add(metricId)) {
            result.addError((OperationResult.IMessageCause)DashboardMessageCause.DUPLICATE_SYSTEM_INFO_KIND, "Duplicate: " + metricId, new Object[0]);
            return;
        }
        if (xsdMetric.getChart() == null) {
            chartType = SimpleMetricChartType.NONE;
        } else {
            switch (xsdMetric.getChart()) {
                case STACKED_BAR_PERCENT: {
                    chartType = SimpleMetricChartType.STACKED_BAR_PERCENT;
                    break;
                }
                default: {
                    chartType = SimpleMetricChartType.NONE;
                }
            }
        }
        box.addChild(new Metric(box, xsdMetric.getName(), String.valueOf(idPrefix) + id, level, metricDescriptor, this.getLanguage(provider), isScriptBased, chartType));
    }

    private IMetricDescriptor getMetricDescriptor(String provider, String id, String idPrefix, String level, boolean isScriptBased, OperationResult result) {
        IMetricDescriptor metricDescriptor = null;
        Language language = null;
        if (!isScriptBased) {
            boolean isCore = provider.equals(PROVIDER_CORE);
            if (!isCore && (language = this.getLanguage(provider)) == null) {
                return null;
            }
            metricDescriptor = this.m_metricsProvider.findMetricByIdAndLevel(String.valueOf(idPrefix) + id, level);
            if (metricDescriptor == null && isCore) {
                result.addWarning((OperationResult.IMessageCause)DashboardMessageCause.UNKNOWN_CORE_METRIC, "Provider/Id/Level: " + provider + "/" + id + "/" + level, new Object[0]);
                return null;
            }
            return metricDescriptor;
        }
        return null;
    }

    private boolean handleResolutionCounter(Box box, XsdResolutionCounter xsdResolutionCounter, OperationResult result) {
        assert (box != null) : "Parameter 'box' of method 'handleResolutionCounter' must not be null";
        assert (xsdResolutionCounter != null) : "Parameter 'xsdResolutionCounter' of method 'handleResolutionCounter' must not be null";
        assert (result != null) : "Parameter 'result' of method 'handleResolutionCounter' must not be null";
        HashSet<ResolutionKind> resolutionKinds = new HashSet<ResolutionKind>();
        HashSet<ResolutionApplicability> resolutionApplicabilities = new HashSet<ResolutionApplicability>();
        for (Object nextApplicabilityOrKind : xsdResolutionCounter.getApplicabilityOrKind()) {
            if (nextApplicabilityOrKind instanceof XsdResolutionKind) {
                XsdResolutionKind nextXsdResolutionKind = (XsdResolutionKind)((Object)nextApplicabilityOrKind);
                try {
                    resolutionKinds.add(ResolutionKind.fromStandardName(nextXsdResolutionKind.value()));
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    result.addError((OperationResult.IMessageCause)DashboardMessageCause.UNKNOWN_RESOLUTION_KIND, "Failed to convert value: " + nextXsdResolutionKind.value(), new Object[0]);
                    return false;
                }
            }
            XsdResolutionApplicability nextXsdResolutionApplicability = (XsdResolutionApplicability)((Object)nextApplicabilityOrKind);
            try {
                resolutionApplicabilities.add(ResolutionApplicability.fromStandardName(nextXsdResolutionApplicability.value()));
            }
            catch (IllegalArgumentException ex) {
                result.addError((OperationResult.IMessageCause)DashboardMessageCause.UNKNOWN_RESOLUTION_APPLICABILITY, "Failed to convert value: " + nextXsdResolutionApplicability.value(), new Object[0]);
                return false;
            }
        }
        ResolutionCounter nextResolutionCounter = new ResolutionCounter(box, xsdResolutionCounter.getName(), resolutionKinds, resolutionApplicabilities);
        box.addChild(nextResolutionCounter);
        return true;
    }

    private OperationResultWithOutcome<XsdDashboard> loadFromStream(InputStream inputStream) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'internLoadFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading dashboard from stream");
        JaxbAdapter jaxbAdapter = JaxbAccess.createJaxbAdapter(this.m_classLoader, this.m_persistenceContext);
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl((OperationResult)result);
        JAXBElement element = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)eventHandler);
        if (result.isFailure()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Dashboard loaded from stream is corrupt", new Object[0]);
            return result;
        }
        result.setOutcome((Object)((XsdDashboard)element.getValue()));
        return result;
    }

    public OperationResult save(Dashboard dashboard, TFile file) {
        assert (dashboard != null) : "Parameter 'dashboard' of method 'save' must not be null";
        assert (file != null) : "Parameter 'file' of method 'save' must not be null";
        OperationResult result = new OperationResult("Save dashboard to file '" + file.getNormalizedAbsolutePath() + "'");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream out = new FileOutputStream((File)file);){
                OperationResult save = this.save(dashboard, out);
                result.addMessagesFrom(save);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, String.format("Failed to save dashboard to file '%s'", file.getNormalizedAbsolutePath()), new Object[]{e2});
            return result;
        }
    }

    public OperationResult save(Dashboard dashboard, OutputStream out) {
        assert (dashboard != null) : "Parameter 'dashboard' of method 'save' must not be null";
        assert (out != null) : "Parameter 'out' of method 'save' must not be null";
        OperationResult result = new OperationResult("Saving dashboard '" + dashboard.getName() + "'");
        JAXBElement<XsdDashboard> element = this.convertPojoToXml(dashboard);
        if (element == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Failed to convert Dashboard '" + dashboard.getName() + "' to XML.", new Object[0]);
            return result;
        }
        JaxbAdapter jaxbAdapter = JaxbAccess.createJaxbAdapter(this.m_classLoader, this.m_persistenceContext);
        try {
            jaxbAdapter.save(element, out);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
        return result;
    }

    private JAXBElement<XsdDashboard> convertPojoToXml(Dashboard dashboard) {
        assert (dashboard != null) : "Parameter 'dashboard' of method 'convertPojoToXml' must not be null";
        ObjectFactory objectFactory = new ObjectFactory();
        XsdDashboard xsdDashboard = objectFactory.createXsdDashboard();
        JAXBElement<XsdDashboard> element = objectFactory.createDashboard(xsdDashboard);
        return element;
    }

    public OperationResult loadFromClasspath(String name, Dashboard dashboard) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'loadDashboardFromClasspath' must not be empty";
        OperationResult result = new OperationResult("Load dashboard from classpath");
        String dashboardFile = String.valueOf(name) + CoreFileType.DASHBOARD.getDefaultExtension();
        InputStream inputStream = DashboardPersistence.class.getResourceAsStream(dashboardFile);
        if (inputStream == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "'" + dashboardFile + "' not found in classpath.", new Object[0]);
        } else {
            try {
                OperationResult loadResult = this.load(inputStream, dashboard);
                result.addMessagesFrom(loadResult);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private static enum DashboardMessageCause implements OperationResult.IMessageCause
    {
        UNKNOWN_SYSTEM_INFO_KIND,
        DUPLICATE_SYSTEM_INFO_KIND,
        UNKNOWN_QUALITY_GATE_INFO_KIND,
        DUPLICATE_QUALITY_GATE_INFO_KIND,
        UNKNOWN_CORE_METRIC,
        DUPLICATE_METRIC,
        UNKNOWN_ISSUE_SEVERITY,
        UNKNOWN_ISSUE_CATEGORY,
        UNKNOWN_ISSUE_RESOLUTION_KIND,
        UNKNOWN_RESOLUTION_KIND,
        UNKNOWN_RESOLUTION_APPLICABILITY;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

