/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.base;

import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.StringUtility;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;

public final class ValidationEventHandlerImpl
implements ValidationEventHandler {
    private final OperationResult m_operationResult;
    private final String m_sourceInfo;

    public ValidationEventHandlerImpl(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'ValidationEventHandlerImpl' must not be null";
        this.m_operationResult = result;
        this.m_sourceInfo = null;
    }

    public ValidationEventHandlerImpl(OperationResult result, String sourceInfo) {
        assert (result != null) : "Parameter 'result' of method 'ValidationEventHandlerImpl' must not be null";
        assert (sourceInfo != null && sourceInfo.length() > 0) : "Parameter 'sourceInfo' of method 'ValidationEventHandlerImpl' must not be empty";
        this.m_operationResult = result;
        this.m_sourceInfo = sourceInfo;
    }

    public boolean handleEvent(ValidationEvent event) {
        String prepend;
        assert (event != null) : "'event' must not be null";
        boolean returnResult = false;
        ValidationEventLocator locator = event.getLocator();
        String string = prepend = this.m_sourceInfo != null ? "[" + this.m_sourceInfo + "] " : "";
        if (event.getSeverity() == 0) {
            this.m_operationResult.addWarning((OperationResult.IMessageCause)ValidationMessageCauses.XML_VALIDATION_WARNING, String.valueOf(prepend) + event.getMessage() + ValidationEventHandlerImpl.getLocation(locator), new Object[0]);
            returnResult = true;
        } else {
            this.m_operationResult.addError((OperationResult.IMessageCause)ValidationMessageCauses.XML_VALIDATION_ERROR, String.valueOf(prepend) + event.getMessage() + ValidationEventHandlerImpl.getLocation(locator), new Object[0]);
        }
        return returnResult;
    }

    private static String getLocation(ValidationEventLocator locator) {
        if (locator != null) {
            StringBuilder builder = new StringBuilder(" (line:");
            builder.append(locator.getLineNumber());
            builder.append(" col:");
            builder.append(locator.getColumnNumber());
            builder.append(")");
            return builder.toString();
        }
        return "";
    }

    public static enum ValidationMessageCauses implements OperationResult.IMessageCause
    {
        XML_VALIDATION_WARNING,
        XML_VALIDATION_ERROR,
        VERSION_MISMATCH;


        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }
    }
}

