/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.architecture;

import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.foundation.utilities.XmlUtility;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableFilter;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.programming.CoreParserDependencyType;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.system.PersistenceCause;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.architecture.persistence.Architecture;
import com.hello2morrow.sonargraph.integration.architecture.persistence.ArchitectureJaxbAdapter;
import com.hello2morrow.sonargraph.integration.architecture.persistence.ObjectFactory;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdArtifact;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdConnection;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdConnector;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdDependencyRestrictions;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdDependencyType;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdInclude;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdInterface;
import com.hello2morrow.sonargraph.integration.architecture.persistence.XsdStereotype;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public final class ArchitectureXmlPersistence {
    private final ObjectFactory m_factory = new ObjectFactory();

    private XsdConnector exportConnector(Connector conn) {
        XsdConnector xmlConnector = this.m_factory.createXsdConnector();
        xmlConnector.setName(conn.getName());
        xmlConnector.setIsOptional(Boolean.valueOf(conn.isOptional()));
        for (IAssignableFilter filter : conn.getIncludeFilters()) {
            XsdInclude xmlInclude = this.m_factory.createXsdInclude();
            if (filter.isStrong()) {
                xmlInclude.setIsStrong(Boolean.valueOf(true));
            }
            xmlInclude.setValue(filter.getOriginalPattern());
            xmlConnector.getInclude().add(xmlInclude);
        }
        for (IAssignableFilter filter : conn.getExcludeFilters()) {
            xmlConnector.getExclude().add(filter.getOriginalPattern());
        }
        for (Connector included : conn.getIncludedConnectors()) {
            if (included.getParent(Artifact.class, new Class[0]).isDeprecated()) continue;
            xmlConnector.getIncludedConnector().add(included.getName());
        }
        for (Interface iface : conn.getDirectlyConnectedInterfaces()) {
            if (iface.getParent(Artifact.class, new Class[0]).isDeprecated()) continue;
            XsdConnection connection = this.m_factory.createXsdConnection();
            xmlConnector.getConnectTo().add(connection);
            connection.setValue(iface.getName());
        }
        for (Connector parentConnector : conn.getIncludedByConnectorsRecursively()) {
            for (Interface iface : parentConnector.getDirectlyConnectedInterfaces()) {
                if (iface.getParent(Artifact.class, new Class[0]).isDeprecated()) continue;
                XsdConnection connection = this.m_factory.createXsdConnection();
                xmlConnector.getConnectTo().add(connection);
                connection.setValue(iface.getName());
                connection.setViaParentConnector(parentConnector.getName());
            }
        }
        return xmlConnector;
    }

    private XsdInterface exportInterface(Interface iface) {
        XsdInterface xmlInterface = this.m_factory.createXsdInterface();
        xmlInterface.setName(iface.getName());
        xmlInterface.setIsOptional(Boolean.valueOf(iface.isOptional()));
        for (IAssignableFilter filter : iface.getIncludeFilters()) {
            XsdInclude xmlInclude = this.m_factory.createXsdInclude();
            if (filter.isStrong()) {
                xmlInclude.setIsStrong(Boolean.valueOf(true));
            }
            xmlInclude.setValue(filter.getOriginalPattern());
            xmlInterface.getInclude().add(xmlInclude);
        }
        for (IAssignableFilter filter : iface.getExcludeFilters()) {
            xmlInterface.getExclude().add(filter.getOriginalPattern());
        }
        if (iface.hasDependencyTypeRestrictions()) {
            XsdDependencyRestrictions restrictions = this.m_factory.createXsdDependencyRestrictions();
            xmlInterface.setDependencyRestrictions(restrictions);
            for (CoreParserDependencyType depType : iface.getAllowedDependencyTypes()) {
                restrictions.getAllowedDependencyType().add(XsdDependencyType.fromValue((String)depType.name()));
            }
        }
        for (Interface exported : iface.getExportedInterfaces()) {
            if (exported.getParent(Artifact.class, new Class[0]).isDeprecated()) continue;
            xmlInterface.getExport().add(exported.getName());
        }
        return xmlInterface;
    }

    private void addArtifact(Artifact artifact, List<XsdArtifact> list) {
        if (artifact.isDeprecated()) {
            return;
        }
        XsdArtifact xmlArtifact = this.m_factory.createXsdArtifact();
        xmlArtifact.setName(artifact.getName());
        list.add(xmlArtifact);
        for (Artifact.StereoType st : artifact.getStereotypesAsSet()) {
            xmlArtifact.getStereotype().add(XsdStereotype.fromValue((String)st.name()));
        }
        for (IAssignableFilter filter : artifact.getIncludeFilters()) {
            XsdInclude xmlInclude = this.m_factory.createXsdInclude();
            if (filter.isStrong()) {
                xmlInclude.setIsStrong(Boolean.valueOf(true));
            }
            xmlInclude.setValue(filter.getOriginalPattern());
            xmlArtifact.getInclude().add(xmlInclude);
        }
        for (IAssignableFilter filter : artifact.getExcludeFilters()) {
            xmlArtifact.getExclude().add(filter.getOriginalPattern());
        }
        for (Artifact child : artifact.getChildren(Artifact.class)) {
            this.addArtifact(child, xmlArtifact.getArtifact());
        }
        for (Interface iface : artifact.getChildren(Interface.class)) {
            xmlArtifact.getInterface().add(this.exportInterface(iface));
        }
        for (Connector conn : artifact.getChildren(Connector.class)) {
            xmlArtifact.getConnector().add(this.exportConnector(conn));
        }
    }

    private Architecture createXmlObject(ArchitectureFile architectureFile) {
        SoftwareSystem softwareSystem = architectureFile.getParent(SoftwareSystem.class, new Class[0]);
        Architecture architecture = this.m_factory.createArchitecture();
        Version version = softwareSystem.getExtension(ISoftwareSystemProvider.class).getInstallation().getVersion();
        architecture.setVersion(version.toString());
        architecture.setTimestamp(XmlUtility.createDateTimeObject());
        architecture.setSystemPath(softwareSystem.getUniqueExistingChild(Files.class).getSystemDirectory().getFile().getNormalizedAbsolutePath());
        architecture.setSystemId(softwareSystem.getId());
        architecture.setName(architectureFile.getShortName());
        architecture.setModel(architectureFile.getModel().getStandardName());
        for (Artifact artifact : architectureFile.getChildren(Artifact.class)) {
            this.addArtifact(artifact, architecture.getArtifact());
        }
        return architecture;
    }

    public void save(ArchitectureFile architectureFile, TFile targetFilePath, OperationResult result) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'save' must not be null";
        assert (targetFilePath != null) : "Parameter 'targetFilePath' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        Architecture xmlArchitecture = this.createXmlObject(architectureFile);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream output = new FileOutputStream((File)targetFilePath);){
                JaxbAdapter adapter = ArchitectureJaxbAdapter.create();
                adapter.save((Object)xmlArchitecture, (OutputStream)output);
                result.addInfo((OperationResult.IMessageCause)PersistenceCause.SAVE_OPERATION_SUCCESSFUL);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_WRITE_FILE, e2.getMessage(), new Object[0]);
        }
    }
}

