/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.architecturalview;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetrieverProvider;
import com.hello2morrow.sonargraph.core.model.architecture.ParsedPatternInfo;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewDependencyDescriptor;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewOperationList;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactAssignmentMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactFilterOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactIncomingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactOutgoingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactVisibility;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateAllowedArtifactConnectionOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactFromElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateArtifactsForElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateElementOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.CreateFindingOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteDependenciesOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.DeleteElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.EditArtifactOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.EditArtifactsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.HideElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.ManualFilter;
import com.hello2morrow.sonargraph.core.model.explorationview.MoveElementsOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.RenameElementOperation;
import com.hello2morrow.sonargraph.core.model.explorationview.TargetParentOperation;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.ArchitecturalViewPersistenceMessageCause;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdArchitecturalView;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdArtifactAssignmentMode;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdArtifactFilterOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdArtifactIncomingDependencyMode;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdArtifactOutgoingDependencyMode;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdArtifactPropertiesOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdArtifactVisibility;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdCreateAllowedArtifactConnectionOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdCreateArtifactFromElementsOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdCreateArtifactOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdCreateArtifactsForElementsOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdCreateElementOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdCreateFindingOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdDeleteDependenciesOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdDeleteElementsOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdDependency;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdEditArtifactOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdEditArtifactsOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdElementType;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdHideElementsOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdMoveElementsOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdPresentationMode;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdRenameElementOperation;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdStructureMode;
import com.hello2morrow.sonargraph.core.persistence.architecturalview.XsdTargetParentOperation;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;

public final class ArchitecturalViewPersistence {
    private static final String XSD_PACKAGE_NAME = "com.hello2morrow.sonargraph.core.persistence.architecturalview";
    private static final String SCHEMA_URL = "com/hello2morrow/sonargraph/core/persistence/architecturalview/architecturalView";
    private final Version m_version;
    private final IAssignableAttributeRetrieverProvider m_provider;
    private final XmlPersistenceContext m_persistenceContext;
    private final ObjectFactory m_xsdFactory;

    public ArchitecturalViewPersistence(Version version, IAssignableAttributeRetrieverProvider provider) {
        assert (version != null) : "Parameter 'version' of method 'ArchitecturalViewPersistence' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'ArchitecturalViewPersistence' must not be null";
        this.m_version = version;
        this.m_provider = provider;
        this.m_persistenceContext = new XmlPersistenceContext(XSD_PACKAGE_NAME, CoreResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
        this.m_xsdFactory = new ObjectFactory();
    }

    private JaxbAdapter<JAXBElement<XsdArchitecturalView>> createJaxbAadpter() {
        ClassLoader classLoader = ObjectFactory.class.getClassLoader();
        return JaxbAccess.createJaxbAdapter(classLoader, this.m_persistenceContext);
    }

    public OperationResult save(ArchitecturalViewFile architecturalViewFile) {
        assert (architecturalViewFile != null) : "Parameter 'architecturalViewFile' of method 'save' must not be null";
        JAXBElement<XsdArchitecturalView> xsdArchitecturalView = this.createXsdArchitecturalView(architecturalViewFile);
        TFile file = architecturalViewFile.getFile();
        TFile modelsDir = file.getParentFile();
        if (!modelsDir.exists() || !modelsDir.isDirectory()) {
            modelsDir.mkdir();
        }
        OperationResult result = new OperationResult("Persist architectural view '" + FileUtility.getFileNameWithoutExtension((TFile)file) + "'");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TFileOutputStream outputStream = new TFileOutputStream((File)file);){
                this.createJaxbAadpter().save(xsdArchitecturalView, (OutputStream)outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex, "Failed to save architectural view file '" + file.getNormalizedAbsolutePath() + "'", new Object[0]);
        }
        return result;
    }

    private void addXsdArtifactTargetParentInformation(TargetParentOperation operation, XsdTargetParentOperation xsdOperation) {
        int targetPos;
        assert (operation != null) : "Parameter 'operation' of method 'addXsdArtifactTargetParentInformation' must not be null";
        assert (xsdOperation != null) : "Parameter 'xsdOperation' of method 'addXsdArtifactTargetParentInformation' must not be null";
        String targetParent = operation.getTargetParent();
        if (!targetParent.isEmpty()) {
            xsdOperation.setTargetParent(targetParent);
        }
        if ((targetPos = operation.getTargetPos()) != -1) {
            xsdOperation.setTargetPos(targetPos);
        }
    }

    private void addXsdArtifactPropertiesInformation(ArtifactPropertiesOperation operation, XsdArtifactPropertiesOperation xsdOperation) {
        assert (operation != null) : "Parameter 'operation' of method 'addXsdArtifactPropertiesInformation' must not be null";
        assert (xsdOperation != null) : "Parameter 'xsdOperation' of method 'addXsdArtifactPropertiesInformation' must not be null";
        this.addXsdArtifactTargetParentInformation(operation, xsdOperation);
        ArtifactProperties artifactProperties = operation.getArtifactProperties();
        switch (artifactProperties.getIncomingDependencyMode()) {
            case PUBLIC: {
                xsdOperation.setIncomingDependencyMode(XsdArtifactIncomingDependencyMode.PUBLIC);
                break;
            }
            case NONE: {
                break;
            }
            default: {
                assert (false) : "Unhandled incoming dependency mode: " + artifactProperties.getIncomingDependencyMode();
                break;
            }
        }
        switch (artifactProperties.getOutgoingDependencyMode()) {
            case RELAXED: {
                xsdOperation.setOutgoingDependencyMode(XsdArtifactOutgoingDependencyMode.RELAXED);
                break;
            }
            case RESTRICTED: {
                xsdOperation.setOutgoingDependencyMode(XsdArtifactOutgoingDependencyMode.RESTRICTED);
                break;
            }
            case STRICT: {
                xsdOperation.setOutgoingDependencyMode(XsdArtifactOutgoingDependencyMode.STRICT);
                break;
            }
            case UNRESTRICTED: {
                break;
            }
            default: {
                assert (false) : "Unhandled outgoing dependency mode: " + artifactProperties.getOutgoingDependencyMode();
                break;
            }
        }
        switch (artifactProperties.getAssignmentMode()) {
            case OPTIONAL: {
                xsdOperation.setAssignmentMode(XsdArtifactAssignmentMode.OPTIONAL);
                break;
            }
            case DEPRECATED: {
                xsdOperation.setAssignmentMode(XsdArtifactAssignmentMode.DEPRECATED);
                break;
            }
            case STANDARD: {
                break;
            }
            default: {
                assert (false) : "Unhandled assignment mode: " + artifactProperties.getAssignmentMode();
                break;
            }
        }
        block19: for (ArtifactVisibility nextVisibility : artifactProperties.getVisibility()) {
            switch (nextVisibility) {
                case HIDDEN: {
                    xsdOperation.getVisibility().add(XsdArtifactVisibility.HIDDEN);
                    break;
                }
                case LOCAL: {
                    xsdOperation.getVisibility().add(XsdArtifactVisibility.LOCAL);
                    break;
                }
                default: {
                    assert (false) : "Unhandled visibility: " + nextVisibility;
                    continue block19;
                }
            }
        }
    }

    private void addXsdPresentationModeInformation(ArchitecturalViewOperation operation, XsdOperation xsdOperation) {
        assert (operation != null) : "Parameter 'operation' of method 'addXsdPresentationModeInformation' must not be null";
        assert (xsdOperation != null) : "Parameter 'xsdOperation' of method 'addXsdPresentationModeInformation' must not be null";
        switch (operation.getPresentationMode()) {
            case HIERARCHICAL: {
                xsdOperation.setPresentationMode(XsdPresentationMode.HIERARCHICAL);
                break;
            }
            case MIXED: {
                break;
            }
            case FLAT: {
                xsdOperation.setPresentationMode(XsdPresentationMode.FLAT);
                break;
            }
            case NONE: {
                xsdOperation.setPresentationMode(XsdPresentationMode.NONE);
                break;
            }
            default: {
                assert (false) : "Unhandled presentation mode: " + (Object)((Object)operation.getPresentationMode());
                break;
            }
        }
    }

    private void addXsdFilter(ArtifactFilterOperation operation, XsdArtifactFilterOperation xsdOperation) {
        assert (operation != null) : "Parameter 'operation' of method 'addXsdFilter' must not be null";
        assert (xsdOperation != null) : "Parameter 'xsdOperation' of method 'addXsdFilter' must not be null";
        ManualFilter manualFilter = operation.getManualFilter();
        if (manualFilter != null) {
            manualFilter.getIncludes().forEach(i2 -> {
                boolean bl2 = xsdOperation.getInclude().add((String)i2);
            });
            manualFilter.getExcludes().forEach(i2 -> {
                boolean bl2 = xsdOperation.getExclude().add((String)i2);
            });
        }
    }

    private void addXsdOperation(ArchitecturalViewOperation operation, XsdArchitecturalView xsdArchitecturalView) {
        assert (xsdArchitecturalView != null) : "Parameter 'xsdArchitecturalView' of method 'addXsdOperation' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'addXsdOperation' must not be null";
        XsdOperation xsdOperation = null;
        if (operation instanceof CreateArtifactFromElementsOperation) {
            CreateArtifactFromElementsOperation createOperation = (CreateArtifactFromElementsOperation)operation;
            XsdCreateArtifactFromElementsOperation xsdCreateOperation = this.m_xsdFactory.createXsdCreateArtifactFromElementsOperation();
            this.addXsdArtifactPropertiesInformation(createOperation, xsdCreateOperation);
            xsdCreateOperation.setName(createOperation.getArtifactName());
            for (String nextFromElementPath : createOperation.getFromElements()) {
                xsdCreateOperation.getElement().add(nextFromElementPath);
            }
            xsdOperation = xsdCreateOperation;
        } else if (operation instanceof CreateArtifactOperation) {
            CreateArtifactOperation createOperation = (CreateArtifactOperation)operation;
            XsdCreateArtifactOperation xsdCreateOperation = this.m_xsdFactory.createXsdCreateArtifactOperation();
            this.addXsdArtifactPropertiesInformation(createOperation, xsdCreateOperation);
            xsdCreateOperation.setName(createOperation.getArtifactName());
            this.addXsdFilter(createOperation, xsdCreateOperation);
            xsdOperation = xsdCreateOperation;
        } else if (operation instanceof CreateArtifactsForElementsOperation) {
            CreateArtifactsForElementsOperation createOperation = (CreateArtifactsForElementsOperation)operation;
            XsdCreateArtifactsForElementsOperation xsdCreateOperation = this.m_xsdFactory.createXsdCreateArtifactsForElementsOperation();
            this.addXsdArtifactPropertiesInformation(createOperation, xsdCreateOperation);
            for (String nextForElementPath : createOperation.getForElements()) {
                xsdCreateOperation.getElement().add(nextForElementPath);
            }
            xsdOperation = xsdCreateOperation;
        } else if (operation instanceof EditArtifactOperation) {
            EditArtifactOperation editOperation = (EditArtifactOperation)operation;
            XsdEditArtifactOperation xsdEditOperation = this.m_xsdFactory.createXsdEditArtifactOperation();
            this.addXsdArtifactPropertiesInformation(editOperation, xsdEditOperation);
            xsdEditOperation.setElement(editOperation.getArtifact());
            xsdEditOperation.setName(editOperation.getArtifactName());
            this.addXsdFilter(editOperation, xsdEditOperation);
            xsdOperation = xsdEditOperation;
        } else if (operation instanceof EditArtifactsOperation) {
            EditArtifactsOperation editOperation = (EditArtifactsOperation)operation;
            XsdEditArtifactsOperation xsdEditOperation = this.m_xsdFactory.createXsdEditArtifactsOperation();
            this.addXsdArtifactPropertiesInformation(editOperation, xsdEditOperation);
            for (String nextArtifactRelativePath : editOperation.getArtifacts()) {
                xsdEditOperation.getElement().add(nextArtifactRelativePath);
            }
            xsdOperation = xsdEditOperation;
        } else if (operation instanceof MoveElementsOperation) {
            MoveElementsOperation moveOperation = (MoveElementsOperation)operation;
            XsdMoveElementsOperation xsdMoveOperation = this.m_xsdFactory.createXsdMoveElementsOperation();
            this.addXsdArtifactTargetParentInformation(moveOperation, xsdMoveOperation);
            for (String nextArtifactRelativePath : moveOperation.getElements()) {
                xsdMoveOperation.getElement().add(nextArtifactRelativePath);
            }
            xsdOperation = xsdMoveOperation;
        } else if (operation instanceof DeleteElementsOperation) {
            DeleteElementsOperation deleteOperation = (DeleteElementsOperation)operation;
            XsdDeleteElementsOperation xsdDeleteOperation = this.m_xsdFactory.createXsdDeleteElementsOperation();
            for (String nextArtifactRelativePath : deleteOperation.getElements()) {
                xsdDeleteOperation.getElement().add(nextArtifactRelativePath);
            }
            xsdOperation = xsdDeleteOperation;
        } else if (operation instanceof HideElementsOperation) {
            HideElementsOperation hideOperation = (HideElementsOperation)operation;
            XsdHideElementsOperation xsdHideOperation = this.m_xsdFactory.createXsdHideElementsOperation();
            for (String nextArtifactRelativePath : hideOperation.getElements()) {
                xsdHideOperation.getElement().add(nextArtifactRelativePath);
            }
            xsdOperation = xsdHideOperation;
        } else if (operation instanceof CreateAllowedArtifactConnectionOperation) {
            CreateAllowedArtifactConnectionOperation dependencyOperation = (CreateAllowedArtifactConnectionOperation)operation;
            XsdCreateAllowedArtifactConnectionOperation xsdDependencyOperation = this.m_xsdFactory.createXsdCreateAllowedArtifactConnectionOperation();
            xsdDependencyOperation.setFrom(dependencyOperation.getFrom());
            xsdDependencyOperation.setTo(dependencyOperation.getTo());
            xsdOperation = xsdDependencyOperation;
        } else if (operation instanceof DeleteDependenciesOperation) {
            DeleteDependenciesOperation dependenciesOperation = (DeleteDependenciesOperation)operation;
            XsdDeleteDependenciesOperation xsdDeleteDependenciesOperation = this.m_xsdFactory.createXsdDeleteDependenciesOperation();
            for (ArchitecturalViewDependencyDescriptor nextDependency : dependenciesOperation.getDependencies()) {
                XsdDependency xsdDependency = this.m_xsdFactory.createXsdDependency();
                xsdDependency.setFrom(nextDependency.getFrom());
                xsdDependency.setTo(nextDependency.getTo());
                if (!nextDependency.isFromAggregated()) {
                    xsdDependency.setFromAggregated(Boolean.FALSE);
                }
                if (!nextDependency.isToAggregated()) {
                    xsdDependency.setToAggregated(Boolean.FALSE);
                }
                xsdDeleteDependenciesOperation.getDependency().add(xsdDependency);
            }
            xsdOperation = xsdDeleteDependenciesOperation;
        } else if (operation instanceof CreateElementOperation) {
            CreateElementOperation createOperation = (CreateElementOperation)operation;
            XsdCreateElementOperation xsdCreateOperation = this.m_xsdFactory.createXsdCreateElementOperation();
            this.addXsdArtifactTargetParentInformation(createOperation, xsdCreateOperation);
            xsdCreateOperation.setName(createOperation.getElementName());
            switch (createOperation.getType()) {
                case DIRECTORY: {
                    xsdCreateOperation.setType(XsdElementType.DIRECTORY);
                    break;
                }
                case NAMESPACE: {
                    xsdCreateOperation.setType(XsdElementType.NAMESPACE);
                    break;
                }
                default: {
                    assert (false) : "Unhandled type: " + (Object)((Object)createOperation.getType());
                    break;
                }
            }
            xsdOperation = xsdCreateOperation;
        } else if (operation instanceof RenameElementOperation) {
            RenameElementOperation renameOperation = (RenameElementOperation)operation;
            XsdRenameElementOperation xsdRenameOperation = this.m_xsdFactory.createXsdRenameElementOperation();
            xsdRenameOperation.setElement(renameOperation.getElementName());
            xsdRenameOperation.setName(renameOperation.getNewName());
            xsdOperation = xsdRenameOperation;
        } else if (operation instanceof CreateFindingOperation) {
            CreateFindingOperation createFindingOperation = (CreateFindingOperation)operation;
            XsdCreateFindingOperation xsdCreateFindingOperation = this.m_xsdFactory.createXsdCreateFindingOperation();
            xsdCreateFindingOperation.setName(createFindingOperation.getFindingName());
            xsdCreateFindingOperation.setDescription(createFindingOperation.getFindingDescription());
            if (createFindingOperation.ignoreViolations()) {
                xsdCreateFindingOperation.setIgnoreViolations(createFindingOperation.ignoreViolations());
            }
            createFindingOperation.getParserDependencyDescriptors().forEach(d2 -> {
                boolean bl2 = xsdCreateFindingOperation.getParserDependency().add((String)d2);
            });
            xsdOperation = xsdCreateFindingOperation;
        }
        assert (xsdOperation != null) : "'xsdOperation' of method 'addXsdOperation' must not be null - unhandled operation: " + operation.getClass().getName();
        this.addXsdPresentationModeInformation(operation, xsdOperation);
        xsdArchitecturalView.getOperation().add(xsdOperation);
    }

    private JAXBElement<XsdArchitecturalView> createXsdArchitecturalView(ArchitecturalViewFile architecturalView) {
        assert (architecturalView != null) : "Parameter 'architecturalView' of method 'createXsdArchitecturalView' must not be null";
        XsdArchitecturalView xsdArchitecturalView = this.m_xsdFactory.createXsdArchitecturalView();
        JAXBElement<XsdArchitecturalView> element = this.m_xsdFactory.createArchitecturalView(xsdArchitecturalView);
        xsdArchitecturalView.setVersion(this.m_version.toString());
        String description = architecturalView.getDescription();
        if (description != null && !description.isEmpty()) {
            xsdArchitecturalView.setDescription(description);
        }
        xsdArchitecturalView.setBasedOn(architecturalView.getBasedOn());
        ExplorationViewStructureMode structureMode = architecturalView.getStructureMode();
        switch (structureMode) {
            case PHYSICAL_WITH_ROOT_DIRECTORIES: {
                xsdArchitecturalView.setStructureMode(XsdStructureMode.PHYSICAL_WITH_ROOT_DIRECTORIES);
                break;
            }
            case PHYSICAL_WITHOUT_ROOT_DIRECTORIES: {
                xsdArchitecturalView.setStructureMode(XsdStructureMode.PHYSICAL_WITHOUT_ROOT_DIRECTORIES);
                break;
            }
            case LOGICAL_MODULE_SCOPE: {
                xsdArchitecturalView.setStructureMode(XsdStructureMode.LOGICAL_MODULE_SCOPE);
                break;
            }
            case LOGICAL_SYSTEM_SCOPE: {
                xsdArchitecturalView.setStructureMode(XsdStructureMode.LOGICAL_SYSTEM_SCOPE);
                break;
            }
            default: {
                assert (false) : "Unhandled structure mode: " + (Object)((Object)structureMode);
                break;
            }
        }
        architecturalView.getNonInheritedOperations().forEach(o2 -> this.addXsdOperation((ArchitecturalViewOperation)o2, xsdArchitecturalView));
        return element;
    }

    public void save(ArchitecturalViewFile architecturalViewFile, OutputStream outputStream, OperationResult result) {
        assert (architecturalViewFile != null) : "Parameter 'architecturalViewFile' of method 'save' must not be null";
        assert (outputStream != null) : "Parameter 'outputStream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        try {
            JAXBElement<XsdArchitecturalView> xsdModel = this.createXsdArchitecturalView(architecturalViewFile);
            this.createJaxbAadpter().save(xsdModel, outputStream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    private OperationResultWithOutcome<XsdArchitecturalView> internLoadFromStream(InputStream inputStream, ArchitecturalViewFile architecturalViewFile) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadFromStream' must not be null";
        assert (architecturalViewFile != null) : "Parameter 'architecturalViewFile' of method 'internLoadFromStream' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Loading architectural view '" + architecturalViewFile.getIdentifyingPath() + "' from stream");
        JaxbAdapter<JAXBElement<XsdArchitecturalView>> jaxbAdapter = this.createJaxbAadpter();
        String sourceInfo = "Architectural View '" + architecturalViewFile.getIdentifyingPath() + "'";
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl((OperationResult)result, sourceInfo);
        JAXBElement xsdArchitecturalView = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)eventHandler);
        if (result.isSuccess()) {
            result.setOutcome((Object)((XsdArchitecturalView)xsdArchitecturalView.getValue()));
        }
        return result;
    }

    public OperationResult load(TFile file, ArchitecturalViewFile architecturalViewFile) {
        assert (file != null) : "Parameter 'file' of method 'load' must not be null";
        assert (architecturalViewFile != null) : "Parameter 'architecturalViewFile' of method 'load' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Load architectural view from '" + file.getName() + "'");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (TFileInputStream inputStream = new TFileInputStream((File)file);){
                OperationResultWithOutcome<XsdArchitecturalView> loadResult = this.internLoadFromStream((InputStream)inputStream, architecturalViewFile);
                result.addMessagesFrom(loadResult);
                result.setOutcome((Object)((XsdArchitecturalView)loadResult.getOutcome()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, (Throwable)ex, "Failed to load architectural view from file '" + file.getNormalizedAbsolutePath() + "'", new Object[0]);
        }
        if (result.isSuccess()) {
            this.createPojo(architecturalViewFile, (XsdArchitecturalView)result.getOutcome(), (OperationResult)result);
        }
        return result;
    }

    public OperationResult load(InputStream inputStream, ArchitecturalViewFile architecturalViewFile) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadFromStream' must not be null";
        assert (architecturalViewFile != null) : "Parameter 'architecturalViewFile' of method 'load' must not be null";
        OperationResultWithOutcome<XsdArchitecturalView> result = this.internLoadFromStream(inputStream, architecturalViewFile);
        if (result.isSuccess()) {
            this.createPojo(architecturalViewFile, (XsdArchitecturalView)result.getOutcome(), (OperationResult)result);
        }
        return result;
    }

    private ArtifactIncomingDependencyMode getIncomingDependencyMode(XsdArtifactIncomingDependencyMode xsdMode) {
        assert (xsdMode != null) : "Parameter 'xsdMode' of method 'getIncomingDependencyMode' must not be null";
        switch (xsdMode) {
            case PUBLIC: {
                return ArtifactIncomingDependencyMode.PUBLIC;
            }
            case NONE: {
                return ArtifactIncomingDependencyMode.NONE;
            }
        }
        assert (false) : "Unhandled mode: " + (Object)((Object)xsdMode);
        return null;
    }

    private ArtifactOutgoingDependencyMode getOutgoingDependencyMode(XsdArtifactOutgoingDependencyMode xsdMode) {
        assert (xsdMode != null) : "Parameter 'xsdMode' of method 'getOutgoingDependencyMode' must not be null";
        switch (xsdMode) {
            case RELAXED: {
                return ArtifactOutgoingDependencyMode.RELAXED;
            }
            case RESTRICTED: {
                return ArtifactOutgoingDependencyMode.RESTRICTED;
            }
            case STRICT: {
                return ArtifactOutgoingDependencyMode.STRICT;
            }
            case UNRESTRICTED: {
                return ArtifactOutgoingDependencyMode.UNRESTRICTED;
            }
        }
        assert (false) : "Unhandled mode: " + (Object)((Object)xsdMode);
        return null;
    }

    private ArtifactAssignmentMode getAssignmentMode(XsdArtifactAssignmentMode xsdMode) {
        assert (xsdMode != null) : "Parameter 'xsdMode' of method 'getAssignmentMode' must not be null";
        switch (xsdMode) {
            case OPTIONAL: {
                return ArtifactAssignmentMode.OPTIONAL;
            }
            case DEPRECATED: {
                return ArtifactAssignmentMode.DEPRECATED;
            }
            case STANDARD: {
                return ArtifactAssignmentMode.STANDARD;
            }
        }
        assert (false) : "Unhandled mode: " + (Object)((Object)xsdMode);
        return null;
    }

    private RecursiveElementRefactoringDescriptor.ElementType getElementType(XsdElementType xsdElementType) {
        assert (xsdElementType != null) : "Parameter 'xsdElementType' of method 'getElementType' must not be null";
        switch (xsdElementType) {
            case DIRECTORY: {
                return RecursiveElementRefactoringDescriptor.ElementType.DIRECTORY;
            }
            case NAMESPACE: {
                return RecursiveElementRefactoringDescriptor.ElementType.NAMESPACE;
            }
        }
        assert (false) : "Unhandled mode: " + (Object)((Object)xsdElementType);
        return null;
    }

    private EnumSet<ArtifactVisibility> getVisibility(List<XsdArtifactVisibility> xsdVisibilities, OperationResult result) {
        assert (xsdVisibilities != null) : "Parameter 'xsdVisibilities' of method 'getVisibility' must not be null";
        assert (result != null) : "Parameter 'result' of method 'getVisibility' must not be null";
        EnumSet<ArtifactVisibility> visibilities = EnumSet.noneOf(ArtifactVisibility.class);
        if (!xsdVisibilities.isEmpty()) {
            block4: for (XsdArtifactVisibility nextXsdVisibility : xsdVisibilities) {
                switch (nextXsdVisibility) {
                    case HIDDEN: {
                        if (visibilities.add(ArtifactVisibility.HIDDEN)) continue block4;
                        result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.DUPLICATE_VISIBILITY, "Ignoring duplicate visibility: " + (Object)((Object)XsdArtifactVisibility.HIDDEN), new Object[0]);
                        break;
                    }
                    case LOCAL: {
                        if (visibilities.add(ArtifactVisibility.LOCAL)) continue block4;
                        result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.DUPLICATE_VISIBILITY, "Ignoring duplicate visibility: " + (Object)((Object)XsdArtifactVisibility.LOCAL), new Object[0]);
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled visibility: " + (Object)((Object)nextXsdVisibility);
                        continue block4;
                    }
                }
            }
        }
        return visibilities;
    }

    private PresentationMode getPresentationMode(XsdOperation xsdOperation) {
        assert (xsdOperation != null) : "Parameter 'xsdOperation' of method 'getPresentationMode' must not be null";
        switch (xsdOperation.getPresentationMode()) {
            case HIERARCHICAL: {
                return PresentationMode.HIERARCHICAL;
            }
            case MIXED: {
                return PresentationMode.MIXED;
            }
            case FLAT: {
                return PresentationMode.FLAT;
            }
            case NONE: {
                return PresentationMode.NONE;
            }
        }
        assert (false) : "Unhandled presentation mode: " + (Object)((Object)xsdOperation.getPresentationMode());
        return null;
    }

    private List<String> getPaths(List<String> xsdPaths, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'getPaths' must not be null";
        if (xsdPaths == null || xsdPaths.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        for (String nextXsdPath : xsdPaths) {
            if (paths.add(nextXsdPath)) continue;
            result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.DUPLICATE_PATH, "Ignoring duplicate path: " + nextXsdPath, new Object[0]);
        }
        return new ArrayList<String>(paths);
    }

    private void createFilter(XsdArtifactFilterOperation xsdOperation, ArtifactFilterOperation operation, String contextInfo, OperationResult result) {
        ParsedPatternInfo nextInfo;
        assert (xsdOperation != null) : "Parameter 'xsdOperation' of method 'createFilter' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'createFilter' must not be null";
        assert (contextInfo != null && contextInfo.length() > 0) : "Parameter 'contextInfo' of method 'createFilter' must not be empty";
        assert (result != null) : "Parameter 'result' of method 'createFilter' must not be null";
        List<String> includes = xsdOperation.getInclude();
        List<String> excludes = xsdOperation.getExclude();
        if ((includes == null || includes.isEmpty()) && (excludes == null || excludes.isEmpty())) {
            return;
        }
        ArrayList<String> addIncludes = new ArrayList<String>();
        ArrayList<String> addExcludes = new ArrayList<String>();
        HashSet<String> added = new HashSet<String>();
        for (String next : includes) {
            if (added.add(next)) {
                nextInfo = ParsedPatternInfo.parsePattern(next, false, false, this.m_provider);
                if (nextInfo.isValid()) {
                    addIncludes.add(next);
                    continue;
                }
                result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.INVALID_FILTER_PATTERN, "Ignored invalid include pattern: " + nextInfo.getErrorMessage() + " [" + contextInfo + "]", new Object[0]);
                continue;
            }
            result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.INVALID_FILTER_PATTERN, "Ignored duplicate pattern: " + next + " [" + contextInfo + "]", new Object[0]);
        }
        for (String next : excludes) {
            if (added.add(next)) {
                nextInfo = ParsedPatternInfo.parsePattern(next, false, false, this.m_provider);
                if (nextInfo.isValid()) {
                    addExcludes.add(next);
                    continue;
                }
                result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.INVALID_FILTER_PATTERN, "Ignored invalid exclude pattern: " + nextInfo.getErrorMessage() + " [" + contextInfo + "]", new Object[0]);
                continue;
            }
            result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.INVALID_FILTER_PATTERN, "Ignored duplicate pattern: " + next + " [" + contextInfo + "]", new Object[0]);
        }
        if (!addIncludes.isEmpty()) {
            operation.setManualFilter(new ManualFilter(addIncludes, addExcludes));
        } else if (!addExcludes.isEmpty()) {
            result.addWarning((OperationResult.IMessageCause)ArchitecturalViewPersistenceMessageCause.INVALID_FILTER_PATTERN, "Ignored exclude patterns since no include patterns are defined [" + contextInfo + "]", new Object[0]);
        }
    }

    private ArtifactProperties createArtifactProperties(XsdArtifactPropertiesOperation xsdOperation, OperationResult result) {
        assert (xsdOperation != null) : "Parameter 'xsdOperation' of method 'createArtifactProperties' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createArtifactProperties' must not be null";
        return new ArtifactProperties(this.getIncomingDependencyMode(xsdOperation.getIncomingDependencyMode()), this.getOutgoingDependencyMode(xsdOperation.getOutgoingDependencyMode()), this.getAssignmentMode(xsdOperation.getAssignmentMode()), this.getVisibility(xsdOperation.getVisibility(), result));
    }

    private void createOperation(XsdOperation xsdOperation, ArchitecturalViewOperationList operations, OperationResult result) {
        assert (xsdOperation != null) : "Parameter 'xsdOperation' of method 'createOperation' must not be null";
        assert (operations != null) : "Parameter 'operations' of method 'createOperation' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createOperation' must not be null";
        ArchitecturalViewOperation operation = null;
        if (xsdOperation instanceof XsdCreateArtifactFromElementsOperation) {
            XsdCreateArtifactFromElementsOperation xsdCreateOperation = (XsdCreateArtifactFromElementsOperation)xsdOperation;
            operation = new CreateArtifactFromElementsOperation(operations, this.getPresentationMode(xsdOperation), xsdCreateOperation.getTargetParent(), xsdCreateOperation.getTargetPos(), this.createArtifactProperties(xsdCreateOperation, result), xsdCreateOperation.getName(), this.getPaths(xsdCreateOperation.getElement(), result));
        } else if (xsdOperation instanceof XsdCreateArtifactOperation) {
            XsdCreateArtifactOperation xsdCreateOperation = (XsdCreateArtifactOperation)xsdOperation;
            operation = new CreateArtifactOperation(operations, this.getPresentationMode(xsdOperation), xsdCreateOperation.getTargetParent(), xsdCreateOperation.getTargetPos(), this.createArtifactProperties(xsdCreateOperation, result), xsdCreateOperation.getName());
            this.createFilter(xsdCreateOperation, (ArtifactFilterOperation)operation, "xsdCreateArtifactOperation '" + xsdCreateOperation.getName() + "'", result);
        } else if (xsdOperation instanceof XsdCreateArtifactsForElementsOperation) {
            XsdCreateArtifactsForElementsOperation xsdCreateOperation = (XsdCreateArtifactsForElementsOperation)xsdOperation;
            operation = new CreateArtifactsForElementsOperation(operations, this.getPresentationMode(xsdOperation), xsdCreateOperation.getTargetParent(), xsdCreateOperation.getTargetPos(), this.createArtifactProperties(xsdCreateOperation, result), this.getPaths(xsdCreateOperation.getElement(), result));
        } else if (xsdOperation instanceof XsdEditArtifactOperation) {
            XsdEditArtifactOperation xsdEditOperation = (XsdEditArtifactOperation)xsdOperation;
            operation = new EditArtifactOperation(operations, this.getPresentationMode(xsdOperation), xsdEditOperation.getTargetParent(), xsdEditOperation.getTargetPos(), this.createArtifactProperties(xsdEditOperation, result), xsdEditOperation.getElement(), xsdEditOperation.getName());
            this.createFilter(xsdEditOperation, (EditArtifactOperation)operation, "xsdEditArtifactOperation " + xsdEditOperation.getName() + "'", result);
        } else if (xsdOperation instanceof XsdEditArtifactsOperation) {
            XsdEditArtifactsOperation xsdEditOperation = (XsdEditArtifactsOperation)xsdOperation;
            operation = new EditArtifactsOperation(operations, this.getPresentationMode(xsdOperation), xsdEditOperation.getTargetParent(), xsdEditOperation.getTargetPos(), this.createArtifactProperties(xsdEditOperation, result), xsdEditOperation.getElement());
        } else if (xsdOperation instanceof XsdMoveElementsOperation) {
            XsdMoveElementsOperation xsdMoveOperation = (XsdMoveElementsOperation)xsdOperation;
            operation = new MoveElementsOperation(operations, this.getPresentationMode(xsdMoveOperation), xsdMoveOperation.getTargetParent(), xsdMoveOperation.getTargetPos(), xsdMoveOperation.getElement());
        } else if (xsdOperation instanceof XsdDeleteElementsOperation) {
            XsdDeleteElementsOperation xsdDeleteOperation = (XsdDeleteElementsOperation)xsdOperation;
            operation = new DeleteElementsOperation(operations, this.getPresentationMode(xsdOperation), this.getPaths(xsdDeleteOperation.getElement(), result));
        } else if (xsdOperation instanceof XsdHideElementsOperation) {
            XsdHideElementsOperation xsdHideOperation = (XsdHideElementsOperation)xsdOperation;
            operation = new HideElementsOperation(operations, this.getPresentationMode(xsdOperation), this.getPaths(xsdHideOperation.getElement(), result));
        } else if (xsdOperation instanceof XsdCreateAllowedArtifactConnectionOperation) {
            XsdCreateAllowedArtifactConnectionOperation xsdDependencyOperation = (XsdCreateAllowedArtifactConnectionOperation)xsdOperation;
            operation = new CreateAllowedArtifactConnectionOperation(operations, this.getPresentationMode(xsdOperation), xsdDependencyOperation.getFrom(), xsdDependencyOperation.getTo());
        } else if (xsdOperation instanceof XsdDeleteDependenciesOperation) {
            XsdDeleteDependenciesOperation xsdDependenciesOperation = (XsdDeleteDependenciesOperation)xsdOperation;
            ArrayList<ArchitecturalViewDependencyDescriptor> dependencies = new ArrayList<ArchitecturalViewDependencyDescriptor>();
            xsdDependenciesOperation.getDependency().forEach(d2 -> {
                boolean bl2 = dependencies.add(new ArchitecturalViewDependencyDescriptor(d2.getFrom(), d2.isFromAggregated(), d2.getTo(), d2.isToAggregated(), -1));
            });
            operation = new DeleteDependenciesOperation(operations, this.getPresentationMode(xsdOperation), dependencies);
        } else if (xsdOperation instanceof XsdCreateElementOperation) {
            XsdCreateElementOperation xsdCreateOperation = (XsdCreateElementOperation)xsdOperation;
            operation = new CreateElementOperation(operations, this.getPresentationMode(xsdOperation), xsdCreateOperation.getTargetParent(), xsdCreateOperation.getTargetPos(), this.getElementType(xsdCreateOperation.getType()), xsdCreateOperation.getName());
        } else if (xsdOperation instanceof XsdRenameElementOperation) {
            XsdRenameElementOperation xsdRenameOperation = (XsdRenameElementOperation)xsdOperation;
            operation = new RenameElementOperation(operations, this.getPresentationMode(xsdOperation), xsdRenameOperation.getElement(), xsdRenameOperation.getName());
        } else if (xsdOperation instanceof XsdCreateFindingOperation) {
            XsdCreateFindingOperation xsdCreateFindingOperation = (XsdCreateFindingOperation)xsdOperation;
            operation = new CreateFindingOperation(operations, this.getPresentationMode(xsdOperation), xsdCreateFindingOperation.getName(), xsdCreateFindingOperation.getDescription(), xsdCreateFindingOperation.isIgnoreViolations(), xsdCreateFindingOperation.getParserDependency());
        }
        assert (operation != null) : "'operation' of method 'createOperation' must not be null - unhandled operation: " + xsdOperation.getClass().getName();
        operations.addChild(operation);
    }

    private void createPojo(ArchitecturalViewFile architecturalViewFile, XsdArchitecturalView xsdArchitecturalView, OperationResult result) {
        String xsdBasedOn;
        assert (architecturalViewFile != null) : "Parameter 'architecturalViewFile' of method 'createPojo' must not be null";
        assert (xsdArchitecturalView != null) : "Parameter 'xsdArchitecturalView' of method 'createPojo' must not be null";
        String versionFromPersistenceAsString = xsdArchitecturalView.getVersion();
        Version versionFromPersistence = Version.create((String)versionFromPersistenceAsString);
        if (versionFromPersistence == null) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Version read from persistence: '" + versionFromPersistenceAsString + "'", new Object[0]);
            return;
        }
        String xsdDescription = xsdArchitecturalView.getDescription();
        if (xsdDescription != null && !xsdDescription.isEmpty()) {
            architecturalViewFile.setDescription(xsdDescription);
        }
        architecturalViewFile.setBasedOn((xsdBasedOn = xsdArchitecturalView.getBasedOn()) != null && !xsdBasedOn.isEmpty() ? xsdBasedOn : null);
        try {
            architecturalViewFile.setStructureMode(ExplorationViewStructureMode.fromStandardName(xsdArchitecturalView.getStructureMode().value()));
        }
        catch (IllegalArgumentException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Wrong structure mode format: '" + xsdArchitecturalView.getStructureMode().name() + "'", new Object[0]);
        }
        ArchitecturalViewOperationList operations = architecturalViewFile.getUniqueExistingChild(ArchitecturalViewOperationList.class);
        for (XsdOperation nextXsdOperation : xsdArchitecturalView.getOperation()) {
            this.createOperation(nextXsdOperation, operations, result);
        }
    }
}

