/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.workspaceimport;

import de.schlichtherle.truezip.file.TFile;

public abstract class ImportCandidate {
    private final TFile m_file;
    private boolean m_included = false;
    private boolean m_alreadyInWorkspace = false;
    private StringBuilder m_errors;
    private StringBuilder m_warnings;

    public ImportCandidate(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'ImportCandidate' must not be null";
        this.m_file = file;
    }

    public abstract String getName();

    public abstract String getImageResourceName();

    public final TFile getFile() {
        return this.m_file;
    }

    public final boolean isIncluded() {
        return this.m_included;
    }

    public final void setIncluded(boolean isIncluded) {
        this.m_included = isIncluded;
    }

    public final void setAlreadyInWorkspace(boolean alreadyInWorkspace) {
        if (alreadyInWorkspace) {
            this.m_included = false;
        }
        this.m_alreadyInWorkspace = alreadyInWorkspace;
    }

    public final boolean isAlreadyInWorkspace() {
        return this.m_alreadyInWorkspace;
    }

    public final void addError(String error) {
        assert (error != null) : "Parameter 'error' of method 'setError' must not be null";
        if (this.m_errors == null) {
            this.m_errors = new StringBuilder();
        } else {
            this.m_errors.append("\n");
        }
        this.m_errors.append(error);
    }

    public final String getError() {
        if (this.m_errors == null) {
            return null;
        }
        return this.m_errors.toString();
    }

    public final void addWarning(String warning) {
        assert (warning != null) : "Parameter 'error' of method 'setError' must not be null";
        if (this.m_warnings == null) {
            this.m_warnings = new StringBuilder();
        } else {
            this.m_warnings.append("\n");
        }
        this.m_warnings.append(warning);
    }

    public final String getWarning() {
        if (this.m_warnings == null) {
            return null;
        }
        return this.m_warnings.toString();
    }
}

