/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.workspace;

import com.hello2morrow.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IPhysicalElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotComponentContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotRootDirectoryPath;
import java.util.List;

public abstract class ComponentContainer
extends NamedElementContainer
implements IDomainRoot,
IPhysicalElement,
ISnapshotComponentContainer {
    private int m_numberOfComponents = -1;

    protected ComponentContainer(NamedElement parent) {
        super(parent);
    }

    @Override
    public final IDomainRoot.Domain getDomain() {
        return IDomainRoot.Domain.PHYSICAL;
    }

    @Override
    public final String getInformation() {
        return this.m_numberOfComponents != -1 ? String.valueOf(NumberUtility.format((Number)this.m_numberOfComponents)) + (this.isExternal() ? " external" : " internal") + " component(s)" : "";
    }

    public final void initializeNumberOfComponents() {
        this.m_numberOfComponents = 0;
    }

    public final void clearNumberOfComponents() {
        this.m_numberOfComponents = -1;
    }

    public final int getNumberOfComponents() {
        return this.m_numberOfComponents;
    }

    public final void incrementNumberOfComponents() {
        assert (this.m_numberOfComponents != -1) : "Has not been initialized";
        ++this.m_numberOfComponents;
    }

    @Override
    public List<? extends ISnapshotRootDirectoryPath> getRootDirectoryPaths() {
        return this.getChildren(ISnapshotRootDirectoryPath.class);
    }
}

