/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.treemap;

import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMap;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapType;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TreeMapRepresentation
extends NamedElement {
    private final List<Module> m_modules;
    private final TreeMap<NamedElement, TreeMapNodeData> m_treeMap;
    private final TreeMapType m_type;
    private final Info m_info;
    private boolean m_isValid = true;

    public TreeMapRepresentation(NamedElement parent, List<Module> modules, TreeMap<NamedElement, TreeMapNodeData> treeMap, TreeMapType type, Info info) {
        super(parent);
        assert (treeMap != null) : "Parameter 'treeMap' of method 'TreeMapRepresentation' must not be null";
        assert (type != null) : "Parameter 'type' of method 'TreeMapRepresentation' must not be null";
        assert (info != null) : "Parameter 'info' of method 'TreeMapRepresentation' must not be null";
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'TreeMapRepresentation' must not be empty";
        this.m_modules = new ArrayList<Module>(modules);
        this.m_treeMap = treeMap;
        this.m_type = type;
        this.m_info = info;
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    public List<Module> getModules() {
        return Collections.unmodifiableList(this.m_modules);
    }

    @Override
    public String getShortName() {
        return this.m_treeMap.getName();
    }

    public TreeMapNode<NamedElement, TreeMapNodeData> getTreeMapNode() {
        return this.m_treeMap;
    }

    public TreeMapType getType() {
        return this.m_type;
    }

    public void setInvalid() {
        this.m_isValid = false;
    }

    public String getLeafElement() {
        return this.m_info.m_leafElementName;
    }

    public String getSizeAttribute() {
        return this.m_info.m_sizeAttribute;
    }

    public String getColorAttribute() {
        return this.m_info.m_colorAttribute;
    }

    public String getHeightAttribute() {
        return this.m_info.m_heightAttribute;
    }

    @Override
    public String getImageResourceName() {
        return "TreeMapFile";
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " [" + (Object)((Object)this.m_type) + "]";
    }

    public List<TreeMapNode<NamedElement, TreeMapNodeData>> getLeafs() {
        final ArrayList<TreeMapNode<NamedElement, TreeMapNodeData>> leafs = new ArrayList<TreeMapNode<NamedElement, TreeMapNodeData>>(5000);
        this.getTreeMapNode().accept(new TreeMapNode.IVisitor<NamedElement, TreeMapNodeData>(){

            @Override
            public boolean visitNode(TreeMapNode<NamedElement, TreeMapNodeData> node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'visitNode' must not be null");
                }
                if (node.isLeaf()) {
                    leafs.add(node);
                    return false;
                }
                return true;
            }
        });
        return leafs;
    }

    public Map<NamedElement, TreeMapNode<NamedElement, TreeMapNodeData>> getNamedElementToLeaf() {
        THashMap leafs = new THashMap(5000);
        this.getTreeMapNode().accept(new TreeMapNode.IVisitor<NamedElement, TreeMapNodeData>((Map)leafs){
            private final /* synthetic */ Map val$leafs;
            {
                this.val$leafs = map;
            }

            @Override
            public boolean visitNode(TreeMapNode<NamedElement, TreeMapNodeData> node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'visitNode' must not be null");
                }
                if (node.isLeaf()) {
                    this.val$leafs.put(node.getAssociatedElement(), node);
                    return false;
                }
                return true;
            }
        });
        return leafs;
    }

    public int getNumberOfLeafs() {
        LeafCounter leafCounter = new LeafCounter();
        this.getTreeMapNode().accept(leafCounter);
        return leafCounter.getNumber();
    }

    public static final class Info {
        private final String m_leafElementName;
        private final String m_sizeAttribute;
        private final String m_colorAttribute;
        private final String m_heightAttribute;

        public Info(String leafElementName, String sizeAttribute, String colorAttribute, String heightAttribute) {
            assert (leafElementName != null && leafElementName.length() > 0) : "Parameter 'leafElementName' of method 'Info' must not be empty";
            assert (sizeAttribute != null && sizeAttribute.length() > 0) : "Parameter 'sizeAttribute' of method 'Info' must not be empty";
            assert (colorAttribute != null && colorAttribute.length() > 0) : "Parameter 'colorAttribute' of method 'Info' must not be empty";
            this.m_leafElementName = leafElementName;
            this.m_sizeAttribute = sizeAttribute;
            this.m_colorAttribute = colorAttribute;
            this.m_heightAttribute = heightAttribute;
        }
    }

    static final class LeafCounter
    implements TreeMapNode.IVisitor<NamedElement, TreeMapNodeData> {
        private int m_number = 0;

        LeafCounter() {
        }

        @Override
        public boolean visitNode(TreeMapNode<NamedElement, TreeMapNodeData> node) {
            assert (node != null) : "Parameter 'node' of method 'visitNode' must not be null";
            if (node.isLeaf()) {
                ++this.m_number;
                return false;
            }
            return true;
        }

        int getNumber() {
            return this.m_number;
        }
    }
}

