/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.treemap;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.treemap.NoHeightValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapProperties;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapValueSource;
import de.schlichtherle.truezip.file.TFile;

public final class TreeMapFile
extends ModifiableFile
implements ISoftwareSystemDefinitionElement {
    private TreeMapProperties m_treeMapProperties;

    public TreeMapFile(NamedElement parent, TFile file, TreeMapProperties properties, IModifiablePathListener listener) {
        super(parent, file, listener);
        assert (properties != null) : "Parameter 'properties' of method 'TreeMapFile' must not be null";
        this.m_treeMapProperties = properties;
        this.m_treeMapProperties.setName(FileUtility.removeExtension((String)this.getShortName()));
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.TREEMAP;
    }

    @Override
    public String getPresentationKind() {
        return "Treemap";
    }

    @Override
    @Property
    public String getAbsolutePath() {
        return this.getFile().getNormalizedAbsolutePath();
    }

    public void setTreeMapProperties(TreeMapProperties properties) {
        assert (properties != null) : "Parameter 'properties' of method 'setTreeMapProperties' must not be null";
        this.m_treeMapProperties = properties;
    }

    public TreeMapProperties getTreeMapProperties() {
        return this.m_treeMapProperties;
    }

    @Override
    public String getDescription() {
        return this.m_treeMapProperties.getDescription();
    }

    @Property
    public String getLeafElement() {
        return this.m_treeMapProperties.getLeafElement().getPresentationName();
    }

    @Property
    public String getSizeAttribute() {
        return this.m_treeMapProperties.getSizeSource().getPresentationName();
    }

    @Property
    public String getColorAttribute() {
        return this.m_treeMapProperties.getColorSource().getPresentationName();
    }

    @Property
    public String getHeightAttribute() {
        TreeMapValueSource heightSource = this.m_treeMapProperties.getHeightSource();
        if (heightSource instanceof NoHeightValueSource) {
            return null;
        }
        return heightSource.getPresentationName();
    }
}

