/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.settings;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.SearchPath;
import com.hello2morrow.sonargraph.core.model.system.settings.ISearchPathDelta;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SearchPathDelta
implements ISearchPathDelta {
    private Map<TFile, List<TFile>> m_originalMap;
    private Map<TFile, List<TFile>> m_newMap;
    private SearchPath m_originalSearchPath;

    public SearchPathDelta(Map<TFile, List<TFile>> original) {
        assert (original != null) : "Parameter 'original' of method 'SearchPathDelta' must not be null";
        this.m_originalMap = original;
        this.m_originalSearchPath = new SearchPath();
        for (TFile dir : this.m_originalMap.keySet()) {
            this.m_originalSearchPath.add(dir.getNormalizedAbsoluteFile());
        }
        this.init();
    }

    private void init() {
        this.m_newMap = new LinkedHashMap<TFile, List<TFile>>(this.m_originalMap.size());
        for (Map.Entry<TFile, List<TFile>> entry : this.m_originalMap.entrySet()) {
            List<TFile> existingEntries = entry.getValue();
            ArrayList<TFile> newEntries = new ArrayList<TFile>(existingEntries.size());
            for (TFile file : existingEntries) {
                newEntries.add(file);
            }
            this.m_newMap.put(entry.getKey().getNormalizedAbsoluteFile(), newEntries);
        }
    }

    @Override
    public void reset() {
        this.m_newMap.clear();
        this.init();
    }

    @Override
    public void add(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'add' must not be null";
        TFile dirToAdd = dir.getNormalizedAbsoluteFile();
        assert (!this.m_newMap.containsKey(dirToAdd)) : "newPath must not be present in search path";
        this.m_newMap.put(dirToAdd, null);
    }

    @Override
    public TFile getAddedDir() {
        List originalDirs = this.m_originalSearchPath.getDirectories();
        LinkedHashSet newDirs = new LinkedHashSet(this.getModified().getDirectories());
        newDirs.removeAll(originalDirs);
        for (TFile dir : newDirs) {
            if (this.m_newMap.get(dir) != null) continue;
            return dir;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void move(TFile dirToMove, boolean isDown) {
        assert (dirToMove != null) : "Parameter 'dirToMove' of method 'move' must not be null";
        ArrayList<TFile> dirs = new ArrayList<TFile>(this.m_newMap.keySet());
        if (dirs.size() <= 1) {
            return;
        }
        int index = dirs.indexOf(dirToMove);
        assert (index >= 0) : "Directory '" + dirToMove.getNormalizedAbsolutePath() + "' not present in search path";
        if (isDown) {
            if (index >= dirs.size() - 1) return;
            dirs.remove(index);
            dirs.add(index + 1, dirToMove);
        } else {
            if (index <= 0) return;
            dirs.remove(index);
            dirs.add(index - 1, dirToMove);
        }
        LinkedHashMap<TFile, List<TFile>> newMap = new LinkedHashMap<TFile, List<TFile>>(this.m_newMap.size());
        for (TFile dir : dirs) {
            newMap.put(dir, this.m_newMap.get(dir));
        }
        this.m_newMap = newMap;
    }

    @Override
    public void delete(TFile dir) {
        assert (dir != null) : "Parameter 'dir' of method 'delete' must not be null";
        TFile toRemove = dir.getNormalizedAbsoluteFile();
        this.m_newMap.remove(toRemove);
    }

    @Override
    public void replace(TFile oldDir, TFile newDir) {
        assert (oldDir != null) : "Parameter 'oldPath' of method 'replace' must not be null";
        assert (newDir != null) : "Parameter 'newPath' of method 'replace' must not be null";
        if (FileUtility.areEqual((TFile)oldDir, (TFile)newDir)) {
            return;
        }
        TFile toBeRemoved = oldDir.getNormalizedAbsoluteFile();
        TFile toBeAdded = newDir.getNormalizedAbsoluteFile();
        assert (!this.m_newMap.containsKey(toBeAdded)) : "newPath must not be present in search path";
        ArrayList<TFile> dirs = new ArrayList<TFile>(this.m_newMap.keySet());
        int index = dirs.indexOf(toBeRemoved);
        dirs.remove(index);
        dirs.add(index, toBeAdded);
        LinkedHashMap<TFile, List<TFile>> newMap = new LinkedHashMap<TFile, List<TFile>>(this.m_newMap.size());
        for (TFile dir : dirs) {
            newMap.put(dir, this.m_newMap.get(dir));
        }
        this.m_newMap = newMap;
    }

    public Map<TFile, List<TFile>> getNewMap() {
        return this.m_newMap;
    }

    public Map<TFile, List<TFile>> getOriginalMap() {
        return this.m_originalMap;
    }

    @Override
    public boolean isModified() {
        return !this.m_originalSearchPath.equals((Object)this.getModified());
    }

    @Override
    public SearchPath getOriginal() {
        return this.m_originalSearchPath;
    }

    @Override
    public SearchPath getModified() {
        return new SearchPath(this.m_newMap.keySet().toArray(new TFile[0]));
    }

    @Override
    public void dispose() {
    }

    @Override
    public void moveDirUp(TFile dir) {
        this.move(dir, false);
    }

    @Override
    public void moveDirDown(TFile dir) {
        this.move(dir, true);
    }
}

