/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.settings;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.TemplateUtility;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import gnu.trove.map.hash.THashMap;
import java.util.Map;

public class GroovyTemplateElement
extends NamedElement {
    private String m_name;
    private String m_templateText;
    private String m_resolvedText;
    private Map<String, Object> m_mappings;
    private String m_errorMsg;

    public GroovyTemplateElement(NamedElement parent) {
        super(parent);
    }

    public GroovyTemplateElement(NamedElement parent, String name, String templateText) {
        this(parent, name, templateText, null);
    }

    protected void addMappings(Map<String, Object> mappings) {
        assert (mappings != null) : "Parameter 'mappings' of method 'addMappings' must not be null";
    }

    public GroovyTemplateElement(NamedElement parent, String name, String templateText, Map<String, ? extends Object> mappings) {
        super(parent);
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'GroovyTemplate' must not be empty";
        assert (templateText != null) : "Parameter 'templateText' of method 'GroovyTemplate' must not be null";
        this.m_name = name;
        this.m_templateText = templateText;
        this.m_mappings = new THashMap(System.getenv());
        if (mappings != null) {
            for (Map.Entry<String, ? extends Object> entry : mappings.entrySet()) {
                this.m_mappings.put(entry.getKey(), entry.getValue());
            }
        }
        this.addMappings(this.m_mappings);
        try {
            this.m_resolvedText = TemplateUtility.expandTemplateText(this.m_templateText.trim().replace("\\", "\\\\"), this.m_mappings);
        }
        catch (Throwable e2) {
            this.m_resolvedText = this.m_errorMsg = "Failed to expand groovy template text for " + this.getName() + ": " + e2.getMessage();
        }
    }

    @Override
    public final String getShortName() {
        return this.m_name;
    }

    public final String getTemplateText() {
        return this.m_templateText;
    }

    public final String getResolvedText() {
        return this.m_resolvedText;
    }

    public final Map<String, ? extends Object> getMappings() {
        return this.m_mappings;
    }

    public final String getErrorMessage() {
        return this.m_errorMsg;
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public static boolean areEqual(GroovyTemplateElement template1, GroovyTemplateElement template2) {
        if (template1 == template2) {
            return true;
        }
        if (template1 == null || template2 == null) {
            return false;
        }
        if (!template1.getClass().equals(template2.getClass())) {
            return false;
        }
        if (!template1.getName().equals(template2.getName())) {
            return false;
        }
        if (!StringUtility.harmonizeNewLineBreaks((String)template1.getTemplateText()).trim().equals(StringUtility.harmonizeNewLineBreaks((String)template2.getTemplateText()).trim())) {
            return false;
        }
        if (template1.getResolvedText() == null && template2.getResolvedText() == null) {
            return true;
        }
        if (template1.getResolvedText() == null && template2.getResolvedText() != null) {
            return false;
        }
        return template1.getResolvedText().equals(template2.getResolvedText());
    }
}

