/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateElementCheckResult;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateResultStatus;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class QualityGateIssueConditionCheckResult
extends AbstractQualityGateElementCheckResult {
    private Set<Element> m_excluded;
    private Set<Element> m_resultingElements;
    private Set<Element> m_toleratedElements;

    public QualityGateIssueConditionCheckResult(NamedElement parent, IQualityGateElement element, QualityGateResultStatus result, Set<Element> matches) {
        super(parent, element, result, matches);
    }

    public void setExcluded(Set<Element> filtered) {
        assert (filtered != null) : "Parameter 'filtered' of method 'setExcluded' must not be null";
        if (this.m_excluded == null) {
            this.m_excluded = new LinkedHashSet<Element>();
        }
        this.m_excluded.addAll(filtered);
    }

    public Set<Element> getExcluded() {
        return this.m_excluded != null ? Collections.unmodifiableSet(this.m_excluded) : Collections.emptySet();
    }

    @Override
    public Set<Element> getResultingElements() {
        if (this.m_resultingElements == null) {
            this.m_resultingElements = new LinkedHashSet<Element>(this.getMatches());
            if (this.m_excluded != null) {
                this.m_resultingElements.removeAll(this.m_excluded);
            }
        }
        return this.m_resultingElements;
    }

    public void setToleratedElements(Set<Element> toleratedElements) {
        assert (toleratedElements != null) : "Parameter 'toleratedElements' of method 'setToleratedElements' must not be null";
        this.m_toleratedElements = toleratedElements;
    }

    public Set<Element> getToleratedElements() {
        return this.m_toleratedElements;
    }

    @Override
    public String getInformation() {
        StringBuilder info = new StringBuilder();
        info.append(this.getResultingElements().size()).append(" issues matched ");
        info.append("(").append(this.getExcluded().size()).append(" excluded");
        if (this.m_toleratedElements != null) {
            info.append(", ").append(this.getToleratedElements().size()).append(" tolerated");
        }
        info.append(")");
        return info.toString();
    }
}

