/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractQualityGateMatchingElement;
import java.util.List;

public final class QualityGateExcludeFilter
extends AbstractQualityGateMatchingElement {
    private String m_metricId;

    public QualityGateExcludeFilter(NamedElement parent, String issueType, List<String> severity, List<String> resolution) {
        super(parent, issueType, severity, resolution);
    }

    public QualityGateExcludeFilter(NamedElement parent, String issueType, String metricId, List<String> severity, List<String> resolution) {
        super(parent, issueType, severity, resolution);
        assert (metricId != null && metricId.length() > 0) : "Parameter 'metricId' of method 'QualityGateExcludeFilter' must not be empty";
        this.m_metricId = metricId;
    }

    @Override
    public String getImageResourceName() {
        return "Exclude";
    }

    @Override
    public String getShortName() {
        return this.getPresentationName(true);
    }

    @Property
    public String getMetricId() {
        return this.m_metricId;
    }

    @Override
    public String getDebugInfo() {
        if (this.m_metricId == null) {
            return super.getDebugInfo();
        }
        StringBuilder result = new StringBuilder(super.getDebugInfo());
        result.append('|').append(Element.escapeSpecialCharacters(this.m_metricId));
        return result.toString();
    }

    @Override
    public String getPresentationName(boolean shortName) {
        if (shortName) {
            StringBuilder builder = new StringBuilder(this.getClass().getSimpleName()).append('|');
            builder.append(this.getIssueType()).append('|');
            builder.append(QualityGateExcludeFilter.getSeverityAsString(this.getSeverityList())).append('|');
            builder.append(QualityGateExcludeFilter.getResolutionsAsString(this.getResolutionList()));
            if (this.m_metricId != null) {
                builder.append('|').append(this.m_metricId);
            }
            return builder.toString();
        }
        return QualityGateExcludeFilter.createPresentationNameLong(this.getIssueType(), this.getSeverityList(), this.getResolutionList(), this.getMetricId());
    }

    public static String createPresentationNameLong(String issueType, List<String> severities, List<String> resolutions, String metricId) {
        StringBuilder builder = new StringBuilder("Exclude issues of type");
        builder.append(" '").append(issueType).append("'");
        if (QualityGateExcludeFilter.isMetricInfoRelevant(issueType, metricId)) {
            builder.append(" for metric '").append(metricId).append("'");
        }
        builder.append(" with severity '").append(QualityGateExcludeFilter.getSeverityAsString(severities)).append("'");
        builder.append(" and resolution '").append(QualityGateExcludeFilter.getResolutionsAsString(resolutions)).append("'");
        return builder.toString();
    }
}

