/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.IQualityGateResultElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.issue.QualityGateProviderId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.List;

public final class QualityGate
extends ModifiableFile
implements ISoftwareSystemDefinitionElement,
IQualityGateElement,
IQualityGateElement.IQualityGateResultProvider {
    private String m_description;
    private boolean m_checked;
    private IQualityGateResultElement m_result;
    private final IProviderId m_issueProviderId;

    public QualityGate(NamedElement parent, TFile file, long timestamp, String description, IModifiablePathListener listener) {
        super(parent, file, listener);
        assert (description != null) : "Parameter 'description' of method 'QualityGate' must not be null";
        this.setTimestamp(timestamp);
        this.m_description = description;
        this.m_issueProviderId = new QualityGateProviderId(this.getIdentifyingPath());
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.QUALITY_GATE;
    }

    @Override
    @Property
    public String getDescription() {
        return this.m_description;
    }

    public IProviderId getIssueProviderId() {
        return this.m_issueProviderId;
    }

    public void setDescription(String description) {
        assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
        this.m_description = description;
    }

    public boolean canBeChecked() {
        return true;
    }

    public void setChecked(boolean checked) {
        this.m_checked = checked;
    }

    @Override
    @Property
    public String getInformation() {
        return this.isChecked() ? "Checked" : "";
    }

    @Property
    public boolean isChecked() {
        return this.m_checked;
    }

    @Override
    public IQualityGateElement.IQualityGateResultProvider getQualityGateResultProvider() {
        return this;
    }

    public void resetResult() {
        this.m_result = null;
    }

    public void setResult(IQualityGateResultElement result) {
        assert (result != null) : "Parameter 'result' of method 'setResult' must not be null";
        this.m_result = result;
    }

    @Override
    public IQualityGateResultElement getResultElementFor(IQualityGateElement element) {
        assert (element != null) : "Parameter 'element' of method 'getResultElementFor' must not be null";
        assert (element instanceof NamedElement) : "Unexpected class for element: " + element.getClass().getCanonicalName();
        if (this.m_result == null) {
            return null;
        }
        if (element == this) {
            return this.m_result;
        }
        NamedElement toSearch = (NamedElement)((Object)element);
        List<IQualityGateElement> hierarchy = toSearch.getParents(IQualityGateElement.class, QualityGate.class);
        Collections.reverse(hierarchy);
        hierarchy.add(element);
        IQualityGateResultElement match = null;
        NamedElement currentElement = (NamedElement)((Object)this.m_result);
        for (final IQualityGateElement next : hierarchy) {
            assert (next instanceof NamedElement) : "Unexpected class for next: " + next.getClass().getCanonicalName();
            match = currentElement.getUniqueChild(new NamedElement.IFilter(){

                @Override
                public boolean accept(NamedElement namedElement) {
                    if (!($assertionsDisabled || namedElement != null && namedElement instanceof IQualityGateResultElement)) {
                        throw new AssertionError((Object)("Unexpected class in method 'accept': " + namedElement));
                    }
                    return ((IQualityGateResultElement)((Object)namedElement)).getQualityGateElement() == next;
                }
            }, IQualityGateResultElement.class);
            if (match == null) {
                return null;
            }
            assert (match instanceof NamedElement) : "Unexpected class for match: " + next.getClass().getCanonicalName();
            currentElement = (NamedElement)((Object)match);
        }
        return match;
    }

    @Override
    public IQualityGateResultElement getResultElement() {
        return this.m_result;
    }
}

