/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.qualitygate;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.AbstractIssueDiffAgainstBaselineCondition;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGateDiffCheck;
import java.util.List;

public final class IssueDiffAgainstBaselineCondition
extends AbstractIssueDiffAgainstBaselineCondition {
    public IssueDiffAgainstBaselineCondition(NamedElement parent, String issueType, List<String> severities, List<String> resolutions, QualityGateDiffCheck check) {
        super(parent, issueType, severities, resolutions, check);
    }

    public IssueDiffAgainstBaselineCondition(NamedElement parent, String issueType, List<String> severities, List<String> resolutions) {
        super(parent, issueType, severities, resolutions);
    }

    @Override
    public String getPresentationName(boolean shortName) {
        if (shortName) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName()).append('|');
            builder.append(this.getIssueType()).append('|');
            builder.append(IssueDiffAgainstBaselineCondition.getSeverityAsString(this.getSeverityList())).append('|');
            builder.append(IssueDiffAgainstBaselineCondition.getResolutionsAsString(this.getResolutionList()));
            if (this.getCheck() != null) {
                builder.append('|');
                builder.append(this.getCheck().getStandardName());
            }
            return builder.toString();
        }
        return IssueDiffAgainstBaselineCondition.getPresentationNameLong(this.getIssueType(), this.getSeverityList(), this.getResolutionList(), this.getCheck());
    }

    public static String getPresentationNameLong(String issueType, List<String> severities, List<String> resolutions, QualityGateDiffCheck check) {
        StringBuilder builder = new StringBuilder();
        builder.append("No additional ");
        if (check != null) {
            builder.append("or worsened ");
        }
        builder.append("issues of type");
        builder.append(" '").append(issueType).append("'");
        builder.append(" with severity '").append(IssueDiffAgainstBaselineCondition.getSeverityAsString(severities)).append("'");
        builder.append(" and resolution '").append(IssueDiffAgainstBaselineCondition.getResolutionsAsString(resolutions)).append("'");
        if (check != null) {
            builder.append(", using '").append(check.getPresentationName()).append("' check");
        }
        return builder.toString();
    }
}

