/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.dynamic;

import com.hello2morrow.sonargraph.core.model.system.dynamic.AbstractInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleMappingInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathMappingInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SystemMappingInfo
extends AbstractInfo {
    private final List<ModuleMappingInfo> m_moduleMappings;
    private final Map<String, ModuleInfo> m_foreignNameToSonargraphModuleMap = new HashMap<String, ModuleInfo>();

    public SystemMappingInfo(String id, String name, String description, List<ModuleMappingInfo> moduleMappings) {
        super(id, name, description);
        assert (moduleMappings != null) : "Parameter 'moduleMappings' of method 'setModuleMappings' must not be null";
        this.m_moduleMappings = moduleMappings;
        this.initNameToModuleInfoMap(this.m_moduleMappings);
    }

    public SystemMappingInfo(List<ModuleInfo> projects) {
        assert (projects != null) : "Parameter 'projects' of method 'SystemMappingInfo' must not be null";
        this.m_moduleMappings = new ArrayList<ModuleMappingInfo>(projects.size());
        for (ModuleInfo project : projects) {
            ModuleMappingInfo info = new ModuleMappingInfo(null, project);
            for (RootPathInfo root : project.getNonStandardRootPaths()) {
                info.addRootPathMapping(new RootPathMappingInfo(info, root, EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.INACTIVE)));
            }
            for (RootPathInfo root : project.getStandardRootPaths()) {
                info.addRootPathMapping(new RootPathMappingInfo(info, root, EnumSet.of(RootPathMappingInfo.MappingStatus.EXTERNAL, RootPathMappingInfo.MappingStatus.INACTIVE)));
            }
            this.m_moduleMappings.add(info);
        }
        this.initNameToModuleInfoMap(this.m_moduleMappings);
    }

    private void initNameToModuleInfoMap(List<ModuleMappingInfo> moduleMappings) {
        for (ModuleMappingInfo next : moduleMappings) {
            if (!next.getExternalProject().isPresent() || !next.getSonargraphModule().isPresent()) continue;
            this.m_foreignNameToSonargraphModuleMap.put(next.getExternalProject().get().getName(), next.getSonargraphModule().get());
        }
    }

    public List<ModuleMappingInfo> getModuleMappings() {
        return Collections.unmodifiableList(this.m_moduleMappings);
    }

    public Optional<ModuleInfo> getSonargraphModuleForExternal(String externalModuleName) {
        assert (externalModuleName != null && externalModuleName.length() > 0) : "Parameter 'externalModuleName' of method 'getSonargraphModuleForExternal' must not be empty";
        return Optional.ofNullable(this.m_foreignNameToSonargraphModuleMap.get(externalModuleName));
    }
}

