/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.dynamic;

import com.hello2morrow.sonargraph.core.model.system.dynamic.IInfoWithMappingStatus;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathMappingInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ModuleMappingInfo
implements IInfoWithMappingStatus {
    private final ModuleInfo m_externalProject;
    private final ModuleInfo m_sonargraphModule;
    private final List<RootPathMappingInfo> m_rootPathMappings = new ArrayList<RootPathMappingInfo>(4);
    private final List<String> m_warningMessages = new ArrayList<String>();

    public ModuleMappingInfo(ModuleInfo sonargraphModule, ModuleInfo externalProject) {
        assert (sonargraphModule != null || externalProject != null) : "Either one of the provided module must not be null";
        this.m_externalProject = externalProject;
        this.m_sonargraphModule = sonargraphModule;
    }

    public Optional<ModuleInfo> getExternalProject() {
        return Optional.ofNullable(this.m_externalProject);
    }

    public Optional<ModuleInfo> getSonargraphModule() {
        return Optional.ofNullable(this.m_sonargraphModule);
    }

    @Override
    public boolean isMappingDefined() {
        return this.m_externalProject != null && this.m_sonargraphModule != null && !this.m_rootPathMappings.isEmpty();
    }

    public void addRootPathMapping(RootPathMappingInfo mapping) {
        assert (mapping != null) : "Parameter 'mapping' of method 'addRootPathMapping' must not be null";
        this.m_rootPathMappings.add(mapping);
    }

    public List<RootPathMappingInfo> getRootPaths(Predicate<RootPathMappingInfo> filterPredicate) {
        if (filterPredicate == null) {
            return Collections.unmodifiableList(this.m_rootPathMappings);
        }
        return this.m_rootPathMappings.stream().filter(filterPredicate).collect(Collectors.toList());
    }

    public void addWarningMessage(String message) {
        this.m_warningMessages.add(message);
    }

    public List<String> getWarningMessages() {
        return this.m_warningMessages;
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("sonargraphModule: ");
        if (this.m_sonargraphModule != null) {
            info.append(this.m_sonargraphModule.toString());
        } else {
            info.append("null");
        }
        info.append(", externalProject: ");
        if (this.m_externalProject != null) {
            info.append(this.m_externalProject.toString());
        } else {
            info.append("null");
        }
        return info.toString();
    }
}

