/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.dynamic;

import com.hello2morrow.sonargraph.core.model.system.dynamic.AbstractInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.RootPathType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ModuleInfo
extends AbstractInfo {
    private final String m_moduleType;
    private final String m_language;
    private final List<ModuleInfo> m_dependsUpon = new ArrayList<ModuleInfo>();
    private final List<RootPathInfo> m_rootPaths = new ArrayList<RootPathInfo>();

    public ModuleInfo(String id, String name, String description, String language, String moduleType) {
        super(id, name, description);
        assert (language != null && language.length() > 0) : "Parameter 'language' of method 'ModuleInfo' must not be empty";
        assert (moduleType != null && moduleType.length() > 0) : "Parameter 'moduleType' of method 'ModuleInfo' must not be empty";
        this.m_language = language;
        this.m_moduleType = moduleType;
    }

    public String getLanguage() {
        return this.m_language;
    }

    public String getModuleType() {
        return this.m_moduleType;
    }

    public void addDependsOn(ModuleInfo module) {
        assert (module != null) : "Parameter 'module' of method 'addDependsOn' must not be null";
        assert (!this.m_dependsUpon.contains(module)) : "Module '" + module.getId() + "' has already been added";
        this.m_dependsUpon.add(module);
    }

    public List<ModuleInfo> getDependsUpon() {
        return Collections.unmodifiableList(this.m_dependsUpon);
    }

    public void addRootPath(RootPathInfo root) {
        assert (root != null) : "Parameter 'root' of method 'addRootDirectory' must not be null";
        assert (!this.m_rootPaths.contains(root)) : "Root '" + root.getPath() + "' has already been added to module '" + this.getName() + "' (" + this.getId() + ")";
        this.m_rootPaths.add(root);
    }

    public void remove(RootPathInfo root) {
        assert (root != null) : "Parameter 'root' of method 'remove' must not be null";
        assert (this.m_rootPaths.contains(root)) : "Root path not found: " + root;
        this.m_rootPaths.remove(root);
    }

    public List<RootPathInfo> getStandardRootPaths() {
        return this.m_rootPaths.stream().filter(r2 -> r2.getType() == RootPathType.STANDARD).collect(Collectors.toList());
    }

    public List<RootPathInfo> getNonStandardRootPaths() {
        return this.m_rootPaths.stream().filter(r2 -> r2.getType() == RootPathType.NON_STANDARD).collect(Collectors.toList());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.m_dependsUpon.hashCode();
        result = 31 * result + this.m_language.hashCode();
        result = 31 * result + this.m_moduleType.hashCode();
        result = 31 * result + this.m_rootPaths.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        ModuleInfo other = (ModuleInfo)obj;
        return this.m_moduleType.equals(other.m_moduleType) && this.m_language.equals(other.m_language) && this.m_rootPaths.equals(other.m_rootPaths) && this.m_dependsUpon.equals(other.m_dependsUpon);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("ModuleInfo [id=").append(this.getId()).append(", name=").append(this.getName()).append(", moduleType=").append(this.m_moduleType).append(", language=").append(this.m_language).append("]");
        for (RootPathInfo root : this.getNonStandardRootPaths()) {
            result.append("\n        src root[path=" + root.getPath() + "]");
        }
        for (RootPathInfo root : this.getStandardRootPaths()) {
            result.append("\n        cls root[path=" + root.getPath() + "]");
        }
        return result.toString();
    }

    public ModuleInfo copy() {
        ModuleInfo copy = new ModuleInfo(this.getId(), this.getName(), this.getDescription(), this.getLanguage(), this.getModuleType());
        this.m_rootPaths.stream().map(root -> new RootPathInfo(root.getPath(), root.getType())).forEach(r2 -> copy.addRootPath((RootPathInfo)r2));
        this.m_dependsUpon.stream().forEach(d2 -> copy.addDependsOn((ModuleInfo)d2));
        return copy;
    }
}

