/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.dynamic;

import com.hello2morrow.sonargraph.core.model.system.dynamic.AbstractInfo;
import com.hello2morrow.sonargraph.core.model.system.dynamic.ModuleInfo;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DynamicSystemInfo
extends AbstractInfo {
    private final List<ModuleInfo> m_modules = new ArrayList<ModuleInfo>();
    private File m_tsConfigFile;
    private File m_pythonRoot;
    private File m_pythonVirtualEnvironment;

    public DynamicSystemInfo(String id, String name, String description) {
        super(id, name, description);
    }

    public void addModule(ModuleInfo module) {
        assert (module != null) : "Parameter 'module' of method 'addModule' must not be null";
        assert (!this.m_modules.contains(module)) : "Module has already been added: " + module.toString();
        assert (!this.m_modules.stream().anyMatch(m2 -> m2.getId().equals(module.getId()) || m2.getName().equals(module.getName()))) : "Module with same id or name has already been added: " + module.toString();
        this.m_modules.add(module);
    }

    public List<ModuleInfo> getModules() {
        return Collections.unmodifiableList(this.m_modules);
    }

    public ModuleInfo getModuleInfo(String name) {
        return this.m_modules.stream().filter(m2 -> m2.getName().equals(name)).findFirst().orElse(null);
    }

    public File getTsConfigFile() {
        return this.m_tsConfigFile;
    }

    public void setTsConfigFile(File tsConfigFile) {
        this.m_tsConfigFile = tsConfigFile;
    }

    public TFile getPythonRoot() {
        return this.m_pythonRoot != null ? new TFile(this.m_pythonRoot) : null;
    }

    public void setPythonRoot(File pythonRoot) {
        this.m_pythonRoot = pythonRoot;
    }

    public TFile getPythonVirtualEnvironment() {
        return this.m_pythonVirtualEnvironment != null ? new TFile(this.m_pythonVirtualEnvironment) : null;
    }

    public void setPythonVirtualEnvironment(File pythonVirtualEnv) {
        this.m_pythonVirtualEnvironment = pythonVirtualEnv;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("DynamicSystemInfo[name=").append(this.getName()).append(", id=").append(this.getId()).append("]");
        for (ModuleInfo module : this.getModules()) {
            result.append("\n    ").append(module.toString());
        }
        return result.toString();
    }
}

