/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.resolution;

import com.hello2morrow.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.NamedElementDiff;
import com.hello2morrow.sonargraph.integration.access.model.IResolution;
import java.util.Date;

public abstract class ResolutionDefinitionDiff<B extends IResolution, C extends Resolution>
extends NamedElementDiff<B, C> {
    public ResolutionDefinitionDiff(NamedElement parent, B baseline, C current, IDiffElement.Change change) {
        super(parent, baseline, current, change);
    }

    public ResolutionDefinitionDiff(NamedElement parent, B baseline, C current, IDiffElement.Change change, String description) {
        super(parent, baseline, current, change, description);
    }

    @Override
    public String getShortName() {
        return this.getCurrent() != null ? ((Resolution)this.getCurrent()).getShortName() : ((IResolution)this.getBaseline()).getName();
    }

    public String getDefinition() {
        String information;
        String presentationName;
        if (this.getCurrent() != null) {
            presentationName = ((Resolution)this.getCurrent()).getPresentationName(true);
            information = ((Resolution)this.getCurrent()).getInformation();
        } else {
            presentationName = ((IResolution)this.getBaseline()).getType().getPresentationName();
            information = ((IResolution)this.getBaseline()).getInformation();
        }
        String infoString = information != null && !information.isEmpty() ? " '" + information + "'" : "";
        String baselinePostFix = this.getCurrent() == null ? " [Baseline]" : "";
        return String.valueOf(presentationName) + infoString + baselinePostFix;
    }

    public final String getCreatedAsFormattedString() {
        Date date = this.getCurrent() != null ? ((Resolution)this.getCurrent()).getDate() : ((IResolution)this.getBaseline()).getCreationDate();
        return Iso8601DateFormat.formatDateAndTime((Date)date);
    }

    public final int getMatchingElementsCount() {
        if (this.getCurrent() != null) {
            return ((Resolution)this.getCurrent()).getMatchingElementsCount();
        }
        return ((IResolution)this.getBaseline()).getMatchingElementsCount();
    }

    @Override
    public final String getDescription() {
        if (this.getCurrent() != null) {
            return ((Resolution)this.getCurrent()).getDescription();
        }
        return ((IResolution)this.getBaseline()).getDescription();
    }
}

