/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.issue;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.StructureContainerDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IIssueDiff;
import java.util.ArrayList;
import java.util.List;

public final class IssuesDiff
extends StructureContainerDiff {
    public IssuesDiff(NamedElement parent) {
        super(parent, IssuesDiff.class.getSimpleName());
    }

    public List<IIssueDiff> getIssuesWithoutUnchangedResolution() {
        ArrayList<IIssueDiff> issues = new ArrayList<IIssueDiff>();
        for (IIssueDiff next : this.getChildren(IIssueDiff.class)) {
            if (next.hasUnchangedResolutionKind() || next.getChange() == IDiffElement.Change.ADDED && next.getCurrent().getResolution() != null || next.getChange() == IDiffElement.Change.REMOVED && next.getBaseline().hasResolution()) continue;
            issues.add(next);
        }
        return issues;
    }

    @Override
    public IDiffElement.Change getChange() {
        List<IIssueDiff> issuesWithoutUnchangedResolution = this.getIssuesWithoutUnchangedResolution();
        boolean anyModifiedIssueExists = issuesWithoutUnchangedResolution.stream().anyMatch(i2 -> i2.getChange() != IDiffElement.Change.UNMODIFIED);
        return anyModifiedIssueExists ? IDiffElement.Change.MODIFIED : IDiffElement.Change.UNMODIFIED;
    }
}

