/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.duplicate;

import com.hello2morrow.foundation.text.IntBasedHash;

public abstract class DuplicateOccurrenceDto<T>
implements Comparable<DuplicateOccurrenceDto<?>> {
    private final T m_occurrence;

    public DuplicateOccurrenceDto(T occurrence) {
        assert (occurrence != null) : "Parameter 'occurrence' of method 'DuplicateOccurrenceDto' must not be null";
        this.m_occurrence = occurrence;
    }

    public final T getOccurrence() {
        return this.m_occurrence;
    }

    public abstract IntBasedHash getHash();

    public abstract int getStart();

    public abstract int getEnd();

    public final int getBlockSize() {
        return this.getEnd() + 1 - this.getStart();
    }

    public abstract String getSourceFqName();

    public abstract String getIdentifyingPath();

    public final String toString() {
        return "DuplicateOccurrenceDto [sourceFqName=" + this.getSourceFqName() + ", start=" + this.getStart() + ", end=" + this.getEnd() + "]";
    }

    @Override
    public final int compareTo(DuplicateOccurrenceDto<?> other) {
        assert (other != null) : "Parameter 'other' of method 'compareTo' must not be null";
        int compareFqNames = this.getSourceFqName().compareTo(other.getSourceFqName());
        if (compareFqNames != 0) {
            return compareFqNames;
        }
        int compareStart = Integer.compare(this.getStart(), other.getStart());
        if (compareStart != 0) {
            return compareStart;
        }
        return Integer.compare(this.getEnd(), other.getEnd());
    }
}

