/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff.analyzer;

import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SimpleDiff;

public final class ScriptRunnerEntryDiff
extends SimpleDiff<String, String> {
    private final String m_scriptName;
    private final String m_runConfigurationName;

    public ScriptRunnerEntryDiff(NamedElement parent, String baselineValue, String currentValue, IDiffElement.Change change) {
        super(parent, baselineValue, currentValue, change);
        assert (change == IDiffElement.Change.ADDED || change == IDiffElement.Change.REMOVED || change == IDiffElement.Change.UNMODIFIED) : "Unsupported change " + change.getStandardName();
        Pair<String, String> configurationParts = baselineValue != null ? ScriptRunnerEntryDiff.splitConfig(baselineValue) : ScriptRunnerEntryDiff.splitConfig(currentValue);
        this.m_scriptName = (String)configurationParts.getFirst();
        this.m_runConfigurationName = (String)configurationParts.getSecond();
    }

    public String getScriptName() {
        return this.m_scriptName;
    }

    public String getRunConfigurationName() {
        return this.m_runConfigurationName;
    }

    @Override
    public String getShortName() {
        return String.valueOf(this.m_scriptName) + ":" + this.m_runConfigurationName;
    }

    private static Pair<String, String> splitConfig(String configValue) {
        int indexOfColon = configValue.indexOf(58);
        if (indexOfColon < 0) {
            throw new IllegalArgumentException("Invalid ScriptRunner configuration value does not contain a ':': " + configValue);
        }
        return new Pair((Object)configValue.substring(0, indexOfColon).trim(), (Object)configValue.substring(indexOfColon + 1, configValue.length()).trim());
    }

    @Override
    public boolean providesChangeDescription() {
        return false;
    }

    @Override
    public String getImageResourceName() {
        return "GroovyScript";
    }
}

