/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.diff.DiffUtility;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;

public abstract class StructureContainerDiff
extends NamedElementContainer
implements IDiffElement {
    private final String m_name;
    private final String m_presentationName;
    private IDiffElement.Change m_change;
    private final NamedElement m_currentElement;

    protected StructureContainerDiff(NamedElement parent, String name) {
        this(parent, null, name);
    }

    protected StructureContainerDiff(NamedElement parent, NamedElement currentElement, String name) {
        this(parent, currentElement, name, name, null);
    }

    protected StructureContainerDiff(NamedElement parent, NamedElement currentElement, String name, String presentationName) {
        this(parent, currentElement, name, presentationName, null);
    }

    protected StructureContainerDiff(NamedElement parent, NamedElement currentElement, String name, String presentationName, IDiffElement.Change change) {
        super(parent);
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'StructureContainerDelta' must not be empty";
        assert (presentationName != null && presentationName.length() > 0) : "Parameter 'presentationName' of method 'StructureContainerDelta' must not be empty";
        this.m_currentElement = currentElement;
        this.m_name = name;
        this.m_presentationName = presentationName;
        this.m_change = change;
    }

    @Override
    public final NamedElement getElement() {
        return this;
    }

    @Override
    public NamedElement getCurrentElement() {
        return this.m_currentElement;
    }

    @Override
    @Property
    public IDiffElement.Change getChange() {
        if (this.m_change == null) {
            this.m_change = DiffUtility.calculateChange(this, null);
        }
        return this.m_change;
    }

    @Override
    public String getPresentationName(boolean shortName) {
        return this.m_presentationName;
    }

    @Override
    public String getShortName() {
        return this.m_name;
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public String getImageResourceName() {
        if (this.getCurrentElement() != null) {
            return this.getCurrentElement().getImageResourceName();
        }
        return null;
    }

    @Override
    @Property
    public String getChangeDescription() {
        if (this.m_change == IDiffElement.Change.MODIFIED) {
            return "Contained elements changed.";
        }
        return "";
    }
}

