/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IExtension;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.system.BaselinesDirectory;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineInfo;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.MetricValueDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface ISystemDiffProvider
extends IExtension {
    public BaselinesDirectory getBaselinesDirectory();

    public OperationResultWithOutcome<BaselineInfo> getBaselineInfo(TFile var1);

    public String createDiffFileName(String var1, Date var2);

    public void clear();

    public TFile getActiveBaseline();

    public Pair<String, TFile> getActiveBaselineInfo();

    public DiffConfiguration getDiffConfiguration();

    public SoftwareSystemDiff getSoftwareSystemDiff();

    public boolean isDiffConfigurationEnabled();

    public boolean isLicensedAndEnabled();

    public boolean isSystemDiffActive();

    public List<Issue> getSystemDiffErrorIssues();

    public IPathValidator getBaselineValidator();

    public String getBaselineFileNameProposal();

    public TFile getDefaultLocalBaselineDirectory();

    public List<BaselineInfo> getRecentlyUsedBaselineReports(BaselineType var1);

    public IDiffElement getFirstDiffElement(List<Element> var1);

    public MetricValueDiff getMetricDiff(SoftwareSystemDiff var1, IMetricDescriptor var2);

    public boolean mayBeActivated(List<Element> var1);

    public boolean mayBeDeactivated(List<Element> var1);

    public static final class DiffConfiguration {
        private final BaselineType m_type;
        private final TFile m_localBaseline;
        private final boolean m_isActive;
        private final TFile m_systemBaseline;

        public DiffConfiguration(BaselineType type, TFile localBaseline, TFile systemBaseline, boolean isActive) {
            assert (type != null) : "Parameter 'type' of method 'DiffConfiguration' must not be null";
            this.m_type = type;
            this.m_localBaseline = localBaseline;
            this.m_systemBaseline = systemBaseline;
            this.m_isActive = isActive;
        }

        public BaselineType getType() {
            return this.m_type;
        }

        public TFile getLocalBaseline() {
            return this.m_localBaseline;
        }

        public TFile getSystemBaseline() {
            return this.m_systemBaseline;
        }

        public boolean isActive() {
            return this.m_isActive;
        }
    }

    public static final class DiffElementCollector
    extends NamedElementVisitor {
        private final List<IDiffElement> m_collectedElements = new ArrayList<IDiffElement>();
        private final Set<IDiffElement.Change> m_changesToCollect;

        public DiffElementCollector(Set<IDiffElement.Change> changesToCollect) {
            assert (changesToCollect != null && !changesToCollect.isEmpty()) : "Parameter 'changesToCollect' of method 'DiffElementCollector' must not be empty";
            this.m_changesToCollect = changesToCollect;
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            IDiffElement diff;
            if (element.hasChildren()) {
                this.visitChildrenOf(element);
                return;
            }
            if (element instanceof IDiffElement && this.m_changesToCollect.contains((Object)(diff = (IDiffElement)((Object)element)).getChange())) {
                this.m_collectedElements.add(diff);
            }
        }

        public List<IDiffElement> getCollectedElements() {
            return this.m_collectedElements;
        }
    }
}

