/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ISourceElementProvider;
import com.hello2morrow.sonargraph.integration.access.model.IElement;

public interface IDiffElement
extends ISourceElementProvider {
    public static final String BASELINE_POSTFIX = " [Baseline]";

    public Change getChange();

    public String getChangeDescription();

    default public Element getCurrentElement() {
        return null;
    }

    @Override
    default public Element getSourceElement() {
        return this.getCurrentElement();
    }

    default public IElement getBaselineElement() {
        return null;
    }

    public String getPresentationName(boolean var1);

    public static enum Change implements IStandardEnumeration
    {
        ADDED,
        WORSENED,
        MODIFIED,
        RESOLUTION_ADDED("Removed [Resolution Added]"),
        RESOLUTION_REMOVED("Added [Resolution Removed]"),
        IMPROVED,
        REMOVED,
        UNMODIFIED;

        final String m_presentationName;

        private Change() {
            this.m_presentationName = null;
        }

        private Change(String presentationName) {
            this.m_presentationName = presentationName;
        }

        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName((String)this.name());
        }

        public String getPresentationName() {
            if (this.m_presentationName != null) {
                return this.m_presentationName;
            }
            return StringUtility.convertConstantNameToPresentationName((String)this.name());
        }

        public String toString() {
            return this.getPresentationName();
        }
    }
}

