/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system.diff;

import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.Iso8601DateFormat;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import de.schlichtherle.truezip.file.TFile;
import java.util.Date;

public final class Baseline
extends ModifiableFile
implements ISoftwareSystemDefinitionElement {
    private final String m_description;
    private boolean m_isActive = false;
    private final Date m_creationDate;

    public Baseline(NamedElement parent, TFile file, Date creationDate, String description, IModifiablePathListener listener) {
        super(parent, file, listener);
        assert (description != null) : "Parameter 'description' of method 'Baseline' must not be null";
        assert (creationDate != null) : "Parameter 'creationDate' of method 'Baseline' must not be null";
        this.m_description = description;
        this.m_creationDate = creationDate;
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.BASELINE;
    }

    @Override
    public String getImageResourceName() {
        return "Baseline";
    }

    @Override
    @Property
    public String getDescription() {
        return this.m_description;
    }

    public void setActive(boolean isActive) {
        this.m_isActive = isActive;
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    @Property
    public String creationDate() {
        return Iso8601DateFormat.formatDateAndTime((Date)this.m_creationDate);
    }
}

