/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.IWorkspaceProfilePattern;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class WorkspaceProfileRootPathMapping {
    private final Map<Module, List<RootDirectoryPath>> m_modulesToPaths = new LinkedHashMap<Module, List<RootDirectoryPath>>();
    private final Map<RootDirectoryPath, String> m_mappings = new LinkedHashMap<RootDirectoryPath, String>();
    private final Map<RootDirectoryPath, ValidationResult> m_mappingValidations = new HashMap<RootDirectoryPath, ValidationResult>();
    private final List<IWorkspaceProfilePattern> m_patterns;

    public WorkspaceProfileRootPathMapping(List<IWorkspaceProfilePattern> patterns) {
        assert (patterns != null) : "Parameter 'patterns' of method 'WorkspaceProfileRootPathMapping' must not be null";
        this.m_patterns = patterns;
    }

    public List<IWorkspaceProfilePattern> getPatterns() {
        return this.m_patterns;
    }

    public void addMapping(Module module, RootDirectoryPath path, String translation, ValidationResult result) {
        assert (module != null) : "Parameter 'module' of method 'addMapping' must not be null";
        assert (path != null) : "Parameter 'path' of method 'addMapping' must not be null";
        assert (translation != null) : "Parameter 'translation' of method 'addMapping' must not be null";
        List<RootDirectoryPath> paths = this.m_modulesToPaths.get(module);
        if (paths == null) {
            paths = new ArrayList<RootDirectoryPath>();
            this.m_modulesToPaths.put(module, paths);
        }
        paths.add(path);
        this.m_mappings.put(path, translation);
        this.m_mappingValidations.put(path, result);
    }

    public boolean isSuccess() {
        boolean errorsExist = this.m_mappingValidations.values().stream().anyMatch(r2 -> r2.hasErrors());
        return !errorsExist;
    }

    public List<Module> getModules() {
        return new ArrayList<Module>(this.m_modulesToPaths.keySet());
    }

    public boolean hasWarnings() {
        return this.m_mappingValidations.values().stream().anyMatch(r2 -> r2.hasWarnings());
    }

    public Map<RootDirectoryPath, ValidationResult> getMappingResults() {
        return Collections.unmodifiableMap(this.m_mappingValidations);
    }

    public List<RootDirectoryPath> getRootDirectoryPaths(Module module) {
        assert (module != null) : "Parameter 'module' of method 'getRootDirectoryPaths' must not be null";
        assert (this.m_modulesToPaths.containsKey(module)) : "no paths have been added for module '" + module.getName() + "'";
        return this.m_modulesToPaths.get(module);
    }

    public String getTranslation(RootDirectoryPath path) {
        assert (path != null) : "Parameter 'path' of method 'getTranslation' must not be null";
        assert (this.m_mappings.containsKey(path)) : "No mapping has been added to path '" + path.getFullyQualifiedName() + "'";
        return this.m_mappings.get(path);
    }

    public ValidationResult getMappingResult(RootDirectoryPath path) {
        assert (path != null) : "Parameter 'path' of method 'getMappingResult' must not be null";
        assert (this.m_mappingValidations.containsKey(path)) : "No validation result has been added to path '" + path.getFullyQualifiedName() + "'";
        return this.m_mappingValidations.get(path);
    }
}

