/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class WorkspaceProfile
extends ModifiableFile
implements ISoftwareSystemDefinitionElement {
    private final Map<String, String> m_resolutionMappings = new LinkedHashMap<String, String>();
    private boolean m_overrideWorkspaceFilter;
    private String m_description = "";

    public WorkspaceProfile(NamedElement parent, TFile file, IModifiablePathListener listener) {
        super(parent, file, listener);
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.WORKSPACE_PROFILE;
    }

    public void setOverrideWorkspaceFilter(boolean overrideWorkspaceFilter) {
        this.m_overrideWorkspaceFilter = overrideWorkspaceFilter;
    }

    public boolean overrideWorkspaceFilter() {
        return this.m_overrideWorkspaceFilter;
    }

    public void setDescription(String description) {
        assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
        this.m_description = description;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public final String getImageResourceName() {
        return "WorkspaceProfile";
    }

    @Override
    public String getPresentationKind() {
        return "Workspace Profile";
    }

    public void setResolutionMappings(Map<String, String> mappings) {
        assert (mappings != null) : "Parameter 'mappings' of method 'setResolutionMappings' must not be null";
        this.m_resolutionMappings.clear();
        this.m_resolutionMappings.putAll(mappings);
    }

    public Map<String, String> getResolutionMappings() {
        return Collections.unmodifiableMap(this.m_resolutionMappings);
    }

    @Override
    public String getDebugInfo() {
        if (!this.m_resolutionMappings.isEmpty()) {
            StringBuilder builder = new StringBuilder(super.getDebugInfo());
            builder.append(StringUtility.LINE_SEPARATOR);
            for (Map.Entry<String, String> nextEntry : this.m_resolutionMappings.entrySet()) {
                builder.append("Mapping: ");
                builder.append(nextEntry.getKey());
                builder.append("=>");
                builder.append(nextEntry.getValue());
                builder.append(StringUtility.LINE_SEPARATOR);
            }
            return builder.toString();
        }
        return super.getDebugInfo();
    }
}

