/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IIssueAffectedElementType;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.system.FilterCriterionIssueCounter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class UsedIssueInfo {
    private final IIssueAffectedElementType[] m_availableIssueTypes;
    private final Map<IIssueId, FilterCriterionIssueCounter<IIssueId>> m_usedIssueIds = new HashMap<IIssueId, FilterCriterionIssueCounter<IIssueId>>();
    private final Map<IssueCategory, FilterCriterionIssueCounter<IssueCategory>> m_usedCategories = new HashMap<IssueCategory, FilterCriterionIssueCounter<IssueCategory>>();
    private final Map<IProviderId, FilterCriterionIssueCounter<IProviderId>> m_usedProvidersIds = new HashMap<IProviderId, FilterCriterionIssueCounter<IProviderId>>();
    private final Map<Severity, FilterCriterionIssueCounter<Severity>> m_usedSeverities = new HashMap<Severity, FilterCriterionIssueCounter<Severity>>();
    private final Map<IIssueAffectedElementType, FilterCriterionIssueCounter<IIssueAffectedElementType>> m_usedTypes = new HashMap<IIssueAffectedElementType, FilterCriterionIssueCounter<IIssueAffectedElementType>>();

    UsedIssueInfo(Collection<Issue> issues, IIssueAffectedElementType[] availableIssueTypes) {
        assert (issues != null) : "Parameter 'issues' of method 'UsedIssueInfo' must not be null";
        assert (availableIssueTypes != null) : "Parameter 'availableIssueTypes' of method 'UsedIssueInfo' must not be null";
        this.m_availableIssueTypes = availableIssueTypes;
        for (Issue nextIssue : issues) {
            IResolution resolution = nextIssue.getResolution();
            if (nextIssue.isExcluded() || resolution != null) continue;
            FilterCriterionIssueCounter<IIssueId> idCriterion = this.m_usedIssueIds.get(nextIssue.getId());
            if (idCriterion == null) {
                idCriterion = new FilterCriterionIssueCounter<IIssueId>(nextIssue.getId());
                this.m_usedIssueIds.put(nextIssue.getId(), idCriterion);
            }
            idCriterion.increment();
            FilterCriterionIssueCounter<IProviderId> providerCriterion = this.m_usedProvidersIds.get(nextIssue.getProvider());
            if (providerCriterion == null) {
                providerCriterion = new FilterCriterionIssueCounter<IProviderId>(nextIssue.getProvider());
                this.m_usedProvidersIds.put(nextIssue.getProvider(), providerCriterion);
            }
            providerCriterion.increment();
            IssueCategory category = nextIssue.getId().getCategory();
            FilterCriterionIssueCounter<IssueCategory> categoryCriterion = this.m_usedCategories.get((Object)category);
            if (categoryCriterion == null) {
                categoryCriterion = new FilterCriterionIssueCounter<IssueCategory>(category);
                this.m_usedCategories.put(category, categoryCriterion);
            }
            categoryCriterion.increment();
            FilterCriterionIssueCounter<Severity> severityCriterion = this.m_usedSeverities.get((Object)nextIssue.getSeverity());
            if (severityCriterion == null) {
                severityCriterion = new FilterCriterionIssueCounter<Severity>(nextIssue.getSeverity());
                this.m_usedSeverities.put(nextIssue.getSeverity(), severityCriterion);
            }
            severityCriterion.increment();
            IIssueAffectedElementType[] iIssueAffectedElementTypeArray = this.m_availableIssueTypes;
            int n2 = this.m_availableIssueTypes.length;
            int n3 = 0;
            while (n3 < n2) {
                IIssueAffectedElementType elementType = iIssueAffectedElementTypeArray[n3];
                if (elementType.matches(nextIssue.getClass())) {
                    FilterCriterionIssueCounter<IIssueAffectedElementType> elementTypeCriterion = this.m_usedTypes.get(elementType);
                    if (elementTypeCriterion == null) {
                        elementTypeCriterion = new FilterCriterionIssueCounter<IIssueAffectedElementType>(elementType);
                        this.m_usedTypes.put(elementType, elementTypeCriterion);
                    }
                    elementTypeCriterion.increment();
                }
                ++n3;
            }
        }
    }

    public void add(UsedIssueInfo usedIssueInfo) {
        assert (usedIssueInfo != null) : "Parameter 'usedIssueInfo' of method 'add' must not be null";
        assert (this != usedIssueInfo) : "Used issue info must be a different instance";
        for (Map.Entry<IssueCategory, FilterCriterionIssueCounter<IssueCategory>> entry : usedIssueInfo.m_usedCategories.entrySet()) {
            FilterCriterionIssueCounter<IssueCategory> categoryCriterion = this.m_usedCategories.get((Object)entry.getKey());
            if (categoryCriterion == null) {
                this.m_usedCategories.put(entry.getKey(), entry.getValue());
                continue;
            }
            categoryCriterion.incrementBy(entry.getValue().getIssueCount());
        }
        for (Map.Entry<IStandardEnumeration, FilterCriterionIssueCounter<IStandardEnumeration>> entry : usedIssueInfo.m_usedIssueIds.entrySet()) {
            FilterCriterionIssueCounter<IIssueId> issueIdCriterion = this.m_usedIssueIds.get(entry.getKey());
            if (issueIdCriterion == null) {
                this.m_usedIssueIds.put((IIssueId)entry.getKey(), entry.getValue());
                continue;
            }
            issueIdCriterion.incrementBy(entry.getValue().getIssueCount());
        }
        for (Map.Entry<IStandardEnumeration, FilterCriterionIssueCounter<IStandardEnumeration>> entry : usedIssueInfo.m_usedProvidersIds.entrySet()) {
            FilterCriterionIssueCounter<IProviderId> providerIdCriterion = this.m_usedProvidersIds.get(entry.getKey());
            if (providerIdCriterion == null) {
                this.m_usedProvidersIds.put((IProviderId)entry.getKey(), entry.getValue());
                continue;
            }
            providerIdCriterion.incrementBy(entry.getValue().getIssueCount());
        }
        for (Map.Entry<IStandardEnumeration, FilterCriterionIssueCounter<IStandardEnumeration>> entry : usedIssueInfo.m_usedSeverities.entrySet()) {
            FilterCriterionIssueCounter<Severity> severityCriterion = this.m_usedSeverities.get(entry.getKey());
            if (severityCriterion == null) {
                this.m_usedSeverities.put((Severity)entry.getKey(), entry.getValue());
                continue;
            }
            severityCriterion.incrementBy(entry.getValue().getIssueCount());
        }
        for (Map.Entry<IStandardEnumeration, FilterCriterionIssueCounter<IStandardEnumeration>> entry : usedIssueInfo.m_usedTypes.entrySet()) {
            FilterCriterionIssueCounter<IIssueAffectedElementType> typeCriterion = this.m_usedTypes.get(entry.getKey());
            if (typeCriterion == null) {
                this.m_usedTypes.put((IIssueAffectedElementType)entry.getKey(), entry.getValue());
                continue;
            }
            typeCriterion.incrementBy(entry.getValue().getIssueCount());
        }
    }

    public boolean contains(IStandardEnumeration item) {
        if (item instanceof IssueCategory) {
            return this.m_usedCategories.containsKey(item);
        }
        if (item instanceof IIssueId) {
            return this.m_usedIssueIds.containsKey(item);
        }
        if (item instanceof IProviderId) {
            return this.m_usedProvidersIds.containsKey(item);
        }
        if (item instanceof Severity) {
            return this.m_usedSeverities.containsKey(item);
        }
        if (item instanceof IIssueAffectedElementType) {
            return this.m_usedTypes.containsKey(item);
        }
        assert (false) : "Unexpected class for 'item' in method 'contains' " + item;
        return false;
    }

    public FilterCriterionIssueCounter<? extends IStandardEnumeration> getCriterion(IStandardEnumeration item) {
        if (item instanceof IssueCategory) {
            return this.m_usedCategories.get(item);
        }
        if (item instanceof IIssueId) {
            return this.m_usedIssueIds.get(item);
        }
        if (item instanceof IProviderId) {
            return this.m_usedProvidersIds.get(item);
        }
        if (item instanceof Severity) {
            return this.m_usedSeverities.get(item);
        }
        if (item instanceof IIssueAffectedElementType) {
            return this.m_usedTypes.get(item);
        }
        assert (false) : "Unexpected class for 'item' in method 'getCriterion' " + item;
        return null;
    }
}

