/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.CoreStructureItem;
import com.hello2morrow.sonargraph.core.model.element.IStructureItem;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public final class StructureInfo {
    private final LinkedList<IStructureItem> m_itemList;

    public StructureInfo(List<IStructureItem> items) {
        assert (items != null && items.size() > 0) : "Parameter 'items' of method 'Structure' must not be null";
        this.m_itemList = new LinkedList<IStructureItem>(items);
    }

    public IStructureItem getPrevious(IStructureItem current) {
        try {
            return this.getIteratorAtItem(current).previous();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    public IStructureItem getNext(IStructureItem current) {
        assert (current != null) : "Parameter 'current' of method 'getNext' must not be null";
        try {
            ListIterator<IStructureItem> it = this.getIteratorAtItem(current);
            it.next();
            return (IStructureItem)it.next();
        }
        catch (NoSuchElementException e2) {
            return null;
        }
    }

    private ListIterator<IStructureItem> getIteratorAtItem(IStructureItem current) {
        assert (current != null) : "Parameter 'current' of method 'getPrevious' must not be null";
        int index = this.m_itemList.indexOf(current);
        assert (index > -1) : "Element not contained in the registry: " + current;
        ListIterator<IStructureItem> iterator = this.m_itemList.listIterator(index);
        return iterator;
    }

    public boolean isLastElementInStructure(IStructureItem item) {
        assert (item != null) : "Parameter 'item' of method 'isLastElementInStructure' must not be null";
        if (item instanceof CoreStructureItem) {
            return true;
        }
        return this.getPositionInStructure(item) == this.m_itemList.size() - 1;
    }

    public int getPositionInStructure(IStructureItem item) {
        assert (item != null) : "Parameter 'item' of method 'getPositionInLanguage' must not be null";
        int position = this.m_itemList.indexOf(item);
        if (position == -1) assert (false) : "'" + item + "' is not in the language structure item registry";
        if (item instanceof CoreStructureItem) {
            return Integer.MAX_VALUE;
        }
        return position;
    }

    public int compare(IStructureItem item1, IStructureItem item2) {
        assert (item1 != null) : "Parameter 'item1' of method 'compare' must not be null";
        assert (item2 != null) : "Parameter 'item2' of method 'compare' must not be null";
        assert (this.isInStructure(item1)) : item1 + " not in structure " + this;
        assert (this.isInStructure(item2)) : item2 + " not in structure " + this;
        return Integer.compare(this.getPositionInStructure(item1), this.getPositionInStructure(item2));
    }

    public boolean isInStructure(IStructureItem item) {
        assert (item != null) : "Parameter 'item' of method 'isInStructure' must not be null";
        return this.m_itemList.contains(item);
    }

    public List<IStructureItem> getItemList() {
        return Collections.unmodifiableList(this.m_itemList);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (IStructureItem item : this.m_itemList) {
            builder.append(item.toString());
            builder.append(StringUtility.LINE_SEPARATOR);
        }
        return builder.toString();
    }
}

