/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.foundation.common.history.HistoryTable;
import com.hello2morrow.sonargraph.core.foundation.common.history.ModifiableFileHistory;
import com.hello2morrow.sonargraph.core.model.system.NeedsReparse;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemFileEntry;
import java.util.List;

public final class SoftwareSystemFileHistory
extends ModifiableFileHistory
implements SoftwareSystemFileEntry.INeedsReparseFlagListener {
    public SoftwareSystemFileHistory(String name, String id) {
        super(name, id);
    }

    @Override
    public void entryChanged(HistoryTable.ITableEntry entry) {
        assert (entry != null) : "Parameter 'entry' of method 'entryChanged' must not be null";
        assert (entry instanceof SoftwareSystemFileEntry) : "Unexpected class: " + entry.getClass().getName();
        super.entryChanged(entry);
    }

    @Override
    public ModifiableFileHistory.FileHistoryEntry createEntry(long transactionId, String commandName, String identifyingPath) {
        return new SoftwareSystemFileEntry(this, this, commandName, transactionId, identifyingPath);
    }

    @Override
    public void needsReparseChanged(SoftwareSystemFileEntry entry, boolean invalidatesParserModel) {
        assert (entry != null) : "Parameter 'entry' of method 'needsReparseChanged' must not be null";
        if (invalidatesParserModel) {
            for (ModifiableFileHistory.FileHistoryEntry nextEntry : this.getEntries()) {
                if (nextEntry.equals(entry)) continue;
                SoftwareSystemFileEntry fileEntry = (SoftwareSystemFileEntry)nextEntry;
                fileEntry.setNeedsReparseState(true, false);
            }
            return;
        }
        List entries = this.getEntries();
        int index = entries.indexOf(entry);
        if (entry.getNeedsReparseState()) {
            SoftwareSystemFileEntry current = entry;
            int i2 = index - 1;
            while (i2 >= 0 && current.getNeedsReparseState() && current.getNeedsReparseFlagModification() == NeedsReparse.NONE) {
                SoftwareSystemFileEntry previous = (SoftwareSystemFileEntry)entries.get(i2);
                previous.setNeedsReparseState(true, false);
                current = previous;
                --i2;
            }
            current = entry;
            i2 = index + 1;
            while (i2 < this.getSize() && current.getNeedsReparseState() && current.getNeedsReparseFlagModification() == NeedsReparse.NONE) {
                SoftwareSystemFileEntry next = (SoftwareSystemFileEntry)entries.get(i2);
                next.setNeedsReparseState(true, false);
                current = next;
                ++i2;
            }
        } else {
            SoftwareSystemFileEntry current = entry;
            boolean isParserModelValid = true;
            int i3 = index - 1;
            while (i3 >= 0) {
                SoftwareSystemFileEntry previous = (SoftwareSystemFileEntry)entries.get(i3);
                if (isParserModelValid && !current.invalidatesParserModel() && (current.getNeedsReparseFlagModification() == NeedsReparse.NONE || current.getNeedsReparseFlagModification() == NeedsReparse.NOT_REQUIRED)) {
                    previous.setNeedsReparseState(false, false);
                } else {
                    previous.setNeedsReparseState(true, false);
                    isParserModelValid = false;
                }
                current = previous;
                --i3;
            }
            current = entry;
            isParserModelValid = true;
            i3 = index + 1;
            while (i3 < this.getSize()) {
                boolean parserModelValid;
                SoftwareSystemFileEntry next = (SoftwareSystemFileEntry)entries.get(i3);
                boolean bl2 = parserModelValid = !current.getNeedsReparseState();
                if (parserModelValid && next.getNeedsReparseFlagModification() == NeedsReparse.NONE && !next.invalidatesParserModel()) {
                    next.setNeedsReparseState(false, false);
                } else {
                    next.setNeedsReparseState(true, false);
                }
                current = next;
                ++i3;
            }
        }
    }
}

