/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.foundation.propertyreader.AnnotatedPropertyReader;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IExtension;
import com.hello2morrow.sonargraph.core.model.element.IRoot;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class Root
extends NamedElementContainer
implements Element.IPropertiesManager,
IRoot {
    private final AnnotatedPropertyReader m_propertyAccessor = new AnnotatedPropertyReader();
    private final List<Extension> m_extensions = new ArrayList<Extension>();
    private boolean m_initialized;

    protected Root() {
        super(null);
    }

    public final List<Extension> getExtensions() {
        return Collections.unmodifiableList(this.m_extensions);
    }

    @Override
    public final boolean isExcluded() {
        return false;
    }

    @Override
    public final boolean ignoreIssues() {
        return false;
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        return this;
    }

    public final AnnotatedPropertyReader getPropertyAccessor() {
        return this.m_propertyAccessor;
    }

    @Override
    public final <T> T getProperty(Element element, String property, Class<T> cls) {
        assert (property != null) : "Parameter 'property' of method 'getProperty' must not be null";
        return (T)this.m_propertyAccessor.getProperty((Object)element, property, cls);
    }

    @Override
    public final boolean hasProperty(Element element, String property) {
        assert (property != null) : "Parameter 'property' of method 'hasProperty' must not be null";
        return this.m_propertyAccessor.hasProperty((Object)element, property);
    }

    @Override
    public final Map<String, Object> getProperties(Element element) {
        return this.m_propertyAccessor.getProperties((Object)element);
    }

    public <T extends Extension> T addExtension(T extension) {
        assert (extension != null) : "'extension' must not be null";
        assert (!this.m_initialized) : "Extensions must only be added in initialization";
        Class<?> extensionClass = extension.getClass();
        for (IExtension iExtension : this.m_extensions) {
            assert (iExtension != extension) : "Extension already added: " + extension;
            assert (!iExtension.getClass().equals(extensionClass)) : "Extension already added: " + extensionClass.getName();
            assert (!extensionClass.isAssignableFrom(iExtension.getClass())) : "Only leaf classes can be usesd as extensions - is a super class of existing extension: " + extension;
            assert (!iExtension.getClass().isAssignableFrom(extensionClass)) : "Only leaf classes can be usesd as extensions - is a sub class of existing extension: " + extension;
        }
        this.m_extensions.add(extension);
        return extension;
    }

    public void finishInitialization() {
        this.m_initialized = true;
    }

    public final <T extends IExtension> T getExtension(Class<T> extensionClass) {
        assert (extensionClass != null) : "'extensionClass' must not be null";
        for (IExtension iExtension : this.m_extensions) {
            if (!extensionClass.isAssignableFrom(iExtension.getClass())) continue;
            return (T)iExtension;
        }
        assert (false) : "Extension not found: " + extensionClass;
        return null;
    }

    public final <T extends IExtension> List<T> getExtensions(Class<T> extensionClass) {
        assert (extensionClass != null) : "'extensionClass' must not be null";
        ArrayList<IExtension> extensions = new ArrayList<IExtension>();
        for (IExtension iExtension : this.m_extensions) {
            if (!extensionClass.isAssignableFrom(iExtension.getClass())) continue;
            extensions.add(iExtension);
        }
        return extensions;
    }

    public final <T extends IExtension> boolean hasExtension(T extension) {
        assert (extension != null) : "Parameter 'extension' of method 'hasExtension' must not be null";
        return this.m_extensions.contains(extension);
    }
}

