/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class PrepareRefreshResult
extends OperationResult {
    private final Map<Language, Boolean> m_languageToParserRefreshPossible;
    private final ModifiableFileDelta m_delta = new ModifiableFileDelta();
    private final List<Element> m_aboutToBeDeleted = new ArrayList<Element>();
    private final List<String> m_info = new ArrayList<String>();
    private final Set<AnalyzerConfigurationModification> m_analyzerConfigurationModification = new LinkedHashSet<AnalyzerConfigurationModification>();
    private final Set<ISoftwareSystemProvider.IRefreshOption> m_options = new LinkedHashSet<ISoftwareSystemProvider.IRefreshOption>();
    private final Set<IAnalyzerId> m_analyzersNeedingExecution = new THashSet();
    private final List<Question> m_questions = new ArrayList<Question>();
    private SoftwareSystemFileModification m_systemFileModification = SoftwareSystemFileModification.NONE;
    private AdditionalFileModification m_modelModification = AdditionalFileModification.NONE;
    private ModifiableModel m_currentModel;
    private ModifiableModel m_switchToModel;
    private boolean m_ignoreSoftwareSystemFileModification;

    public PrepareRefreshResult(Set<Language> languages, Set<ISoftwareSystemProvider.IRefreshOption> options, boolean possible) {
        super("Prepare refresh");
        assert (languages != null) : "Parameter 'languages' of method 'PrepareRefreshResult' must not be null";
        assert (options != null) : "Parameter 'options' of method 'PrepareRefreshResult' must not be null";
        this.m_languageToParserRefreshPossible = new LinkedHashMap<Language, Boolean>(languages.size());
        for (Language nextLanguage : languages) {
            this.m_languageToParserRefreshPossible.put(nextLanguage, possible);
        }
        this.m_options.addAll(options);
    }

    public PrepareRefreshResult(Set<Language> languages, Set<ISoftwareSystemProvider.IRefreshOption> options) {
        this(languages, options, false);
    }

    public Set<ISoftwareSystemProvider.IRefreshOption> getRefreshOptions() {
        return Collections.unmodifiableSet(this.m_options);
    }

    public void addQuestion(String question, Runnable yesAction) {
        assert (question != null && question.length() > 0) : "Parameter 'question' of method 'addQuestion' must not be empty";
        assert (yesAction != null) : "Parameter 'yesAction' of method 'addQuestion' must not be null";
        this.m_questions.add(new Question(question, yesAction));
    }

    public List<Question> getQuestions() {
        return Collections.unmodifiableList(this.m_questions);
    }

    public boolean isElementDeletionNecessary() {
        return !this.m_aboutToBeDeleted.isEmpty();
    }

    public boolean isSystemFilesRefreshNecessary() {
        return this.m_delta.containsFiles();
    }

    public boolean hasSystemFileDirectoryStructureChanged() {
        return this.m_delta.containsDirectories();
    }

    public ModifiableFileDelta getSystemFilesDelta() {
        return this.m_delta;
    }

    public void addAboutToBeDeleted(Element element) {
        assert (element != null) : "Parameter 'element' of method 'addAboutToBeDeleted' must not be null";
        assert (!this.m_aboutToBeDeleted.contains(element)) : "Already added: " + element;
        this.m_aboutToBeDeleted.add(element);
    }

    public List<Element> getAboutToBeDeletedElements() {
        return Collections.unmodifiableList(this.m_aboutToBeDeleted);
    }

    public void setParserRefreshPossible(Language language, boolean possible) {
        assert (language != null) : "Parameter 'language' of method 'setRefreshPossible' must not be null";
        assert (this.m_languageToParserRefreshPossible.containsKey(language)) : "Language not found: " + language;
        this.m_languageToParserRefreshPossible.put(language, possible);
    }

    public boolean isParserRefreshPossible() {
        for (Boolean next : this.m_languageToParserRefreshPossible.values()) {
            if (!next.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Set<Language> getLanguages() {
        return Collections.unmodifiableSet(this.m_languageToParserRefreshPossible.keySet());
    }

    public Set<Language> getParserRefreshPossibleForLanguages() {
        LinkedHashSet<Language> languages = new LinkedHashSet<Language>(this.m_languageToParserRefreshPossible.size());
        for (Map.Entry<Language, Boolean> nextEntry : this.m_languageToParserRefreshPossible.entrySet()) {
            if (!nextEntry.getValue().booleanValue()) continue;
            languages.add(nextEntry.getKey());
        }
        return languages;
    }

    public boolean isParserRefreshPossible(Language language) {
        assert (language != null) : "Parameter 'language' of method 'isParserRefreshPossible' must not be null";
        Boolean possible = this.m_languageToParserRefreshPossible.get(language);
        return possible != null ? possible : false;
    }

    public void addInfo(String info) {
        assert (info != null && info.length() > 0) : "Parameter 'info' of method 'addInfo' must not be empty";
        assert (!this.m_info.contains(info)) : "Already added: " + info;
        this.m_info.add(info);
    }

    public List<String> getInfo() {
        return Collections.unmodifiableList(this.m_info);
    }

    public boolean confirmationRequired() {
        return this.isElementDeletionNecessary() || this.isSystemFilesRefreshNecessary() || !this.m_info.isEmpty();
    }

    public void setSoftwareSystemFileModification(SoftwareSystemFileModification modification) {
        assert (modification != null) : "Parameter 'modification' of method 'setSoftwareSystemFileModification' must not be null";
        this.m_systemFileModification = modification;
    }

    public SoftwareSystemFileModification getSoftwareSystemFileModification() {
        return this.m_systemFileModification;
    }

    public void setIgnoreSoftwareSystemFileModification() {
        this.m_ignoreSoftwareSystemFileModification = true;
    }

    public boolean ignoreSoftwareSystemFileModification() {
        return this.m_ignoreSoftwareSystemFileModification;
    }

    public void setActiveVirtualModelModification(ModifiableModel currentModel, AdditionalFileModification modification) {
        assert (currentModel != null) : "Parameter 'currentModel' of method 'setActiveVirtualModelModification' must not be null";
        assert (modification != null && modification != AdditionalFileModification.NONE) : "Parameter 'modification' of method 'setActivaeVirtualModelModification' must not be null or MODIFICATION.NONE";
        this.m_modelModification = modification;
        this.m_currentModel = currentModel;
    }

    public AdditionalFileModification getActiveVirtualModelModification() {
        assert (this.m_modelModification == AdditionalFileModification.NONE && this.m_currentModel == null || this.m_modelModification != AdditionalFileModification.NONE && this.m_currentModel != null) : "If model modification has been set, current model must have been set as well.";
        if (this.m_modelModification != AdditionalFileModification.NONE && this.m_currentModel != null && !this.m_delta.keepConflictContent(this.m_currentModel)) {
            return this.m_modelModification;
        }
        return AdditionalFileModification.NONE;
    }

    public void switchToModel(ModifiableModel model) {
        this.m_switchToModel = model;
    }

    public boolean switchModel() {
        return this.m_switchToModel != null;
    }

    public ModifiableModel switchToModel() {
        return this.m_switchToModel;
    }

    public void addAnalyzerNeedingExecution(IAnalyzerId analyzerId) {
        assert (analyzerId != null) : "Parameter 'analyzerId' of method 'addAnalyzerNeedingExecution' must not be null";
        this.m_analyzersNeedingExecution.add(analyzerId);
    }

    public void addAnalyzerConfigurationModification(AnalyzerConfigurationModification modification) {
        assert (modification != null) : "Parameter 'modification' of method 'addAnalyzerConfigurationModification' must not be null";
        boolean success = this.m_analyzerConfigurationModification.add(modification);
        assert (success) : "Duplicate in 'addAnalyzerConfigurationModification': " + modification;
    }

    public Set<IAnalyzerId> getAnalyzerIdsWithModifiedConfiguration() {
        LinkedHashSet<IAnalyzerId> modified = new LinkedHashSet<IAnalyzerId>();
        for (AnalyzerConfigurationModification next : this.m_analyzerConfigurationModification) {
            if (next.getModification() == AdditionalFileModification.NONE || this.m_delta.keepConflictContent(next.getFile())) continue;
            modified.add(next.getAnalyzerId());
        }
        return modified;
    }

    public Set<IAnalyzerId> getAnalyzersNeedingExecution() {
        LinkedHashSet<IAnalyzerId> analyzerIds = new LinkedHashSet<IAnalyzerId>();
        for (AnalyzerConfigurationModification next : this.m_analyzerConfigurationModification) {
            if (next.getModification() == AdditionalFileModification.NONE || this.m_delta.keepConflictContent(next.getFile())) continue;
            analyzerIds.addAll(next.getAffectedAnalyzerIds());
        }
        for (IModifiableFileDeltaKey nextKey : this.m_delta.getAvailableModifiableFileDeltaKeys()) {
            Set<IAnalyzerId> nextAffected = nextKey.getAffectedAnalyzerIdsOnModifiableFileInterchange();
            if (nextAffected.isEmpty()) continue;
            InterchangeableFilesDetector nextDetector = new InterchangeableFilesDetector(nextKey);
            this.m_delta.visit(nextDetector, true);
            if (!nextDetector.interchangeableFilesExist()) continue;
            analyzerIds.addAll(nextAffected);
        }
        analyzerIds.addAll(this.m_analyzersNeedingExecution);
        return analyzerIds;
    }

    public String toString() {
        Set<Language> refreshPossibleFor;
        StringBuilder builder = new StringBuilder();
        if (!this.m_options.isEmpty()) {
            builder.append("Options: ").append(this.m_options);
        }
        if ((refreshPossibleFor = this.getParserRefreshPossibleForLanguages()).isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("Parser model refresh not possible");
        } else {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("Parser model refresh possible for: ").append(refreshPossibleFor);
        }
        if (this.m_systemFileModification != SoftwareSystemFileModification.NONE) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("System file modification: ").append((Object)this.m_systemFileModification);
        }
        if (this.m_modelModification != AdditionalFileModification.NONE) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append("Virtual model modification: ").append((Object)this.m_modelModification);
        }
        if (!this.m_delta.isEmpty()) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(this.m_delta);
        }
        for (AnalyzerConfigurationModification next : this.m_analyzerConfigurationModification) {
            if (next.getModification() == AdditionalFileModification.NONE) continue;
            builder.append("Analyzer configuration modification '").append(next.getAnalyzerId()).append("' [").append(next.getFile().getIdentifyingPath()).append("]: ").append((Object)next.getModification()).append("\n");
            for (IAnalyzerId nextAffected : next.getAffectedAnalyzerIds()) {
                if (builder.length() > 0) {
                    builder.append("\n");
                }
                builder.append(" -> affected analyzer: " + nextAffected);
            }
        }
        return builder.toString();
    }

    public static enum AdditionalFileModification {
        ADDED,
        MODIFIED,
        DELETED,
        NONE;

    }

    public static final class AnalyzerConfigurationModification {
        private final IAnalyzerId m_analyzerId;
        private final IModifiableFile m_file;
        private final AdditionalFileModification m_modification;
        private final Set<IAnalyzerId> m_affectedAnalyzerIds;

        public AnalyzerConfigurationModification(IAnalyzerId analyzerId, IModifiableFile file, AdditionalFileModification modification, Set<IAnalyzerId> affectedAnalyzerIds) {
            assert (analyzerId != null) : "Parameter 'analyzerId' of method 'AnalyzerConfigurationModification' must not be null";
            assert (file != null) : "Parameter 'file' of method 'AnalyzerConfigurationModification' must not be null";
            assert (modification != null) : "Parameter 'modification' of method 'AnalyzerConfigurationModification' must not be null";
            assert (affectedAnalyzerIds != null && !affectedAnalyzerIds.isEmpty()) : "Parameter 'affectedAnalyzerIds' of method 'AnalyzerConfigurationModification' must not be empty";
            assert (affectedAnalyzerIds.contains(analyzerId)) : "Not found in affected: " + analyzerId;
            this.m_analyzerId = analyzerId;
            this.m_file = file;
            this.m_modification = modification;
            this.m_affectedAnalyzerIds = affectedAnalyzerIds;
        }

        IAnalyzerId getAnalyzerId() {
            return this.m_analyzerId;
        }

        IModifiableFile getFile() {
            return this.m_file;
        }

        AdditionalFileModification getModification() {
            return this.m_modification;
        }

        Set<IAnalyzerId> getAffectedAnalyzerIds() {
            return this.m_affectedAnalyzerIds;
        }

        public int hashCode() {
            return this.m_analyzerId.getStandardName().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AnalyzerConfigurationModification other = (AnalyzerConfigurationModification)obj;
            return this.m_analyzerId.equals(other.m_analyzerId);
        }
    }

    private static final class InterchangeableFilesDetector
    implements ModifiableFileDelta.IVisitor {
        private final IModifiableFileDeltaKey m_key;
        private boolean m_interchangeableFilesExist;

        InterchangeableFilesDetector(IModifiableFileDeltaKey key) {
            assert (key != null) : "Parameter 'key' of method 'InterchangeableFilesDetector' must not be null";
            this.m_key = key;
        }

        @Override
        public IModifiableFileDeltaKey getKey() {
            return this.m_key;
        }

        @Override
        public void visitAdded(ModifiableFileCandidate added) {
            this.m_interchangeableFilesExist = true;
        }

        @Override
        public void visitModified(IModifiableFile modified) {
            this.m_interchangeableFilesExist = true;
        }

        @Override
        public void visitDeleted(IModifiableFile deleted) {
            this.m_interchangeableFilesExist = true;
        }

        boolean interchangeableFilesExist() {
            return this.m_interchangeableFilesExist;
        }
    }

    public static final class Question {
        private final String m_question;
        private final Runnable m_yesAction;
        private Boolean m_answer;

        private Question(String question, Runnable yesAction) {
            assert (question != null && question.length() > 0) : "Parameter 'question' of method 'Question' must not be empty";
            assert (yesAction != null) : "Parameter 'yesAction' of method 'Question' must not be null";
            this.m_question = question;
            this.m_yesAction = yesAction;
        }

        public String getQuestion() {
            return this.m_question;
        }

        public void executePendingAction() {
            if (this.m_answer == Boolean.TRUE) {
                this.m_yesAction.run();
            }
        }

        public void recordAnswer(boolean yesOrNo) {
            this.m_answer = yesOrNo;
        }
    }

    public static enum SoftwareSystemFileModification {
        MODIFIED,
        DELETED,
        MODIFIED_CONFLICT,
        DELETED_CONFLICT,
        NONE;

    }
}

