/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;

public final class PhysicalInfo {
    private final RootDirectoryPath m_rootDirectoryPath;
    private final String m_relativePath;
    private final String m_shortName;

    public PhysicalInfo(RootDirectoryPath rootDirectoryPath, String relativePath, String shortName) {
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'PhysicalInfo' must not be null";
        assert (relativePath != null && relativePath.length() > 0) : "Parameter 'relativePath' of method 'PhysicalInfo' must not be empty";
        assert (shortName != null && shortName.length() > 0) : "Parameter 'shortName' of method 'PhysicalInfo' must not be empty";
        this.m_rootDirectoryPath = rootDirectoryPath;
        this.m_relativePath = relativePath;
        this.m_shortName = shortName;
    }

    public RootDirectoryPath getRootDirectoryPath() {
        return this.m_rootDirectoryPath;
    }

    public String getRelativePath() {
        return this.m_relativePath;
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_relativePath.hashCode();
        result = 31 * result + this.m_rootDirectoryPath.hashCode();
        result = 31 * result + this.m_shortName.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PhysicalInfo other = (PhysicalInfo)obj;
        return this.m_rootDirectoryPath.equals(other.m_rootDirectoryPath) && this.m_relativePath.equals(other.m_relativePath) && this.m_shortName.equals(other.m_shortName);
    }

    public String toString() {
        return this.m_rootDirectoryPath + "\n" + this.m_relativePath + "\n" + this.m_shortName;
    }
}

