/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.foundation.activity.IWorkerContext;
import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.ExceptionUtility;
import com.hello2morrow.foundation.utilities.Pair;
import com.hello2morrow.foundation.utilities.StrictPair;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.foundation.utilities.Version;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.GeneratedNamedElementRefactoringIssue;
import com.hello2morrow.sonargraph.core.model.element.IIssue;
import com.hello2morrow.sonargraph.core.model.element.IResolution;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.IssueType;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.IRefactoringProcessor;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringStateHandler;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.refactoring.RenameRefactoringDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.GeneratedIssueBasedTaskDefinition;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ToDoDefinition;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.ApplicationData;
import com.hello2morrow.sonargraph.core.model.system.IPersistableVirtualModel;
import com.hello2morrow.sonargraph.core.model.system.IResolutionMatcher;
import com.hello2morrow.sonargraph.core.model.system.IssueDelta;
import com.hello2morrow.sonargraph.core.model.system.ParserModel;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModifiableModel
extends VirtualModel
implements IPersistableVirtualModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifiableModel.class);
    private final RefactoringStateHandler m_refactoringStateHandler = new RefactoringStateHandler();
    private final IModifiablePathListener m_listener;
    private final IResolutionMatcher m_matcher;
    private final IRefactoringProcessor m_refactoringProcessor;
    private final String m_relPath;
    private long m_timestamp = -1L;
    private Version m_version = Version.create((int)0, (int)0, (int)0, (int)0);
    private String m_basedOnPersistableVirtualModel;
    private boolean m_existsOnDisk;
    private TFile m_file;
    private String m_fileId;
    private String m_description;
    private boolean m_needsSave;
    private boolean m_inRemoveIssuesOfInvalidElements;
    private ApplicationData m_applicationData;

    public ModifiableModel(VirtualModel parent, TFile file, IResolutionMatcher matcher, IModifiablePathListener listener, IRefactoringProcessor refactoringProcessor) {
        super(parent);
        assert (parent != null) : "Parameter 'parent' of method 'ModifiableModel' must not be null";
        assert (file != null) : "Parameter 'file' of method 'ModifiableModel' must not be null";
        assert (file.isAbsolute()) : "Not an absolute file: " + file;
        assert (matcher != null) : "Parameter 'matcher' of method 'ModifiableModel' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'ModifiableModel' must not be null";
        assert (refactoringProcessor != null) : "Parameter 'refactoringProcessor' of method 'ModifiableModel' must not be null";
        this.m_file = file.getNormalizedFile();
        this.m_timestamp = this.m_file.lastModified();
        this.m_existsOnDisk = file.exists();
        this.m_matcher = matcher;
        this.m_listener = listener;
        this.m_refactoringProcessor = refactoringProcessor;
        IBaseDirectory baseDir = this.getParent(IBaseDirectory.class, new Class[0]);
        assert (baseDir != null) : "'baseDir' of method 'reallocate' must not be null";
        this.m_relPath = FileUtility.calculateRelativePath((TFile)this.m_file, (TFile)baseDir.getDirectoryFile());
        if (parent instanceof IPersistableVirtualModel) {
            this.m_basedOnPersistableVirtualModel = ((IPersistableVirtualModel)((Object)parent)).getIdentifyingPath();
        }
        this.createNewFileId();
        this.m_listener.created(this);
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    @Override
    public void setVersion(Version version) {
        assert (version != null) : "Parameter 'version' of method 'setVersion' must not be null";
        this.m_version = version;
    }

    public Version getVersion() {
        return this.m_version;
    }

    @Override
    public String getBasedOnVirtualModel() {
        return this.m_basedOnPersistableVirtualModel != null ? this.m_basedOnPersistableVirtualModel : "Parser";
    }

    @Override
    public String getBasedOnPersistableVirtualModel() {
        return this.m_basedOnPersistableVirtualModel;
    }

    @Override
    public void setBasedOnPersistableVirtualModel(String basedOn) {
        assert (basedOn == null || !basedOn.isEmpty()) : "Parameter 'basedOn' of method 'setBasedOnPersistableVirtualModel' must not be empty if not null";
        this.m_basedOnPersistableVirtualModel = basedOn;
    }

    @Override
    public void setParent(NamedElement parent) {
        super.setParent(parent);
        if (parent instanceof IPersistableVirtualModel) {
            this.m_basedOnPersistableVirtualModel = ((IPersistableVirtualModel)((Object)parent)).getIdentifyingPath();
        }
    }

    @Override
    public boolean changeParent(NamedElement parent, boolean updateChildRelationship) {
        assert (parent != null) : "Parameter 'parent' of method 'changeParent' must not be null";
        boolean parentChanged = super.changeParent(parent, updateChildRelationship);
        if (parentChanged && parent instanceof IPersistableVirtualModel) {
            this.m_basedOnPersistableVirtualModel = ((IPersistableVirtualModel)((Object)parent)).getIdentifyingPath();
        }
        return parentChanged;
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public void remove() {
        this.m_listener.deleted(this);
        super.remove();
    }

    @Override
    public void parentRemoved() {
        this.m_listener.deleted(this);
        super.parentRemoved();
    }

    @Override
    public String getFileId() {
        return this.m_fileId;
    }

    @Override
    public boolean existsOnDisk() {
        return this.m_existsOnDisk;
    }

    public void setExistsOnDisk(boolean exists) {
        if (exists != this.m_existsOnDisk) {
            this.m_existsOnDisk = exists;
            this.m_listener.additionalInformationModified(this);
        }
    }

    @Override
    public long getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public void resetTimestamp() {
        this.m_timestamp = this.getFile().lastModified();
    }

    @Override
    public String getName() {
        return this.m_relPath;
    }

    @Override
    public String getShortName() {
        return this.getFile().getName();
    }

    @Override
    @Property
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public TFile getFile() {
        return this.m_file;
    }

    @Override
    @Property
    public String getIdentifyingPath() {
        return this.m_relPath;
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.MODEL;
    }

    @Override
    @Property
    public String getAbsolutePath() {
        return this.getFile().getNormalizedAbsolutePath();
    }

    @Override
    public void reallocate() {
        IBaseDirectory baseDir = this.getParent(IBaseDirectory.class, new Class[0]);
        assert (baseDir != null) : "'baseDir' of method 'reallocate' must not be null";
        assert (FileUtility.isRelativePath((String)this.m_relPath));
        this.m_file = new TFile((File)baseDir.getDirectoryFile(), this.m_relPath).getNormalizedAbsoluteFile();
    }

    @Override
    public void createNewFileId() {
        this.m_fileId = StringUtility.createTimebasedId((String)this.m_relPath);
    }

    @Override
    public boolean needsSave() {
        return this.m_needsSave;
    }

    public void reloaded(long timestamp) {
        this.m_timestamp = timestamp;
        this.m_needsSave = false;
        this.m_listener.reloaded(this);
    }

    @Override
    public void setNeedsSave(boolean needsSave) {
        this.m_needsSave = needsSave;
        if (this.m_needsSave) {
            this.m_listener.modified(this);
        } else {
            this.m_listener.saved(this);
        }
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NamedElement> getChildrenList() {
        ArrayList<NamedElement> result = new ArrayList<NamedElement>();
        ModifiableModel modifiableModel = this;
        synchronized (modifiableModel) {
            result.addAll(super.getChildrenList());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChild(NamedElement child) {
        ModifiableModel modifiableModel = this;
        synchronized (modifiableModel) {
            super.addChild(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeChild(NamedElement child) {
        ModifiableModel modifiableModel = this;
        synchronized (modifiableModel) {
            super.removeChild(child);
        }
    }

    public IResolutionMatcher getResolutionMatcher() {
        return this.m_matcher;
    }

    private VirtualModel getParentProductionModel() {
        NamedElement parent = this.getParent();
        assert (parent != null && parent instanceof VirtualModel) : "Unexpected class in method 'getParentProductionModel': " + parent;
        return (VirtualModel)parent;
    }

    private void removeIssues(List<IIssue> issueAccessors) {
        assert (issueAccessors != null) : "Parameter 'issueAccessors' of method 'removeIssues' must not be null";
        for (IIssue next : issueAccessors) {
            Issue nextIssue = (Issue)next;
            boolean issueFound = this.getParentProductionModel().removeElementIssue((ElementWithIssues)nextIssue.getAffectedElement(), nextIssue, false);
            if (!issueFound) {
                issueFound = super.removeElementIssue((ElementWithIssues)nextIssue.getAffectedElement(), nextIssue, false);
            }
            if (issueFound) continue;
            LOGGER.warn("Issue to be removed not found: " + nextIssue.getId() + " - requested from: " + ExceptionUtility.collectAll((Throwable)new Throwable()));
        }
    }

    private <T extends Resolution> List<T> getAllResolutions(Class<T> resolutionClass, NamedElement.IFilter filter) {
        assert (resolutionClass != null) : "Parameter 'resolutionClass' of method 'getAllResolutions' must not be null";
        ArrayList<T> resolutions = new ArrayList<T>();
        List<ModifiableModel> parentModels = this.getParents(ModifiableModel.class, new Class[0]);
        Collections.reverse(parentModels);
        for (VirtualModel virtualModel : parentModels) {
            resolutions.addAll(filter != null ? virtualModel.getChildren(filter, resolutionClass) : virtualModel.getChildren(resolutionClass));
        }
        resolutions.addAll(filter != null ? this.getChildren(filter, resolutionClass) : this.getChildren(resolutionClass));
        return resolutions;
    }

    @Override
    public <T extends Resolution> List<T> getResolutions(Class<T> resolutionClass) {
        assert (resolutionClass != null) : "Parameter 'resolutionClass' of method 'getResolutions' must not be null";
        return this.getAllResolutions(resolutionClass, null);
    }

    public void resetResolutions() {
        List<Resolution> resolutions = this.getAllResolutions(Resolution.class, null);
        if (!resolutions.isEmpty()) {
            ArrayList<Issue> issuesRemoved = new ArrayList<Issue>();
            boolean refactoringModified = false;
            for (Resolution nextResolution : resolutions) {
                List<IIssue> issueAccessors = nextResolution.reset();
                if (issueAccessors.isEmpty()) continue;
                if (nextResolution instanceof GeneratedIssueBasedTaskDefinition) {
                    if (nextResolution instanceof RefactoringDefinition) {
                        refactoringModified = true;
                    }
                    this.removeIssues(issueAccessors);
                }
                for (IIssue nextIssueAccessor : issueAccessors) {
                    issuesRemoved.add((Issue)nextIssueAccessor);
                }
            }
            if (!issuesRemoved.isEmpty()) {
                this.issuesRemoved(issuesRemoved);
            }
            if (refactoringModified) {
                this.refactoringsModified();
            }
            this.m_refactoringStateHandler.reset();
        }
    }

    private ElementWithIssues setResolution(Resolution resolution, Issue issue) {
        assert (resolution != null) : "Parameter 'resolution' of method 'setResolution' must not be null";
        assert (issue != null) : "Parameter 'issue' of method 'setResolution' must not be null";
        assert (issue.getResolution() != resolution) : "Already resolved by resolution: " + issue + " - " + resolution;
        Element nextAffectedElement = issue.getAffectedElement();
        assert (nextAffectedElement != null && nextAffectedElement instanceof ElementWithIssues) : "Unexpected class in method 'setResolution': " + nextAffectedElement;
        issue.setResolution(resolution);
        return (ElementWithIssues)nextAffectedElement;
    }

    public void connectToDoDefinition(ToDoDefinition toDoDefinition, List<Issue> issues) {
        assert (toDoDefinition != null) : "Parameter 'toDoDefinition' of method 'connectToDoDefinition' must not be null";
        assert (issues != null && !issues.isEmpty()) : "Parameter 'issues' of method 'connectToDoDefinition' must not be empty";
        issues.forEach(i2 -> {
            ElementWithIssues elementWithIssues = this.setResolution(toDoDefinition, (Issue)i2);
        });
    }

    private void connectAndApplyRefactoringDefinition(RefactoringDefinition refactoringDefinition, List<Issue> issues, List<String> nonMatchingNamedElementFqNames, List<Pair<String, String>> nonMatchingDependencyFqNames) {
        assert (refactoringDefinition != null) : "Parameter 'refactoringDefinition' of method 'connectAndApplyRefactoringDefinition' must not be null";
        assert (issues != null) : "Parameter 'issues' of method 'connectAndApplyRefactoringDefinition' must not be null";
        assert (nonMatchingNamedElementFqNames != null) : "Parameter 'nonMatchingNamedElementFqNames' of method 'connectAndApplyRefactoringDefinition' must not be null";
        assert (nonMatchingDependencyFqNames != null) : "Parameter 'nonMatchingDependencyFqNames' of method 'connectAndApplyRefactoringDefinition' must not be null";
        ArrayList<NamedElement> matchedNamedElements = new ArrayList<NamedElement>();
        ArrayList<Dependency> matchedDependencies = new ArrayList<Dependency>();
        Set<NamedElement> additionalToReceiveIssue = null;
        GeneratedNamedElementRefactoringIssue issueToBeCopied = null;
        for (Issue nextIssue : issues) {
            ElementWithIssues nextAffectedElement = this.setResolution(refactoringDefinition, nextIssue);
            if (nextAffectedElement instanceof NamedElement) {
                matchedNamedElements.add((NamedElement)nextAffectedElement);
                if (issueToBeCopied != null) continue;
                assert (nextIssue instanceof GeneratedNamedElementRefactoringIssue) : "Unexpected class in method 'connectAndApplyRefactoringDefinition': " + nextIssue;
                issueToBeCopied = (GeneratedNamedElementRefactoringIssue)nextIssue;
                continue;
            }
            assert (nextAffectedElement instanceof Dependency) : "Unexpected class in method 'connectAndApplyRefactoringDefinition': " + nextAffectedElement;
            matchedDependencies.add((Dependency)nextAffectedElement);
        }
        RefactoringType refactoringType = refactoringDefinition.getRefactoringType();
        switch (refactoringType) {
            case NONE: {
                assert (false) : "Unexpected refactoring type: " + (Object)((Object)refactoringType);
                break;
            }
            case DELETE: {
                additionalToReceiveIssue = this.m_refactoringProcessor.delete((DeleteRefactoringDefinition)refactoringDefinition, matchedNamedElements, matchedDependencies, nonMatchingNamedElementFqNames, nonMatchingDependencyFqNames, this.m_refactoringStateHandler);
                break;
            }
            case MOVE: {
                assert (matchedDependencies.isEmpty()) : "No refactored dependencies expected";
                MoveRefactoringDefinition moveRefactoringDefinition = (MoveRefactoringDefinition)refactoringDefinition;
                additionalToReceiveIssue = this.m_refactoringProcessor.move(moveRefactoringDefinition, matchedNamedElements, nonMatchingNamedElementFqNames, this.m_refactoringStateHandler);
                break;
            }
            case MOVE_RENAME: {
                assert (matchedDependencies.isEmpty()) : "No refactored dependencies expected";
                MoveRenameRefactoringDefinition moveRenameRefactoringDefinition = (MoveRenameRefactoringDefinition)refactoringDefinition;
                additionalToReceiveIssue = this.m_refactoringProcessor.moveRename(moveRenameRefactoringDefinition, matchedNamedElements, nonMatchingNamedElementFqNames, this.m_refactoringStateHandler);
                break;
            }
            case RENAME: {
                assert (matchedDependencies.isEmpty()) : "No refactored dependencies expected";
                additionalToReceiveIssue = this.m_refactoringProcessor.rename((RenameRefactoringDefinition)refactoringDefinition, matchedNamedElements, nonMatchingNamedElementFqNames, this.m_refactoringStateHandler);
                break;
            }
            default: {
                assert (false) : "Unhandled refactoring type: " + (Object)((Object)refactoringType);
                break;
            }
        }
        if (additionalToReceiveIssue != null && !additionalToReceiveIssue.isEmpty() && issueToBeCopied != null) {
            for (NamedElement next : additionalToReceiveIssue) {
                GeneratedNamedElementRefactoringIssue nextIssue = issueToBeCopied.copy(GeneratedIssueBasedTaskDefinition.createKey(issueToBeCopied.getId().getStandardName(), refactoringDefinition.getAssignee(), refactoringDefinition.getPriority().getStandardName()), next);
                nextIssue.setResolution(refactoringDefinition);
                next.addIssue(nextIssue);
            }
        }
    }

    public void connectRefactoringDefinition(RefactoringDefinition refactoringDefinition, List<Issue> issues) {
        assert (refactoringDefinition != null) : "Parameter 'refactoringDefinition' of method 'connectRefactoringDefinition' must not be null";
        assert (issues != null && !issues.isEmpty()) : "Parameter 'issues' of method 'connectRefactoringDefinition' must not be empty";
        this.connectAndApplyRefactoringDefinition(refactoringDefinition, issues, Collections.emptyList(), Collections.emptyList());
        this.issuesAdded(issues);
        this.refactoringsModified();
    }

    public static String getIssueKey(Resolution resolution) {
        assert (resolution != null) : "Parameter 'resolution' of method 'getIssueKey' must not be null";
        IssueType issueType = resolution.getUniqueChild(IssueType.class);
        assert (issueType != null) : "'issueType' of method 'getIssueKey' must not be null";
        String key = issueType.getKey();
        assert (key != null && key.length() > 0) : "'key' of method 'getIssueKey' must not be empty";
        return key;
    }

    private void resetTodoDefinition(ToDoDefinition todoDefinition) {
        assert (todoDefinition != null) : "Parameter 'todoDefinition' of method 'resetTodoDefinition' must not be null";
        assert (this.m_applicationData != null) : "'m_applicationData' of method 'resetTodoDefinition' must not be null";
        List<IIssue> issueAccessors = todoDefinition.reset();
        if (!issueAccessors.isEmpty()) {
            ArrayList<Element> elements = new ArrayList<Element>(issueAccessors.size());
            ArrayList<Issue> issues = new ArrayList<Issue>(issueAccessors.size());
            for (IIssue nextIssueAccessor : issueAccessors) {
                elements.add(nextIssueAccessor.getAffectedElement());
                issues.add((Issue)nextIssueAccessor);
            }
            this.m_applicationData.addIssuesBefore(issues);
            this.removeIssues(issueAccessors);
        }
    }

    private boolean resetRefactoringDefinition(RefactoringDefinition refactoringDefinition) {
        assert (refactoringDefinition != null) : "Parameter 'refactoringDefinition' of method 'resetRefactoringDefinition' must not be null";
        assert (this.m_applicationData != null) : "'m_applicationData' of method 'resetRefactoringDefinition' must not be null";
        List<IIssue> issueAccessors = refactoringDefinition.reset();
        if (!issueAccessors.isEmpty()) {
            ArrayList<Element> elements = new ArrayList<Element>(issueAccessors.size());
            ArrayList<Issue> issues = new ArrayList<Issue>(issueAccessors.size());
            for (IIssue nextIssueAccessor : issueAccessors) {
                elements.add(nextIssueAccessor.getAffectedElement());
                issues.add((Issue)nextIssueAccessor);
            }
            this.m_applicationData.addIssuesBefore(issues);
            this.m_applicationData.addRefactoringBefore(refactoringDefinition, elements);
            this.removeIssues(issueAccessors);
            refactoringDefinition.getStatusInfo().reset();
            return true;
        }
        refactoringDefinition.getStatusInfo().reset();
        return false;
    }

    private void matchTodoDefinition(ToDoDefinition todoDefinition) {
        assert (todoDefinition != null) : "Parameter 'todoDefinition' of method 'matchTodoDefinition' must not be null";
        assert (this.m_applicationData != null) : "'m_applicationData' of method 'matchTodoDefinition' must not be null";
        String resolutionKey = ModifiableModel.getIssueKey(todoDefinition);
        ArrayList<Element> matchedElements = new ArrayList<Element>();
        ArrayList<Issue> issuesToConnect = new ArrayList<Issue>();
        this.m_matcher.matchNamedElementPatterns(todoDefinition, resolutionKey, matchedElements, issuesToConnect);
        this.m_matcher.matchDependencyPatterns(todoDefinition, resolutionKey, matchedElements, issuesToConnect);
        if (!issuesToConnect.isEmpty()) {
            this.connectToDoDefinition(todoDefinition, issuesToConnect);
        }
        this.m_applicationData.addIssuesAfter(issuesToConnect);
    }

    private void matchRefactoringDefinition(RefactoringDefinition refactoringDefinition) {
        assert (refactoringDefinition != null) : "Parameter 'matchRefactoringDefinition' of method 'dep' must not be null";
        assert (this.m_applicationData != null) : "'m_applicationData' of method 'matchRefactoringDefinition' must not be null";
        String resolutionKey = ModifiableModel.getIssueKey(refactoringDefinition);
        ArrayList<Element> matchedElements = new ArrayList<Element>();
        ArrayList<Issue> issuesToConnect = new ArrayList<Issue>();
        ArrayList<String> nonMatchingNamedElementFqNames = new ArrayList<String>();
        ArrayList<Pair<String, String>> nonMatchingDependencyFqNames = new ArrayList<Pair<String, String>>();
        this.m_matcher.matchNamedElementPatterns(refactoringDefinition, resolutionKey, matchedElements, issuesToConnect, nonMatchingNamedElementFqNames);
        this.m_matcher.matchDependencyPatterns(refactoringDefinition, resolutionKey, matchedElements, issuesToConnect, nonMatchingDependencyFqNames);
        this.connectAndApplyRefactoringDefinition(refactoringDefinition, issuesToConnect, nonMatchingNamedElementFqNames, nonMatchingDependencyFqNames);
        this.m_applicationData.addIssuesAfter(issuesToConnect);
        this.m_applicationData.addRefactoringAfter(refactoringDefinition, matchedElements);
    }

    public void applyRefactoringResolutions(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'applyRefactoringResolutions' must not be null";
        assert (this.m_applicationData != null) : "'m_applicationData' of method 'applyRefactoringResolutions' must not be null";
        assert (this.m_applicationData.hasBeenStarted()) : "Has not been started";
        List<RefactoringDefinition> refactorings = this.getAllResolutions(RefactoringDefinition.class, null);
        if (!refactorings.isEmpty()) {
            workerContext.working("Apply refactoring resolutions", true);
            for (RefactoringDefinition nextRefactoringDefinition : refactorings) {
                this.resetRefactoringDefinition(nextRefactoringDefinition);
                this.matchRefactoringDefinition(nextRefactoringDefinition);
            }
        }
        this.m_applicationData.consume(this);
    }

    public void applyNonRefactoringResolutions(IWorkerContext workerContext, boolean generatedIssueBasedTaskDefinitionsOnly) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'applyNonRefactoringResolutions' must not be null";
        assert (this.m_applicationData != null) : "'m_applicationData' of method 'applyNonRefactoringResolutions' must not be null";
        assert (this.m_applicationData.hasBeenStarted()) : "Has not been started";
        if (generatedIssueBasedTaskDefinitionsOnly) {
            List<ToDoDefinition> resolutions = this.getAllResolutions(ToDoDefinition.class, null);
            if (!resolutions.isEmpty()) {
                workerContext.working("Apply non-refactoring resolutions", true);
                resolutions.forEach(r2 -> this.matchTodoDefinition((ToDoDefinition)r2));
            }
        } else {
            List<Resolution> resolutions = this.getAllResolutions(Resolution.class, new NamedElement.IFilter(){

                @Override
                public boolean accept(NamedElement namedElement) {
                    return !(namedElement instanceof RefactoringDefinition);
                }
            });
            if (!resolutions.isEmpty()) {
                workerContext.working("Apply non-refactoring resolutions", true);
                ArrayList<Resolution> nonDynamicResolutions = new ArrayList<Resolution>(resolutions.size());
                for (Resolution nextResolution : resolutions) {
                    if (nextResolution instanceof ToDoDefinition) {
                        ToDoDefinition nextTodoDefinition = (ToDoDefinition)nextResolution;
                        this.resetTodoDefinition(nextTodoDefinition);
                        this.matchTodoDefinition(nextTodoDefinition);
                        continue;
                    }
                    nextResolution.reset();
                    nonDynamicResolutions.add(nextResolution);
                }
                if (!nonDynamicResolutions.isEmpty()) {
                    THashMap issuesToMatch = new THashMap();
                    for (Issue nextIssue : this.getAllIssues(false, false, false)) {
                        if (nextIssue.getId().getCategory().isGenerated()) continue;
                        Map elementToIssues = issuesToMatch.computeIfAbsent(nextIssue.getKey(), key -> new THashMap());
                        ElementWithIssues affectedElement = (ElementWithIssues)nextIssue.getAffectedElement();
                        List issues = elementToIssues.computeIfAbsent(affectedElement, e2 -> new ArrayList());
                        issues.add(nextIssue);
                    }
                    THashSet matchedIssues = new THashSet();
                    for (Map.Entry nextEntry : issuesToMatch.entrySet()) {
                        this.m_matcher.matchNonGeneratedResolutions(nonDynamicResolutions, (String)nextEntry.getKey(), (Map)nextEntry.getValue(), (Set<Issue>)matchedIssues);
                    }
                }
            }
        }
        this.m_applicationData.consume(this);
    }

    public void setNeedsApplication(List<Resolution> toBeDeleted) {
        assert (toBeDeleted != null) : "Parameter 'toBeDeleted' of method 'setNeedsApplication' must not be null";
        assert (this.m_applicationData == null) : "Parameter 'm_applicationData' of method 'setNeedsApplication' must  be null";
        this.m_applicationData = new ApplicationData(toBeDeleted);
    }

    public void setNeedsApplication() {
        assert (this.m_applicationData == null) : "Parameter 'm_applicationData' of method 'setNeedsApplication' must  be null";
        this.m_applicationData = new ApplicationData();
    }

    public boolean needsApplication() {
        return this.m_applicationData != null;
    }

    public void startApplication(boolean resetRefactorings) {
        assert (this.needsApplication()) : "Does not need to be applied in 'startApplication': " + this;
        this.m_applicationData.start();
        boolean appliedRefactoringResolutionDeleted = false;
        for (Resolution nextResolutionToBeDeleted : this.m_applicationData.getToBeDeleted()) {
            if (nextResolutionToBeDeleted instanceof RefactoringDefinition) {
                if (this.resetRefactoringDefinition((RefactoringDefinition)nextResolutionToBeDeleted)) {
                    appliedRefactoringResolutionDeleted = true;
                }
            } else if (nextResolutionToBeDeleted instanceof ToDoDefinition) {
                this.resetTodoDefinition((ToDoDefinition)nextResolutionToBeDeleted);
            } else {
                nextResolutionToBeDeleted.reset();
            }
            nextResolutionToBeDeleted.remove();
        }
        for (ToDoDefinition nextTodoDefinition : this.getAllResolutions(ToDoDefinition.class, null)) {
            this.resetTodoDefinition(nextTodoDefinition);
        }
        if (resetRefactorings || appliedRefactoringResolutionDeleted) {
            for (RefactoringDefinition nextRefactoringDefinition : this.getAllResolutions(RefactoringDefinition.class, null)) {
                this.resetRefactoringDefinition(nextRefactoringDefinition);
            }
            this.m_refactoringStateHandler.reset();
        }
    }

    public void finishApplication(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'finishApplication' must not be null";
        assert (this.needsApplication()) : "Does not need to be applied in 'finishApplication': " + this;
        assert (this.m_applicationData.hasBeenStarted()) : "Has not been started";
        assert (!this.m_applicationData.hasBeforeAfterInfo()) : "There is still application data to be consumed in '': " + this;
        workerContext.working("Finish model application", true);
        this.m_applicationData = null;
        this.getAllResolutions(Resolution.class, null).forEach(r2 -> r2.finishModification());
    }

    @Override
    protected void issueRemoved(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'issueRemoved' must not be null";
        if (!issue.getId().getCategory().isGenerated() || this.m_inRemoveIssuesOfInvalidElements) {
            IResolution resolution = issue.getResolution();
            if (resolution != null) {
                assert (resolution instanceof Resolution) : "Unexpected class in method 'issueRemoved': " + resolution;
                ((Resolution)resolution).reset(issue);
            }
            this.issuesRemoved(Collections.singletonList(issue));
        }
    }

    @Override
    protected void issuesAdded(Map<ElementWithIssues, List<Issue>> issuesMap) {
        assert (issuesMap != null && !issuesMap.isEmpty()) : "Parameter 'issuesMap' of method 'issuesAdded' must not be empty";
        LinkedHashMap<StrictPair, Map> idToIssuesMap = new LinkedHashMap<StrictPair, Map>();
        for (Map.Entry<ElementWithIssues, List<Issue>> entry2 : issuesMap.entrySet()) {
            ElementWithIssues element = entry2.getKey();
            List<Issue> issues = entry2.getValue();
            for (Issue nextIssue : issues) {
                Map issuesOfIdMap = idToIssuesMap.computeIfAbsent(new StrictPair((Object)nextIssue.getKey(), (Object)nextIssue.getId()), id -> new LinkedHashMap());
                List issuesOfId = issuesOfIdMap.computeIfAbsent(element, e2 -> new ArrayList(1));
                issuesOfId.add(nextIssue);
            }
        }
        for (Map.Entry<ElementWithIssues, List<Issue>> entry3 : idToIssuesMap.entrySet()) {
            final String key = (String)((StrictPair)entry3.getKey()).getFirst();
            IIssueId issueId = (IIssueId)((StrictPair)entry3.getKey()).getSecond();
            if (issueId.getCategory().isGenerated()) continue;
            List<Resolution> resolutions = this.getAllResolutions(Resolution.class, new NamedElement.IFilter(){

                @Override
                public boolean accept(NamedElement namedElement) {
                    return !(namedElement instanceof GeneratedIssueBasedTaskDefinition) && ((Resolution)namedElement).getIssueType().matches(key);
                }
            });
            Map elementToIssues = (Map)((Object)entry3.getValue());
            if (!resolutions.isEmpty()) {
                this.m_matcher.matchNonGeneratedResolutions(resolutions, key, elementToIssues, (Set<Issue>)new THashSet());
            }
            ArrayList<Issue> issuesAdded = new ArrayList<Issue>();
            elementToIssues.entrySet().stream().forEach(entry -> {
                boolean bl2 = issuesAdded.addAll((Collection)entry.getValue());
            });
            this.issuesAdded(issuesAdded);
        }
    }

    @Override
    protected void issueAdded(Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'issueAdded' must not be null";
        if (!issue.getId().getCategory().isGenerated()) {
            List<Resolution> resolutions = this.getAllResolutions(Resolution.class, new NamedElement.IFilter(){

                @Override
                public boolean accept(NamedElement namedElement) {
                    return !(namedElement instanceof GeneratedIssueBasedTaskDefinition);
                }
            });
            if (!resolutions.isEmpty()) {
                this.m_matcher.matchNonGeneratedResolutions(resolutions, issue, (Set<Issue>)new THashSet());
            }
            this.issuesAdded(Collections.singletonList(issue));
        }
    }

    @Override
    public synchronized void addElementIssue(ElementWithIssues element, Issue issue) {
        assert (issue != null) : "Parameter 'issue' of method 'addElementIssue' must not be null";
        if (issue.getId().isParserModelIssue()) {
            this.getParentProductionModel().addElementIssue(element, issue);
        } else {
            super.addElementIssue(element, issue);
        }
    }

    @Override
    synchronized void removeIssuesOfInvalidElements() {
        this.m_inRemoveIssuesOfInvalidElements = true;
        super.removeIssuesOfInvalidElements();
        this.m_inRemoveIssuesOfInvalidElements = false;
    }

    @Override
    public synchronized boolean hasElementIssues(ElementWithIssues element, Severity severity) {
        return super.hasElementIssues(element, severity) || this.getParentProductionModel().hasElementIssues(element, severity);
    }

    @Override
    public synchronized boolean hasUnresolvedIssues(IssueCategory category) {
        return super.hasUnresolvedIssues(category) || this.getParentProductionModel().hasUnresolvedIssues(category);
    }

    @Override
    public synchronized boolean hasElementIssues(ElementWithIssues element, IssueCategory category) {
        return super.hasElementIssues(element, category) || this.getParentProductionModel().hasElementIssues(element, category);
    }

    @Override
    public synchronized boolean hasElementIssues(ElementWithIssues element, IIssueId ... issueIds) {
        return super.hasElementIssues(element, issueIds) || this.getParentProductionModel().hasElementIssues(element, issueIds);
    }

    @Override
    public synchronized Collection<Issue> getAllIssues(boolean includingForDeletedElements, boolean includingExcluded, boolean includePreviewOnly) {
        ArrayList<Issue> issues = new ArrayList<Issue>(this.getParentProductionModel().getAllIssues(includingForDeletedElements, includingExcluded, includePreviewOnly));
        issues.addAll(super.getAllIssues(includingForDeletedElements, includingExcluded, includePreviewOnly));
        return issues;
    }

    @Override
    public synchronized boolean nonExcludedNonPreviewIssuesWithoutResolutionsExist() {
        return super.nonExcludedNonPreviewIssuesWithoutResolutionsExist() || this.getParentProductionModel().nonExcludedNonPreviewIssuesWithoutResolutionsExist();
    }

    @Override
    protected synchronized List<Issue> getAllElementIssues(ElementWithIssues element) {
        assert (element != null) : "Parameter 'element' of method 'getElementIssues' must not be null";
        ArrayList<Issue> issues = new ArrayList<Issue>(this.getParentProductionModel().getAllElementIssues(element));
        issues.addAll(super.getAllElementIssues(element));
        return issues;
    }

    @Override
    public synchronized void removeElementIssues(ElementWithIssues element) {
        assert (element != null) : "Parameter 'element' of method 'removeIssues' must not be null";
        this.getParentProductionModel().removeElementIssues(element);
        super.removeElementIssues(element);
    }

    @Override
    public synchronized void removeElementIssues(IIssueId ... ids) {
        this.getParentProductionModel().removeElementIssues(ids);
        super.removeElementIssues(ids);
    }

    @Override
    public synchronized void removeElementIssues(ElementWithIssues element, IIssueId ... ids) {
        assert (element != null) : "Parameter 'element' of method 'removeElementIssues' must not be null";
        this.getParentProductionModel().removeElementIssues(element, ids);
        super.removeElementIssues(element, ids);
    }

    protected List<VirtualModel> visitIssuesOfProductionVirtualModels() {
        ParserModel parserModel = this.getParent(ParserModel.class, new Class[0]);
        assert (parserModel != null) : "'parserModel' of method 'visitIssuesOfProductionVirtualModels' must not be null";
        return Arrays.asList(parserModel, this);
    }

    @Override
    public <T extends ElementWithIssues> T mapElement(T element) {
        return this.m_refactoringStateHandler.mapElement(element);
    }

    @Override
    public RefactoringState getRefactoringState(Element element) {
        return this.m_refactoringStateHandler.getRefactoringState(element);
    }

    @Override
    public <T extends ElementWithIssues> T getOriginal(T element) {
        return this.m_refactoringStateHandler.getOriginal(element);
    }

    @Override
    public void elementRemoved(Element element) {
        assert (element != null) : "Parameter 'element' of method 'elementRemoved' must not be null";
        this.m_refactoringStateHandler.elementRemoved(element);
    }

    @Override
    public void issuesAdded(List<Issue> issues) {
        this.getParentProductionModel().issuesAdded(issues);
    }

    @Override
    public void issuesRemoved(List<Issue> issues) {
        this.getParentProductionModel().issuesRemoved(issues);
    }

    @Override
    public IssueDelta consumeIssueDelta() {
        return this.getParentProductionModel().consumeIssueDelta();
    }

    @Override
    public boolean haveIssuesBeenModified() {
        return this.getParentProductionModel().haveIssuesBeenModified();
    }

    @Override
    public void refactoringsModified() {
        this.getParentProductionModel().refactoringsModified();
    }

    @Override
    public boolean haveRefactoringsBeenModified() {
        return this.getParentProductionModel().haveRefactoringsBeenModified();
    }

    @Override
    public boolean consumeRefactoringsModified() {
        return this.getParentProductionModel().consumeRefactoringsModified();
    }
}

