/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.ProductionCodeFilter;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPattern;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternExclude;
import com.hello2morrow.sonargraph.core.model.filter.WildcardPatternInclude;
import java.util.ArrayList;
import java.util.List;

public final class FilterModification {
    private final boolean m_isNewProfile;
    private final ProductionCodeFilter m_filter;
    private boolean m_overrideWorkspaceFilter;
    private final ProductionCodeFilter m_existingFilter;
    private final boolean m_existingReplacesWorkspaceFilters;

    public FilterModification(ProductionCodeFilter filter, boolean isNewProfile, boolean overrideWorkspaceFilter) {
        assert (filter != null) : "Parameter 'filter' of method 'FilterModification' must not be null";
        this.m_existingFilter = filter;
        this.m_isNewProfile = isNewProfile;
        this.m_existingReplacesWorkspaceFilters = overrideWorkspaceFilter;
        this.m_overrideWorkspaceFilter = overrideWorkspaceFilter;
        this.m_filter = new ProductionCodeFilter(null);
        if (this.m_isNewProfile || !overrideWorkspaceFilter) {
            return;
        }
        this.m_existingFilter.getChildren(WildcardPattern.class).stream().forEach(p2 -> this.addPattern((WildcardPattern)p2));
    }

    public boolean isNewProfile() {
        return this.m_isNewProfile;
    }

    public void setPatterns(List<WildcardPattern> patterns) {
        assert (patterns != null) : "Parameter 'patterns' of method 'setPatterns' must not be null";
        this.m_filter.removeChildren(WildcardPattern.class);
        patterns.stream().forEach(p2 -> {
            p2.setParent(this.m_filter);
            this.m_filter.addChild((NamedElement)p2);
        });
    }

    public boolean isModified() {
        if (this.m_existingReplacesWorkspaceFilters != this.m_overrideWorkspaceFilter) {
            return true;
        }
        List<WildcardPattern> originalPatterns = this.m_existingFilter.getChildren(WildcardPattern.class);
        List<WildcardPattern> modifiedPatterns = this.m_filter.getChildren(WildcardPattern.class);
        if (originalPatterns.size() != modifiedPatterns.size()) {
            return true;
        }
        int i2 = 0;
        while (i2 < originalPatterns.size()) {
            WildcardPattern originalPattern = originalPatterns.get(i2);
            WildcardPattern modifiedPattern = modifiedPatterns.get(i2);
            if (!originalPattern.getName().equals(modifiedPattern.getName())) {
                return true;
            }
            if (!originalPattern.getClass().equals(modifiedPattern.getClass())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.m_filter.getNumberOfChildren() == 0;
    }

    public List<WildcardPattern> getOriginalPatterns() {
        return this.m_existingFilter.getChildren(WildcardPattern.class);
    }

    public List<WildcardPattern> getPatterns() {
        return this.m_filter.getChildren(WildcardPattern.class);
    }

    public List<WildcardPattern> addPatterns(List<WildcardPattern> selected) {
        assert (selected != null) : "Parameter 'selected' of method 'addFilterPatterns' must not be null";
        ArrayList<WildcardPattern> omittedPatterns = new ArrayList<WildcardPattern>();
        List<WildcardPattern> patterns = this.m_filter.getChildren(WildcardPattern.class);
        for (WildcardPattern next : selected) {
            if (patterns.stream().anyMatch(i2 -> i2.getName().equals(next.getName()))) {
                omittedPatterns.add(next);
                continue;
            }
            this.addPattern(next);
        }
        return omittedPatterns;
    }

    public void addPattern(WildcardPattern pattern) {
        assert (pattern != null) : "Parameter 'pattern' of method 'addPattern' must not be null";
        if (pattern instanceof WildcardPatternInclude) {
            this.m_filter.addChild(new WildcardPatternInclude(this.m_filter, pattern.getName()));
        } else if (pattern instanceof WildcardPatternExclude) {
            this.m_filter.addChild(new WildcardPatternExclude(this.m_filter, pattern.getName()));
        } else assert (false) : "Unsupported class " + pattern.getClass().getName();
    }

    public boolean overrideWorkspaceFilter() {
        return this.m_overrideWorkspaceFilter;
    }

    public void setOverrideWorkspaceFilter(boolean replaces) {
        this.m_overrideWorkspaceFilter = replaces;
    }

    public ProductionCodeFilter getFilter() {
        return this.m_filter;
    }
}

