/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.utilities.IOMessageCause;
import com.hello2morrow.foundation.utilities.OperationResult;
import com.hello2morrow.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.FileScriptOutputStream;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.NullScriptOutputStream;
import de.schlichtherle.truezip.file.TFile;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class ScriptOutputStreamProvider {
    public OperationResultWithOutcome<OutputStream> beforeScriptExecution(String identifyingPath, String runConfigName, boolean isAutomated, String outputPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'attachToOutputStream' must not be empty";
        assert (runConfigName != null) : "Parameter 'runConfigName' of method 'beforeScriptExecution' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Creating output stream for script '" + identifyingPath + "'");
        if (outputPath == null || outputPath.trim().length() == 0) {
            result.setOutcome((Object)new NullScriptOutputStream());
            return result;
        }
        try {
            result.setOutcome((Object)this.createFileOutputStream(outputPath, isAutomated));
        }
        catch (Throwable t2) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NOT_A_FILE, t2.getLocalizedMessage(), new Object[0]);
            result.setOutcome((Object)new NullScriptOutputStream());
        }
        return result;
    }

    public static String adaptOutputPath(String outputPath, boolean isAutomated) {
        assert (outputPath != null && outputPath.length() > 0) : "Parameter 'outputPath' of method 'adaptOutputPath' must not be empty";
        if (!isAutomated) {
            return outputPath;
        }
        if (FileUtility.hasExtension((String)outputPath)) {
            String withoutExtension = FileUtility.removeExtension((String)outputPath);
            String extension = outputPath.substring(withoutExtension.length(), outputPath.length());
            return String.valueOf(withoutExtension) + "_automated" + extension;
        }
        return String.valueOf(outputPath) + "_automated";
    }

    protected final FileScriptOutputStream createFileOutputStream(String outputPath, boolean isAutomated) throws IOException {
        assert (outputPath != null && !outputPath.isEmpty()) : "Parameter 'outputPath' of method 'createFileOutputStream' must not be empty";
        String adaptedOutputPath = ScriptOutputStreamProvider.adaptOutputPath(outputPath, isAutomated);
        TFile outputFile = new TFile(adaptedOutputPath);
        if (!FileUtility.isValidName((String)outputFile.getName())) {
            throw new IOException("Invalid file name '" + outputFile.getName() + "' for script output path.");
        }
        if (outputFile.isDirectory()) {
            throw new IOException("Script output path '" + outputPath + "' collides with a directory having the same name.");
        }
        if (outputFile.getParentFile() != null) {
            outputFile.getParentFile().mkdir(true);
        }
        if (outputFile.exists()) {
            outputFile.rm();
        }
        return new FileScriptOutputStream(adaptedOutputPath);
    }

    public void clearAllOutputStreams() {
    }

    public void releaseOutputStreams(List<GroovyScript> scripts, List<FileBasedRunConfiguration> runConfigs) {
    }

    public void releaseAllOutputStreams() {
    }

    public void afterScriptExecution(String identifyingPath, String runConfigName, boolean isAutomated) throws IOException {
    }

    public void automatedScriptsUpdate(List<ScriptRunnerData> scriptRunnerData) {
    }

    public void renameOutputStreams(Map<GroovyScript, String> movedScripts, Map<FileBasedRunConfiguration, String> movedRunConfigs) {
    }
}

