/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricScope;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.script.IScriptMetricId;
import com.hello2morrow.sonargraph.core.model.script.MetricSorting;
import com.hello2morrow.sonargraph.core.model.script.ScriptProviderId;
import java.util.Arrays;
import java.util.List;

public final class ScriptMetricId
implements IMetricId.IMetricRange,
IScriptMetricId {
    private static final String SCRIPT_CATEGORY_NAME = "Script";
    private final ScriptProviderId m_providerId;
    private final String m_id;
    private final String m_presentationName;
    private final String m_description;
    private final boolean m_isFloat;
    private final Number m_lowerThreshold;
    private final Number m_upperThreshold;
    private final double m_minValue;
    private final double m_maxValue;
    private final Severity m_severity;
    private final IMetricId.StandardSorting m_sorting;
    private final IMetricCategory[] m_categories;

    public ScriptMetricId(String identifyingScriptPath, String id, String presentationName, String description, boolean isFloat, Number lowerThreshold, Number upperThreshold, MetricSorting sorting, double minValue, double maxValue, Severity severity, IMetricCategory[] coreMetricCategories, String ... categoryIds) {
        assert (identifyingScriptPath != null && identifyingScriptPath.length() > 0) : "Parameter 'identifyingScriptPath' of method 'ScriptMetricId' must not be empty";
        assert (severity != null) : "Parameter 'severity' of method 'ScriptMetricId' must not be null";
        assert (id != null) : "Parameter 'id' of method 'ScriptMetricId' must not be null";
        assert (presentationName != null) : "Parameter 'presentationName' of method 'ScriptMetricId' must not be null";
        assert (description != null) : "Parameter 'description' of method 'ScriptMetricId' must not be null";
        assert (sorting != null) : "Parameter 'sorting' of method 'ScriptMetricId' must not be null";
        this.m_providerId = new ScriptProviderId(identifyingScriptPath);
        this.m_id = id;
        this.m_description = description;
        this.m_presentationName = presentationName;
        this.m_isFloat = isFloat;
        this.m_lowerThreshold = lowerThreshold;
        this.m_upperThreshold = upperThreshold;
        this.m_minValue = minValue;
        this.m_maxValue = maxValue;
        this.m_severity = severity;
        this.m_sorting = sorting.getSorting();
        if (categoryIds == null || categoryIds.length == 0) {
            this.m_categories = new IMetricCategory[]{new ScriptMetricCategory(SCRIPT_CATEGORY_NAME)};
        } else {
            this.m_categories = new IMetricCategory[categoryIds.length + 1];
            int count = 0;
            String[] stringArray = categoryIds;
            int n2 = categoryIds.length;
            int n3 = 0;
            while (n3 < n2) {
                String next = stringArray[n3];
                boolean matchesCoreCategory = false;
                IMetricCategory[] iMetricCategoryArray = coreMetricCategories;
                int n4 = coreMetricCategories.length;
                int n5 = 0;
                while (n5 < n4) {
                    IMetricCategory category = iMetricCategoryArray[n5];
                    if (category.getStandardName().trim().equalsIgnoreCase(next.trim())) {
                        this.m_categories[count++] = category;
                        matchesCoreCategory = true;
                        break;
                    }
                    ++n5;
                }
                if (!matchesCoreCategory) {
                    this.m_categories[count++] = new ScriptMetricCategory(next);
                }
                ++n3;
            }
            this.m_categories[count] = new ScriptMetricCategory(SCRIPT_CATEGORY_NAME);
        }
    }

    public ScriptMetricId(String identifyingScriptPath, String id, String presentationName, String description, boolean isFloat, Number lower, Number upper, Severity severity, IMetricCategory[] coreMetricCategories, String ... categoryIds) {
        this(identifyingScriptPath, id, presentationName, description, isFloat, lower, upper, MetricSorting.HIGHER_WORSE, 0.0, Double.POSITIVE_INFINITY, severity, coreMetricCategories, categoryIds);
    }

    @Override
    public MetricScope getMetricScope() {
        return MetricScope.SYSTEM;
    }

    public String getStandardName() {
        return this.m_id;
    }

    @Override
    public IProviderId getProvider() {
        return this.m_providerId;
    }

    public String getPresentationName() {
        return this.m_presentationName;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public boolean isFloat() {
        return this.m_isFloat;
    }

    @Override
    public Number getLowerThreshold() {
        return this.m_lowerThreshold;
    }

    @Override
    public Number getUpperThreshold() {
        return this.m_upperThreshold;
    }

    @Override
    public IMetricId.IMetricRange getRange() {
        return this;
    }

    @Override
    public IMetricId.StandardSorting getSorting() {
        return this.m_sorting;
    }

    @Override
    public double getMinValue() {
        return this.m_minValue;
    }

    @Override
    public double getMaxValue() {
        return this.m_maxValue;
    }

    @Override
    public boolean isViolatedBy(Number value) {
        if (value != null) {
            if (this.isFloat()) {
                float f2 = value.floatValue();
                if (this.getLowerThreshold() != null && this.getLowerThreshold().floatValue() > f2) {
                    return true;
                }
                if (this.getUpperThreshold() != null && this.getUpperThreshold().floatValue() < f2) {
                    return true;
                }
            } else {
                int i2 = value.intValue();
                if (this.getLowerThreshold() != null && this.getLowerThreshold().intValue() > i2) {
                    return true;
                }
                if (this.getUpperThreshold() != null && this.getUpperThreshold().intValue() < i2) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Severity getSeverity() {
        return this.m_severity;
    }

    @Override
    public void setSeverity(Severity severity) {
        assert (false);
    }

    public String toString() {
        return this.m_id;
    }

    @Override
    public List<IMetricCategory> getCategories() {
        return Arrays.asList(this.m_categories);
    }

    @Override
    public void setLowerThreshold(Number n2) {
        assert (false) : "setLowerThreshold() should not be called on ScriptMetricId";
    }

    @Override
    public void setUpperThreshold(Number n2) {
        assert (false) : "setUpperThreshold() should not be called on ScriptMetricId";
    }

    @Override
    public IMetricDescriptor getMetricDescriptor() {
        assert (false) : "getMetricDescriptor() should not be called on ScriptMetricId";
        return null;
    }

    @Override
    public String getInformation() {
        return this.m_presentationName;
    }

    @Override
    public String getKey() {
        assert (false) : "getKey() should not be called on ScriptMetricId";
        return null;
    }

    @Override
    public String getValue() {
        assert (false) : "getValue() should not be called on ScriptMetricId";
        return null;
    }

    @Override
    public boolean isScriptThreshold() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_categories);
        result = 31 * result + (this.m_description == null ? 0 : this.m_description.hashCode());
        result = 31 * result + (this.m_id == null ? 0 : this.m_id.hashCode());
        result = 31 * result + (this.m_isFloat ? 1231 : 1237);
        result = 31 * result + (this.m_lowerThreshold == null ? 0 : this.m_lowerThreshold.hashCode());
        result = 31 * result + (this.m_presentationName == null ? 0 : this.m_presentationName.hashCode());
        result = 31 * result + (this.m_providerId == null ? 0 : this.m_providerId.hashCode());
        result = 31 * result + (this.m_upperThreshold == null ? 0 : this.m_upperThreshold.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptMetricId other = (ScriptMetricId)obj;
        if (!Arrays.equals(this.m_categories, other.m_categories)) {
            return false;
        }
        if (this.m_description == null ? other.m_description != null : !this.m_description.equals(other.m_description)) {
            return false;
        }
        if (this.m_id == null ? other.m_id != null : !this.m_id.equals(other.m_id)) {
            return false;
        }
        if (this.m_isFloat != other.m_isFloat) {
            return false;
        }
        if (this.m_lowerThreshold == null ? other.m_lowerThreshold != null : !this.m_lowerThreshold.equals(other.m_lowerThreshold)) {
            return false;
        }
        if (this.m_presentationName == null ? other.m_presentationName != null : !this.m_presentationName.equals(other.m_presentationName)) {
            return false;
        }
        if (this.m_providerId == null ? other.m_providerId != null : !this.m_providerId.equals(other.m_providerId)) {
            return false;
        }
        return !(this.m_upperThreshold == null ? other.m_upperThreshold != null : !this.m_upperThreshold.equals(other.m_upperThreshold));
    }

    private static class ScriptMetricCategory
    implements IMetricCategory {
        private final String m_name;

        public ScriptMetricCategory(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ScriptMetricCategory' must not be empty";
            this.m_name = name;
        }

        public String getStandardName() {
            return this.m_name;
        }

        public String getPresentationName() {
            return this.m_name;
        }

        @Override
        public int getOrderNumber() {
            return 0x7FFFFFFE;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ScriptMetricCategory other = (ScriptMetricCategory)obj;
            return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
        }
    }
}

