/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.script.DefaultRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.IParameterDefinitionProvider;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.IntegerParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinitionFactory;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationNameFilter;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import com.hello2morrow.sonargraph.core.model.script.StringParameterDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ScriptContent
extends NamedElementContainer
implements IParameterDefinitionProvider {
    private static final String DEFAULT_NEW_SCRIPT_CONTENT = "//Create visitor. For language specific visitor use <language>Access.createVisitor()" + StringUtility.DEFAULT_LINE_SEPARATOR + "ICoreVisitor v = coreAccess.createVisitor()" + StringUtility.DEFAULT_LINE_SEPARATOR + StringUtility.DEFAULT_LINE_SEPARATOR + "//Example stub-method to process types." + StringUtility.DEFAULT_LINE_SEPARATOR + "v.onType" + StringUtility.DEFAULT_LINE_SEPARATOR + "{" + StringUtility.DEFAULT_LINE_SEPARATOR + "\tITypeAccess type ->" + StringUtility.DEFAULT_LINE_SEPARATOR + "\tif(type.isExternal() || type.isExcluded())" + StringUtility.DEFAULT_LINE_SEPARATOR + "\t{" + StringUtility.DEFAULT_LINE_SEPARATOR + "\t\treturn" + StringUtility.DEFAULT_LINE_SEPARATOR + "\t}" + StringUtility.DEFAULT_LINE_SEPARATOR + "\t//Add elements so they show up in the elements tab, so we know what has been processed." + StringUtility.DEFAULT_LINE_SEPARATOR + "\tresult.addElement(type)" + StringUtility.DEFAULT_LINE_SEPARATOR + StringUtility.DEFAULT_LINE_SEPARATOR + "\t//Continue visiting..." + StringUtility.DEFAULT_LINE_SEPARATOR + "\tv.visitChildren(type)" + StringUtility.DEFAULT_LINE_SEPARATOR + "}" + StringUtility.DEFAULT_LINE_SEPARATOR + "//Traverse the model" + StringUtility.DEFAULT_LINE_SEPARATOR + "coreAccess.visitModel(v)" + StringUtility.DEFAULT_LINE_SEPARATOR + StringUtility.DEFAULT_LINE_SEPARATOR + "//If you know exactly which elements you want to find, use the search API (check the JavaDoc [F1] for details):" + StringUtility.DEFAULT_LINE_SEPARATOR + "//" + StringUtility.DEFAULT_LINE_SEPARATOR + "//ElementAccess systemOut = coreAccess.findElementByFqn(\"Workspace:External [Java]:[Unknown]:java:lang:System:System:out\")" + StringUtility.DEFAULT_LINE_SEPARATOR + "//println \"Found system out: \" + (systemOut != null)" + StringUtility.DEFAULT_LINE_SEPARATOR;
    private final String m_description;
    private final Set<Language> m_languages;
    private String m_source;

    private ScriptContent(Builder builder) {
        super(null);
        assert (builder != null) : "Parameter 'builder' of method 'ScriptContent' must not be null";
        this.m_description = builder.m_description;
        this.m_source = builder.m_source;
        for (ParameterDefinition.Builder pdBuilder : builder.m_parameterDefinitions) {
            ParameterDefinition parameterDefinition = pdBuilder.build();
            parameterDefinition.setParent(this);
            this.addChild(parameterDefinition);
        }
        RunConfigurationParameters data = new RunConfigurationParameters();
        for (ParameterDefinition<?> next : this.getParameterDefinitions()) {
            data.setParameterValue(next.getName(), next.getDefaultValue());
        }
        DefaultRunConfiguration defaultRunConfiguration = new DefaultRunConfiguration(this, data, this);
        this.addChild(defaultRunConfiguration);
        this.m_languages = builder.m_languages;
        assert (this.m_description != null) : "m_description must not be null";
        assert (this.m_source != null) : "m_source must not be null";
        assert (this.m_languages != null) : "m_languages must not be null";
    }

    @Override
    public String getShortName() {
        return "ScriptContent";
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public String getSource() {
        return this.m_source;
    }

    public void setSource(String newSource) {
        this.m_source = newSource;
    }

    @Override
    public List<ParameterDefinition<?>> getParameterDefinitions() {
        ArrayList definitions = new ArrayList();
        for (ParameterDefinition next : this.getChildren(ParameterDefinition.class)) {
            definitions.add(next);
        }
        return definitions;
    }

    public Set<Language> getLanguages() {
        return this.m_languages;
    }

    public List<IRunConfiguration> getRunConfigurations() {
        return this.getChildren(IRunConfiguration.class);
    }

    public List<FileBasedRunConfiguration> getFileBasedRunConfigurations() {
        return this.getChildren(FileBasedRunConfiguration.class);
    }

    public IRunConfiguration getRunConfiguration(String runConfigurationName) {
        return this.getUniqueChild(new RunConfigurationNameFilter(runConfigurationName), IRunConfiguration.class);
    }

    public DefaultRunConfiguration getDefaultRunConfiguration() {
        return this.getUniqueExistingChild(DefaultRunConfiguration.class);
    }

    public boolean isRunConfiguration(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'isRunConfiguration' must not be null";
        for (FileBasedRunConfiguration next : this.getChildren(FileBasedRunConfiguration.class)) {
            if (next != modifiableFile) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> getDefaultParameters() {
        return this.getDefaultRunConfiguration().getAllParameters();
    }

    @Override
    public ParameterDefinition<?> getParameterDefinition(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'parameterName' of method 'getParameterDefinition' must not be empty";
        for (ParameterDefinition<?> parameter : this.getParameterDefinitions()) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @Override
    public String getParameterDefinitionInfo() {
        List<ParameterDefinition<?>> parameterDefinitions = this.getParameterDefinitions();
        if (parameterDefinitions.isEmpty()) {
            return "No parameter definitions";
        }
        StringBuilder sb = new StringBuilder();
        for (ParameterDefinition<?> next : parameterDefinitions) {
            String nextName = next.getName();
            Object nextValue = next.getDefaultValue();
            String type = next.getType().getPresentationName();
            sb.append(nextName);
            sb.append(" [");
            sb.append(type);
            sb.append("] : '");
            sb.append(nextValue);
            sb.append("'");
            if (next.isPredefined()) {
                sb.append(" (predefined)");
            }
            sb.append(StringUtility.LINE_SEPARATOR);
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - StringUtility.LINE_SEPARATOR.length(), sb.length());
        }
        sb.trimToSize();
        return sb.toString();
    }

    public static final class Builder {
        private String m_description;
        private String m_source;
        private final List<ParameterDefinition.Builder> m_parameterDefinitions;
        private final Set<Language> m_languages;

        public Builder(ScriptContent toBeCopied) {
            assert (toBeCopied != null) : "Parameter 'toBeCopied' of method 'Builder' must not be null";
            this.m_description = toBeCopied.m_description;
            this.m_source = toBeCopied.m_source;
            this.m_languages = new HashSet<Language>(toBeCopied.m_languages);
            this.m_parameterDefinitions = new ArrayList<ParameterDefinition.Builder>();
            for (ParameterDefinition<?> parameterDefinition : toBeCopied.getParameterDefinitions()) {
                this.m_parameterDefinitions.add(ParameterDefinitionFactory.copy(parameterDefinition.getName(), parameterDefinition));
            }
        }

        public Builder() {
            this.m_description = "";
            this.m_source = DEFAULT_NEW_SCRIPT_CONTENT;
            this.m_parameterDefinitions = new ArrayList<ParameterDefinition.Builder>();
            this.m_parameterDefinitions.add(new IntegerParameterDefinition.Builder("timeout").defaultValue(10).description("When scripts are scheduled for automated execution they time out after the specified number of seconds. The timeout must be greater than '0'.").predefined(true));
            this.m_parameterDefinitions.add(new StringParameterDefinition.Builder("output").defaultValue("").description("When a path is specified the output of the script is written into this file. The use of an absolute path (i.e. starting with '/' or 'C:/') is not recommended. It might not be cross-platform compatible.").predefined(true));
            this.m_languages = new HashSet<Language>();
        }

        public String getDescription() {
            return this.m_description;
        }

        public List<ParameterDefinition.Builder> getParameterDefinitions() {
            return Collections.unmodifiableList(this.m_parameterDefinitions);
        }

        public Set<Language> getLanguages() {
            return Collections.unmodifiableSet(this.m_languages);
        }

        public Builder description(String description) {
            assert (description != null) : "Parameter 'description' of method 'description' must not be null";
            this.m_description = description;
            return this;
        }

        public Builder source(String source) {
            assert (source != null) : "Parameter 'source' of method 'source' must not be null";
            this.m_source = source;
            return this;
        }

        public Builder languages(Set<Language> languages) {
            assert (languages != null) : "Parameter 'languages' of method 'languages' must not be null";
            assert (this.m_languages != null) : "'m_languages' of method 'languages' must not be null";
            this.m_languages.clear();
            this.m_languages.addAll(languages);
            return this;
        }

        public Builder languages(Language ... languages) {
            return this.languages(new HashSet<Language>(Arrays.asList(languages)));
        }

        public Builder parameterDefinitions(List<ParameterDefinition.Builder> newParameters) {
            HashMap<String, Integer> parameterNameToNewPos;
            assert (newParameters != null) : "Parameter 'newParameters' of method 'parameterDefinitions' must not be null";
            assert (this.m_parameterDefinitions != null) : "'m_parameterDefinitions' of method 'parameterDefinitions' must not be null";
            if (!newParameters.isEmpty()) {
                parameterNameToNewPos = new HashMap<String, Integer>();
                int pos = 0;
                for (String nextPredefined : IRunConfiguration.PREDEFINED) {
                    boolean foundPredefinedInNewParameters = false;
                    for (ParameterDefinition.Builder nextNewParameter : newParameters) {
                        if (!nextPredefined.equals(nextNewParameter.getName())) continue;
                        foundPredefinedInNewParameters = true;
                        break;
                    }
                    if (foundPredefinedInNewParameters) continue;
                    parameterNameToNewPos.put(nextPredefined, pos);
                }
                for (ParameterDefinition.Builder nextParameter : newParameters) {
                    parameterNameToNewPos.put(nextParameter.getName(), pos);
                    ++pos;
                }
            } else {
                parameterNameToNewPos = null;
            }
            this.m_parameterDefinitions.removeIf(n2 -> !n2.isPredefined());
            HashMap<String, ParameterDefinition.Builder> currentPredefined = new HashMap<String, ParameterDefinition.Builder>();
            for (ParameterDefinition.Builder nextBuilder : this.m_parameterDefinitions) {
                currentPredefined.put(nextBuilder.getName(), nextBuilder);
            }
            if (!newParameters.isEmpty()) {
                assert (parameterNameToNewPos != null) : "'parameterNameToNewPos' of method 'parameterDefinitions' must not be null";
                for (ParameterDefinition.Builder nextBuilder : newParameters) {
                    String nextName = nextBuilder.getName();
                    if (IRunConfiguration.PREDEFINED.contains(nextName)) {
                        ParameterDefinition.Builder foundPredefined = (ParameterDefinition.Builder)currentPredefined.get(nextName);
                        assert (foundPredefined != null) : "'foundPredefined' of method 'parameterDefinitions' must not be null";
                        foundPredefined.defaultValue(nextBuilder.getDefaultValue());
                        continue;
                    }
                    this.m_parameterDefinitions.add(nextBuilder);
                }
                Collections.sort(this.m_parameterDefinitions, new Comparator<ParameterDefinition.Builder>(){

                    @Override
                    public int compare(ParameterDefinition.Builder p1, ParameterDefinition.Builder p2) {
                        if (!$assertionsDisabled && p1 == null) {
                            throw new AssertionError((Object)"Parameter 'p1' of method 'parameterDefinitions' must not be null");
                        }
                        if (!$assertionsDisabled && p2 == null) {
                            throw new AssertionError((Object)"Parameter 'p2' of method 'parameterDefinitions' must not be null");
                        }
                        if (!$assertionsDisabled && p1 == p2) {
                            throw new AssertionError((Object)"Same instances");
                        }
                        Integer posP1 = (Integer)parameterNameToNewPos.get(p1.getName());
                        if (!$assertionsDisabled && posP1 == null) {
                            throw new AssertionError((Object)"'posP1' of method 'parameterDefinitions' must not be null");
                        }
                        Integer posP2 = (Integer)parameterNameToNewPos.get(p2.getName());
                        if (!$assertionsDisabled && posP2 == null) {
                            throw new AssertionError((Object)"'posP2' of method 'parameterDefinitions' must not be null");
                        }
                        return posP1.compareTo(posP2);
                    }
                });
            }
            return this;
        }

        public Builder parameterDefinitions(ParameterDefinition.Builder ... parameters) {
            return this.parameterDefinitions(new ArrayList<ParameterDefinition.Builder>(Arrays.asList(parameters)));
        }

        public ScriptContent build() {
            return new ScriptContent(this);
        }
    }
}

