/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.foundation.utilities.StringUtility;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class RunConfigurationParameters {
    private final Map<String, Object> m_parameterValues = new LinkedHashMap<String, Object>();

    public static String getParameterInfo(String defaultRunConfigurationName, Map<String, Object> defaultParameters, Map<String, Object> currentParameters) {
        assert (defaultRunConfigurationName != null && defaultRunConfigurationName.length() > 0) : "Parameter 'defaultRunConfigurationName' of method 'getParameterInfo' must not be empty";
        assert (defaultParameters != null) : "Parameter 'defaultParameters' of method 'getParameterInfo' must not be null";
        assert (currentParameters != null) : "Parameter 'currentParameters' of method 'getParameters' must not be null";
        for (String nextNameFromCurrent : currentParameters.keySet()) {
            assert (defaultParameters.containsKey(nextNameFromCurrent)) : "Parameter not found in defaults: " + nextNameFromCurrent;
        }
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(defaultParameters);
        parameters.putAll(currentParameters);
        if (parameters.isEmpty()) {
            return "No parameters";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry next : parameters.entrySet()) {
            String nextName = (String)next.getKey();
            Object nextValue = next.getValue();
            sb.append(nextName);
            sb.append(" [");
            sb.append(nextValue.getClass().getSimpleName());
            sb.append("] : '");
            sb.append(nextValue);
            sb.append("'");
            if (!currentParameters.containsKey(nextName)) {
                sb.append(" (from ");
                sb.append(defaultRunConfigurationName);
                sb.append(")");
            }
            sb.append(StringUtility.LINE_SEPARATOR);
        }
        if (sb.length() > 0) {
            sb.delete(sb.length() - StringUtility.LINE_SEPARATOR.length(), sb.length());
        }
        sb.trimToSize();
        return sb.toString();
    }

    public RunConfigurationParameters() {
    }

    public RunConfigurationParameters(RunConfigurationParameters toBeCopied) {
        assert (toBeCopied != null) : "Parameter 'toBeCopied' of method 'RunConfigurationData' must not be null";
        this.m_parameterValues.putAll(toBeCopied.getParameters());
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.m_parameterValues);
    }

    public void setParameterValue(String name, Object value) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setParameterValue' must not be empty";
        this.m_parameterValues.put(name, value);
    }

    public void removeParameterValue(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'removeParameterValue' must not be empty";
        this.m_parameterValues.remove(name);
    }

    public Object getParameterValue(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getParameterValue' must not be empty";
        return this.m_parameterValues.get(name);
    }

    public Set<String> getMissingParameters(RunConfigurationParameters parameters) {
        assert (parameters != null) : "Parameter 'parameters' of method 'getObsoleteParameterNames' must not be null";
        if (this != parameters) {
            HashSet<String> missingParameters = new HashSet<String>(parameters.m_parameterValues.keySet());
            missingParameters.removeIf(n2 -> this.m_parameterValues.containsKey(n2));
            return missingParameters;
        }
        return Collections.emptySet();
    }

    public int hashCode() {
        return this.m_parameterValues.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RunConfigurationParameters other = (RunConfigurationParameters)obj;
        return this.m_parameterValues.equals(other.m_parameterValues);
    }
}

