/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.UniqueNameValidator;
import java.util.List;
import org.codehaus.groovy.tools.Utilities;

public final class ParameterNameValidator
extends UniqueNameValidator
implements ITextValidator {
    public ParameterNameValidator(List<ParameterDefinition.Builder> parameters) {
        assert (parameters != null) : "Parameter 'parameters' of method 'ParameterNameValidator' must not be null";
        for (ParameterDefinition.Builder parameter : parameters) {
            boolean added = this.addName(parameter.getName());
            assert (added) : "Duplicate parameter names are not allowed";
        }
    }

    public ParameterNameValidator(List<ParameterDefinition.Builder> parameters, ParameterDefinition.Builder parameterToBeEdited) {
        this(parameters);
        assert (parameterToBeEdited != null) : "Parameter 'parameterToBeEdited' of method 'ParameterNameValidator' must not be null";
        this.removeName(parameterToBeEdited.getName());
    }

    @Override
    public ValidationResult isValid(String initialInput, String newInput) {
        boolean inputHasChanged = !StringUtility.areEqual((String)initialInput, (String)newInput);
        ValidationResult result = new ValidationResult(inputHasChanged);
        if (newInput == null || newInput.trim().length() == 0) {
            result.addError("Parameter name must not be empty");
        } else if (!this.isNameUnique(newInput)) {
            result.addError("Parameter name already exists");
        } else if (!Utilities.isJavaIdentifier((String)newInput)) {
            result.addError("Parameter name must be a valid Java Identifier");
        }
        return result;
    }
}

