/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.script.BooleanParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.IntegerParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterType;
import com.hello2morrow.sonargraph.core.model.script.StringParameterDefinition;

public final class ParameterDefinitionFactory {
    private ParameterDefinitionFactory() {
    }

    public static ParameterDefinition.Builder<?> create(ParameterType type, String name) {
        ParameterDefinition.Builder parameterDefinition;
        assert (type != null) : "Parameter 'type' of method 'createParameter' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createParameter' must not be empty";
        switch (type) {
            case INTEGER: {
                parameterDefinition = new IntegerParameterDefinition.Builder(name);
                break;
            }
            case BOOLEAN: {
                parameterDefinition = new BooleanParameterDefinition.Builder(name);
                break;
            }
            case STRING: {
                parameterDefinition = new StringParameterDefinition.Builder(name);
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + (Object)((Object)type);
                parameterDefinition = null;
            }
        }
        assert (parameterDefinition != null);
        parameterDefinition.predefined(IRunConfiguration.PREDEFINED.contains(name));
        return parameterDefinition;
    }

    public static ParameterDefinition.Builder<?> copy(String newName, ParameterDefinition toBeCopied) {
        assert (toBeCopied != null) : "Parameter 'toBeCopied' of method 'copyParameter' must not be null";
        ParameterDefinition.Builder<?> result = ParameterDefinitionFactory.create(toBeCopied.getType(), newName);
        result.description(toBeCopied.getDescription());
        result.predefined(toBeCopied.isPredefined());
        result.parseDefaultValue(toBeCopied.getDefaultValueAsString());
        result.candidates(toBeCopied.getPossibleValuesAsString());
        return result;
    }
}

