/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.foundation.file.FileUtility;
import com.hello2morrow.foundation.file.IFileType;
import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.element.ISoftwareSystemDefinitionElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IBaseDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiablePathListener;
import com.hello2morrow.sonargraph.core.model.script.IElementWithScriptRunnerStatus;
import com.hello2morrow.sonargraph.core.model.script.IParameterDefinitionProvider;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import de.schlichtherle.truezip.file.TFile;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class FileBasedRunConfiguration
extends FilePath
implements ISoftwareSystemDefinitionElement,
IModifiableFile,
IElementWithScriptRunnerStatus,
IRunConfiguration {
    public static final String SEPARATOR = "#";
    private final IModifiablePathListener m_listener;
    private IParameterDefinitionProvider m_parameterDefinitionProvider;
    private String m_fileId;
    private boolean m_needsSave;
    private RunConfigurationParameters m_parameters;
    private String m_description = "";
    private boolean m_isAutomated = false;

    public static String getFileName(String scriptNameWithoutExtension, String configurationName) {
        assert (scriptNameWithoutExtension != null && scriptNameWithoutExtension.length() > 0) : "Parameter 'scriptName' of method 'getFileName' must not be empty";
        assert (configurationName != null && configurationName.length() > 0) : "Parameter 'configurationName' of method 'getFileName' must not be empty";
        return scriptNameWithoutExtension + SEPARATOR + configurationName + CoreFileType.RUN_CONFIGURATION.getDefaultExtension();
    }

    public static String getScriptName(TFile runConfigurationFile) {
        assert (runConfigurationFile != null) : "Parameter 'runConfigurationFile' of method 'getScriptName' must not be null";
        String extension = FileUtility.getExtension((TFile)runConfigurationFile);
        assert (CoreFileType.RUN_CONFIGURATION.hasExtension(extension)) : "Extension is not a run configuration file extension: " + extension;
        String runConfigurationFileNameWithoutExtension = FileUtility.getFileNameWithoutExtension((TFile)runConfigurationFile);
        int pos = runConfigurationFileNameWithoutExtension.indexOf(SEPARATOR);
        assert (pos != -1) : "Not a valid run configuration name: " + runConfigurationFileNameWithoutExtension;
        return runConfigurationFileNameWithoutExtension.substring(0, pos);
    }

    public FileBasedRunConfiguration(NamedElement parent, TFile file, IBaseDirectory baseDirectory, RunConfigurationParameters parameters, IParameterDefinitionProvider parameterDefinitionProvider, IModifiablePathListener listener) {
        super(parent, file, baseDirectory);
        assert (parameters != null) : "Parameter 'parameters' of method 'FileBasedRunConfiguration' must not be null";
        assert (parameterDefinitionProvider != null) : "Parameter 'parameterDefinitionProvider' of method 'FileBasedRunConfiguration' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'RunConfiguration' must not be null";
        this.m_parameterDefinitionProvider = parameterDefinitionProvider;
        this.m_parameters = parameters;
        this.createNewFileId();
        this.m_listener = listener;
        this.m_listener.created(this);
    }

    public FileBasedRunConfiguration(NamedElement parent, TFile file, RunConfigurationParameters parameters, IParameterDefinitionProvider parameterDefinitionProvider, IModifiablePathListener listener) {
        super(parent, file);
        assert (parameters != null) : "Parameter 'parameters' of method 'FileBasedRunConfiguration' must not be null";
        assert (parameterDefinitionProvider != null) : "Parameter 'parameterDefinitionProvider' of method 'FileBasedRunConfiguration' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'RunConfiguration' must not be null";
        this.m_parameterDefinitionProvider = parameterDefinitionProvider;
        this.m_parameters = parameters;
        this.createNewFileId();
        this.m_listener = listener;
        this.m_listener.created(this);
    }

    @Override
    public NamedElement getNamedElement() {
        return this;
    }

    public void setRunConfigurationParameters(RunConfigurationParameters parameters) {
        assert (parameters != null) : "Parameter 'parameters' of method 'setRunConfigurationParameters' must not be null";
        this.m_parameters = parameters;
    }

    @Override
    public String getPresentationKind() {
        return "Script Run Configuration";
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
        this.m_description = description;
    }

    @Override
    public void reallocate() {
        String previousPath = this.getPath();
        DirectoryPath parent = this.getParent(DirectoryPath.class, new Class[0]);
        if (parent != null && !(parent instanceof IBaseDirectory)) {
            int pos = previousPath.lastIndexOf("/");
            assert (pos != -1) : "No path separator found: " + previousPath;
            String parentPath = parent.getPath();
            assert (parentPath != null && parentPath.length() > 0) : "'parentPath' of method 'reallocate' must not be empty";
            this.setPath(String.valueOf(parentPath) + previousPath.substring(pos));
        }
        this.resetFile();
        this.getFile();
        this.m_listener.pathModified(this, previousPath);
    }

    @Override
    public void setPath(TFile path) {
        String previousPath = this.getPath();
        super.setPath(path);
        this.m_listener.pathModified(this, previousPath);
    }

    public void reloaded(long timestamp) {
        this.setTimestamp(timestamp);
        this.m_needsSave = false;
        this.m_listener.reloaded(this);
    }

    @Override
    public void createNewFileId() {
        this.m_fileId = StringUtility.createTimebasedId((String)this.getName());
    }

    @Override
    public boolean existsOnDisk() {
        return true;
    }

    @Override
    public IFileType getFileType() {
        return CoreFileType.RUN_CONFIGURATION;
    }

    @Override
    public String getRunConfigurationName() {
        String shortName = this.getShortName();
        int startPos = shortName.indexOf(SEPARATOR);
        assert (startPos != -1) : "Invalid short name: " + shortName;
        int endPos = shortName.lastIndexOf(46);
        assert (endPos != -1) : "Invalid short name: " + shortName;
        return shortName.substring(startPos + 1, endPos);
    }

    @Override
    public Map<String, Object> getAllParameters() {
        LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>(this.m_parameterDefinitionProvider.getDefaultParameters());
        parameters.putAll(this.m_parameters.getParameters());
        return parameters;
    }

    @Override
    public Map<String, Object> getDefinedParameters() {
        return new HashMap<String, Object>(this.m_parameters.getParameters());
    }

    @Override
    @Property
    public String getParameterInfo() {
        return RunConfigurationParameters.getParameterInfo("[Default]", this.m_parameterDefinitionProvider.getDefaultParameters(), this.m_parameters.getParameters());
    }

    @Override
    public int getTimeout() {
        Object value = this.getAllParameters().get("timeout");
        assert (value != null && value instanceof Integer) : "Unexpected class in method 'getTimeout': " + value;
        return (Integer)value;
    }

    @Override
    public String getOutput() {
        Object value = this.getAllParameters().get("output");
        assert (value != null && value instanceof String) : "Unexpected class in method 'getOutput': " + value;
        return value.toString();
    }

    public void setParameterDefinitionProvider(IParameterDefinitionProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'setParameterDefinitionProvider' must not be null";
        this.m_parameterDefinitionProvider = provider;
    }

    public IParameterDefinitionProvider getParameterDefinitionProvider() {
        return this.m_parameterDefinitionProvider;
    }

    @Override
    public void remove() {
        this.m_listener.deleted(this);
        super.remove();
    }

    @Override
    public boolean needsSave() {
        return this.m_needsSave;
    }

    @Override
    public void setNeedsSave(boolean needsSave) {
        this.m_needsSave = needsSave;
        if (this.m_needsSave) {
            this.m_listener.modified(this);
        } else {
            this.m_listener.saved(this);
            this.resetTimestamp();
        }
    }

    @Override
    public String getFileId() {
        return this.m_fileId;
    }

    public RunConfigurationParameters getRunConfigurationParameters() {
        return this.m_parameters;
    }

    @Override
    public void resetTimestamp() {
        this.setTimestamp(this.getFile().lastModified());
    }

    @Override
    @Property
    public boolean isAutomated() {
        return this.m_isAutomated;
    }

    public boolean setAutomated(boolean isAutomated) {
        if (this.m_isAutomated != isAutomated) {
            this.m_isAutomated = isAutomated;
            this.m_listener.additionalInformationModified(this);
            return true;
        }
        return false;
    }
}

