/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BufferedOutputStream
extends ScriptOutputStream {
    private final String m_id;
    private final boolean m_isAutomated;
    private final StringBuilder m_buffer = new StringBuilder();
    private final StringBuilder m_delta = new StringBuilder();
    private List<IContentChangedListener> m_contentChangedListeners;

    public BufferedOutputStream(String id, boolean isAutomated) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'ConsoleOutputStream' must not be empty";
        this.m_id = id;
        this.m_isAutomated = isAutomated;
    }

    public boolean isAutomated() {
        return this.m_isAutomated;
    }

    public String getId() {
        return this.m_id;
    }

    public String getContent() {
        return this.m_buffer.toString();
    }

    public void copyContentTo(BufferedOutputStream target) {
        assert (target != null) : "Parameter 'target' of method 'copyContentTo' must not be null";
        target.m_buffer.append(this.m_buffer.toString());
    }

    public void addContentListener(IContentChangedListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'add' must not be null";
        if (this.m_contentChangedListeners == null) {
            this.m_contentChangedListeners = Collections.synchronizedList(new ArrayList(2));
        }
        assert (!this.m_contentChangedListeners.contains(listener)) : "Already added: " + listener;
        this.m_contentChangedListeners.add(listener);
    }

    public void removeContentListener(IContentChangedListener listener) {
        assert (listener != null) : "Parameter 'listener' of method 'remoe' must not be null";
        assert (this.m_contentChangedListeners != null) : "'m_listeners' of method 'remove' must not be null";
        assert (this.m_contentChangedListeners.contains(listener)) : "Not found: " + listener;
        this.m_contentChangedListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDelta() {
        if (this.m_delta.length() > 0) {
            this.m_buffer.append((CharSequence)this.m_delta);
            if (this.m_contentChangedListeners != null) {
                ArrayList<IContentChangedListener> listeners = new ArrayList<IContentChangedListener>(this.m_contentChangedListeners.size());
                List<IContentChangedListener> list = this.m_contentChangedListeners;
                synchronized (list) {
                    listeners.addAll(this.m_contentChangedListeners);
                }
                for (IContentChangedListener nextListener : listeners) {
                    nextListener.outputAdded(this, this.m_delta.toString());
                }
            }
            this.m_delta.setLength(0);
        }
    }

    public void reset() {
        boolean notify = this.m_contentChangedListeners != null && this.m_buffer.length() > 0;
        this.m_buffer.setLength(0);
        this.m_delta.setLength(0);
        if (notify) {
            for (IContentChangedListener nextListener : this.m_contentChangedListeners) {
                nextListener.outputCleared(this);
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.processDelta();
        super.flush();
    }

    @Override
    public void close() throws IOException {
        this.processDelta();
        super.close();
    }

    @Override
    public void println(Object message) {
        if (message != null) {
            this.m_delta.append(message.toString());
            this.m_delta.append(StringUtility.LINE_SEPARATOR);
            this.processDelta();
        }
    }

    @Override
    public void write(int b2) throws IOException {
        this.m_delta.append((char)b2);
        if (b2 == 10) {
            this.processDelta();
        }
    }

    public static interface IContentChangedListener {
        public void outputAdded(BufferedOutputStream var1, String var2);

        public void outputCleared(BufferedOutputStream var1);
    }
}

