/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterType;
import java.util.LinkedHashSet;
import java.util.Set;

public final class BooleanParameterDefinition
extends ParameterDefinition<Boolean> {
    private static final Set<Boolean> POSSIBLE_VALUES = new LinkedHashSet<Boolean>(2);

    static {
        POSSIBLE_VALUES.add(Boolean.TRUE);
        POSSIBLE_VALUES.add(Boolean.FALSE);
    }

    public BooleanParameterDefinition(Builder builder) {
        super(builder);
    }

    @Override
    public Boolean parse(String value) {
        assert (value != null) : "Parameter 'value' of method 'parse' must not be null";
        return Parser.parse(value);
    }

    @Override
    public Class<?> getParameterClass() {
        return Boolean.class;
    }

    @Override
    public ParameterType getType() {
        return ParameterType.BOOLEAN;
    }

    @Override
    public boolean hasPossibleValues() {
        return true;
    }

    @Override
    public Set<Boolean> getPossibleValues() {
        return POSSIBLE_VALUES;
    }

    @Override
    public String getPossibleValuesAsString() {
        return String.valueOf(Boolean.TRUE.toString()) + " " + Boolean.FALSE.toString();
    }

    public static class Builder
    extends ParameterDefinition.Builder<Boolean> {
        public Builder(String name) {
            super(name, (Boolean)ParameterType.BOOLEAN.getDefaultValue());
        }

        public BooleanParameterDefinition build() {
            return new BooleanParameterDefinition(this);
        }

        @Override
        protected Boolean parse(String value) {
            assert (value != null) : "Parameter 'value' of method 'parse' must not be null";
            return Parser.parse(value);
        }

        public Builder candidates(Set<Boolean> newCandidates) {
            return this;
        }

        public Builder candidates(String newCandidates) {
            return this;
        }
    }

    static final class Parser {
        Parser() {
        }

        public static Boolean parse(String value) {
            return Boolean.parseBoolean(value);
        }
    }
}

