/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IScriptApi;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.script.ScriptResultSet;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import groovy.lang.Script;

public final class AutomatedGroovyScript
extends NamedElementContainer
implements IGroovyScript {
    private final String m_identifyingPath;
    private IScriptApi m_scriptApi;
    private ClassLoader m_classLoader;
    private Script m_compiledScript;
    private IGroovyScript.Status m_status;
    private boolean m_isExecutable;

    public AutomatedGroovyScript(NamedElement parent, String identifyingPath) {
        super(parent);
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'AutomatedGroovyScript' must not be empty";
        this.m_identifyingPath = identifyingPath;
        this.m_status = IGroovyScript.Status.NONE;
        this.addChild(new ScriptResultSet(this, identifyingPath));
    }

    @Override
    @Property
    public String getShortName() {
        return this.m_identifyingPath;
    }

    @Override
    @Property
    public String getDescription() {
        return this.getScriptContent().getDescription();
    }

    @Override
    public String getPresentationKind() {
        return "Automated Script";
    }

    @Override
    public boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    @Override
    public ScriptContent getScriptContent() {
        return this.getUniqueExistingChild(ScriptContent.class);
    }

    public ScriptResultSet getResultSet() {
        ScriptResultSet resultSet = this.getUniqueChild(ScriptResultSet.class);
        assert (resultSet != null) : "'resultSet' of method 'getResultSet' must not be null";
        return resultSet;
    }

    @Override
    public String getIdentifyingPath() {
        return this.m_identifyingPath;
    }

    @Override
    public String getSource() {
        return this.getScriptContent().getSource();
    }

    @Override
    public void setIsExecutable(boolean isExecutable) {
        this.m_isExecutable = isExecutable;
    }

    @Override
    public boolean isExecutable() {
        return this.m_isExecutable;
    }

    @Override
    public void setCompiledScript(Script script) {
        this.m_compiledScript = script;
    }

    @Override
    public Script getCompiledScript() {
        return this.m_compiledScript;
    }

    @Override
    public String getImageResourceName() {
        return GroovyScript.class.getSimpleName();
    }

    @Override
    public void setStatus(IGroovyScript.Status status) {
        assert (status != null) : "Parameter 'status' of method 'setStatus' must not be null";
        this.m_status = status;
    }

    public IGroovyScript.Status getStatus() {
        return this.m_status;
    }

    @Override
    public void setScriptApiAndClassLoader(IScriptApi api, ClassLoader classLoader) {
        assert (api != null && classLoader != null || api == null && classLoader == null) : "Both null or both not null";
        this.m_scriptApi = api;
        this.m_classLoader = classLoader;
    }

    @Override
    public IScriptApi getScriptApi() {
        return this.m_scriptApi;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }
}

