/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.resolution;

import com.hello2morrow.foundation.utilities.IStandardEnumeration;
import com.hello2morrow.sonargraph.core.model.resolution.Resolution;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionApplicability;
import com.hello2morrow.sonargraph.core.model.resolution.ResolutionKind;
import java.util.HashSet;
import java.util.Set;

public final class ResolutionFilter {
    public static final Class<? extends IStandardEnumeration> APPLICABILITY = ResolutionApplicability.class;
    public static final Class<? extends IStandardEnumeration> KIND = ResolutionKind.class;
    private Set<ResolutionApplicability> m_applicabilities;
    private Set<ResolutionKind> m_kinds;

    private <T extends IStandardEnumeration> void refreshFilter(Class<? extends IStandardEnumeration> filterClass, Set<T> filters) {
        if (APPLICABILITY.isAssignableFrom(filterClass)) {
            this.m_applicabilities = filters;
        } else if (KIND.isAssignableFrom(filterClass)) {
            this.m_kinds = filters;
        } else assert (false) : "Unexpected class: " + filterClass.getName();
    }

    private <T extends IStandardEnumeration> Set<T> getSetOfFilters(Class<T> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getSetOfFilters' must not be null";
        if (APPLICABILITY.isAssignableFrom(clazz)) {
            return this.m_applicabilities;
        }
        if (KIND.isAssignableFrom(clazz)) {
            return this.m_kinds;
        }
        assert (false) : "Unexpected class: " + clazz.getName();
        return null;
    }

    public <T extends IStandardEnumeration> void add(T filter) {
        Set<?> filters = this.getSetOfFilters(filter.getClass());
        if (filters == null) {
            filters = new HashSet(5);
        }
        filters.add(filter);
        this.refreshFilter(filter.getClass(), filters);
    }

    private boolean matches(ResolutionApplicability applicability) {
        assert (applicability != null) : "Parameter 'applicability' of method 'matches' must not be null";
        if (this.m_applicabilities == null) {
            return true;
        }
        return this.m_applicabilities.contains((Object)applicability);
    }

    private boolean matches(ResolutionKind kind) {
        assert (kind != null) : "Parameter 'kind' of method 'matches' must not be null";
        if (this.m_kinds == null) {
            return true;
        }
        return this.m_kinds.contains((Object)kind);
    }

    public boolean accept(Resolution resolution) {
        ResolutionApplicability applicability;
        assert (resolution != null) : "Parameter 'resolution' of method 'accept' must not be null";
        ResolutionApplicability resolutionApplicability = applicability = resolution.getMatchingElementsCount() > 0 ? ResolutionApplicability.APPLICABLE : ResolutionApplicability.NOT_APPLICABLE;
        if (this.matches(applicability)) {
            return this.matches(resolution.getKind());
        }
        return false;
    }
}

